/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.swing.SwingUtilities;
import org.fest.swing.awt.AWT;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.input.DragDropInfo;
import org.fest.swing.input.EventNormalizer;
import org.fest.swing.input.MouseInfo;
import org.fest.swing.listener.EventDispatchThreadedEventListener;
import org.fest.util.Preconditions;

@ThreadSafe
public class InputState {
    @GuardedBy(value="this")
    private final MouseInfo mouseInfo;
    @GuardedBy(value="this")
    private final DragDropInfo dragDropInfo;
    @GuardedBy(value="this")
    private int modifiers;
    @GuardedBy(value="this")
    private long lastEventTime;
    private EventNormalizer normalizer;

    public InputState(@Nonnull Toolkit toolkit) {
        if (toolkit == null) {
            InputState.$$$reportNull$$$0(0);
        }
        this.mouseInfo = new MouseInfo();
        this.dragDropInfo = new DragDropInfo();
        long mask = 56L;
        EventDispatchThreadedEventListener listener = new EventDispatchThreadedEventListener(){

            @Override
            protected void processEvent(@Nonnull AWTEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                InputState.this.update(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "event", "org/fest/swing/input/InputState$1", "processEvent"));
            }
        };
        this.normalizer = new EventNormalizer();
        this.normalizer.startListening(toolkit, listener, mask);
    }

    public synchronized void clear() {
        this.mouseInfo.clear();
        this.dragDropInfo.clear();
        this.modifiers = 0;
        this.lastEventTime = 0L;
    }

    public void dispose() {
        this.normalizer.stopListening();
        this.normalizer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(@Nonnull AWTEvent event) {
        if (event == null) {
            InputState.$$$reportNull$$$0(1);
        }
        if (event instanceof InputEvent) {
            InputEvent inputEvent = (InputEvent)event;
            if (inputEvent.getWhen() < this.lastEventTime()) {
                return;
            }
            if (inputEvent instanceof KeyEvent) {
                InputState inputState = this;
                synchronized (inputState) {
                    this.lastEventTime(inputEvent);
                    this.modifiers(inputEvent.getModifiers());
                }
            }
            if (inputEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)inputEvent;
                Point eventScreenLocation = this.screenLocation(mouseEvent);
                InputState inputState = this;
                synchronized (inputState) {
                    this.lastEventTime(mouseEvent);
                    this.dragDropInfo.update(mouseEvent);
                    this.mouseInfo.modifiers(this.modifiers);
                    this.mouseInfo.update(mouseEvent, eventScreenLocation);
                    this.modifiers(this.mouseInfo.modifiers());
                }
            }
        }
    }

    @Nullable
    private Point screenLocation(@Nonnull MouseEvent event) {
        block4: {
            if (event == null) {
                InputState.$$$reportNull$$$0(2);
            }
            try {
                Component component = (Component)Preconditions.checkNotNull((Object)event.getComponent());
                return AWT.locationOnScreenOf(component);
            }
            catch (IllegalComponentStateException component) {
            }
            catch (UnexpectedException e) {
                if (e.getCause() instanceof IllegalComponentStateException) break block4;
                throw e;
            }
        }
        return null;
    }

    private synchronized void lastEventTime(@Nonnull InputEvent event) {
        if (event == null) {
            InputState.$$$reportNull$$$0(3);
        }
        this.lastEventTime = event.getWhen();
    }

    private synchronized void modifiers(int newModifiers) {
        this.modifiers = newModifiers;
    }

    @Nullable
    public synchronized Component deepestComponentUnderMousePointer() {
        Point mouseLocation;
        Component c = this.mouseComponent();
        if (c != null && (mouseLocation = this.mouseLocation()) != null) {
            c = InputState.childAt(c, mouseLocation);
        }
        return c;
    }

    @Nullable
    public synchronized Component mouseComponent() {
        return this.mouseInfo.component();
    }

    public static Component childAt(@Nonnull Component parent, @Nonnull Point where) {
        if (parent == null) {
            InputState.$$$reportNull$$$0(4);
        }
        if (where == null) {
            InputState.$$$reportNull$$$0(5);
        }
        return SwingUtilities.getDeepestComponentAt(parent, where.x, where.y);
    }

    public synchronized boolean dragInProgress() {
        return this.dragDropInfo.isDragging();
    }

    public synchronized Component dragSource() {
        return this.dragDropInfo.source();
    }

    public synchronized Point dragOrigin() {
        return this.dragDropInfo.origin();
    }

    public synchronized int clickCount() {
        return this.mouseInfo.clickCount();
    }

    public synchronized long lastEventTime() {
        return this.lastEventTime;
    }

    public synchronized int modifiers() {
        return this.modifiers;
    }

    public synchronized int keyModifiers() {
        return this.modifiers & 0xFFFFFFE3;
    }

    public synchronized int buttons() {
        return this.mouseInfo.buttons();
    }

    @Nullable
    public synchronized Point mouseLocation() {
        return this.mouseInfo.location();
    }

    @Nullable
    public synchronized Point mouseLocationOnScreen() {
        return this.mouseInfo.locationOnScreen();
    }

    public synchronized boolean isNativeDragActive() {
        return this.dragDropInfo.isNativeDragActive();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/input/InputState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "screenLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lastEventTime";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "childAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

