/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.util.Maps;
import org.fest.util.Sets;

class EventQueueMapping {
    final Map<Component, WeakReference<EventQueue>> queueMap = Maps.newWeakHashMap();

    EventQueueMapping() {
    }

    @RunsInCurrentThread
    void addQueueFor(@Nonnull Component c) {
        if (c == null) {
            EventQueueMapping.$$$reportNull$$$0(0);
        }
        EventQueue queue = c.getToolkit().getSystemEventQueue();
        this.queueMap.put(c, new WeakReference<EventQueue>(queue));
    }

    @Nullable
    @RunsInCurrentThread
    EventQueue queueFor(@Nonnull Component c) {
        EventQueue queue;
        if (c == null) {
            EventQueueMapping.$$$reportNull$$$0(1);
        }
        if ((queue = this.storedQueueFor(c)) == null) {
            return c.getToolkit().getSystemEventQueue();
        }
        return queue;
    }

    @Nullable
    EventQueue storedQueueFor(@Nonnull Component c) {
        if (c == null) {
            EventQueueMapping.$$$reportNull$$$0(2);
        }
        return this.queueFrom(this.queueMap.get(c));
    }

    @Nonnull
    Collection<EventQueue> eventQueues() {
        HashSet eventQueues = Sets.newHashSet();
        for (WeakReference<EventQueue> reference : this.queueMap.values()) {
            EventQueue queue = this.queueFrom(reference);
            if (queue == null) continue;
            eventQueues.add(queue);
        }
        HashSet hashSet = eventQueues;
        if (hashSet == null) {
            EventQueueMapping.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @Nullable
    private EventQueue queueFrom(@Nullable WeakReference<EventQueue> reference) {
        if (reference == null) {
            return null;
        }
        return (EventQueue)reference.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/monitor/EventQueueMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/monitor/EventQueueMapping";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "eventQueues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addQueueFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "queueFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "storedQueueFor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

