/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.timing;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Timeout;
import org.fest.swing.util.TimeoutWatch;
import org.fest.util.Arrays;
import org.fest.util.Preconditions;

public final class Pause {
    private static final int DEFAULT_DELAY = 30000;
    private static final int SLEEP_INTERVAL = 10;

    public static void pause(@Nonnull Condition condition) {
        if (condition == null) {
            Pause.$$$reportNull$$$0(0);
        }
        Pause.pause(condition, 30000L);
    }

    public static void pause(@Nonnull Condition condition, @Nonnull Timeout timeout) {
        if (condition == null) {
            Pause.$$$reportNull$$$0(1);
        }
        if (timeout == null) {
            Pause.$$$reportNull$$$0(2);
        }
        Preconditions.checkNotNull((Object)timeout);
        Pause.pause(condition, timeout.duration());
    }

    public static void pause(@Nonnull Condition condition, long timeout) {
        if (condition == null) {
            Pause.$$$reportNull$$$0(3);
        }
        Preconditions.checkNotNull((Object)condition);
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!condition.test()) {
            if (watch.isTimeOut() && !condition.test()) {
                condition.done();
                throw new WaitTimedOutError(String.format("Timed out waiting for %s", condition.toString()));
            }
            Pause.pause(10L);
        }
        condition.done();
    }

    public static void pause(@Nonnull Condition[] conditions) {
        if (conditions == null) {
            Pause.$$$reportNull$$$0(4);
        }
        Pause.pause(conditions, 30000L);
    }

    public static void pause(@Nonnull Condition[] conditions, @Nonnull Timeout timeout) {
        if (conditions == null) {
            Pause.$$$reportNull$$$0(5);
        }
        if (timeout == null) {
            Pause.$$$reportNull$$$0(6);
        }
        Pause.pause(conditions, timeout.duration());
    }

    public static void pause(@Nonnull Condition[] conditions, long timeout) {
        if (conditions == null) {
            Pause.$$$reportNull$$$0(7);
        }
        Preconditions.checkNotNullOrEmpty((Object[])conditions);
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!Pause.areSatisfied(conditions)) {
            if (watch.isTimeOut()) {
                for (Condition condition : conditions) {
                    condition.done();
                }
                throw new WaitTimedOutError(String.format("Timed out waiting for %s", Arrays.format((Object)conditions)));
            }
            Pause.pause(10L);
        }
        for (Condition condition : conditions) {
            condition.done();
        }
    }

    private static boolean areSatisfied(@Nonnull Condition[] conditions) {
        if (conditions == null) {
            Pause.$$$reportNull$$$0(8);
        }
        for (Condition condition : conditions) {
            Preconditions.checkNotNull((Object)condition);
            if (condition.test()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static void pause(long timeout, @Nonnull TimeUnit timeUnit) {
        void unit;
        if (timeUnit == null) {
            Pause.$$$reportNull$$$0(9);
        }
        Preconditions.checkNotNull((Object)unit);
        Pause.pause(unit.toMillis(timeout));
    }

    public static void pause(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void pause() {
        Pause.pause(10L);
    }

    private Pause() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeout";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/timing/Pause";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "pause";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "areSatisfied";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

