/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.server.MavenServerManager;

@State(name="MavenImportPreferences", storages={@Storage(value="$WORKSPACE_FILE$")})
public class MavenWorkspaceSettingsComponent
implements PersistentStateComponent<MavenWorkspaceSettings> {
    private MavenWorkspaceSettings mySettings = new MavenWorkspaceSettings();
    private final Project myProject;

    public MavenWorkspaceSettingsComponent(Project project) {
        this.myProject = project;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.mySettings.generalSettings.setMavenHome("Bundled (Maven 2)");
        } else {
            MavenWorkspaceSettingsComponent.applyDefaults(this.mySettings);
        }
    }

    public static MavenWorkspaceSettingsComponent getInstance(Project project) {
        return (MavenWorkspaceSettingsComponent)ServiceManager.getService((Project)project, MavenWorkspaceSettingsComponent.class);
    }

    @NotNull
    public MavenWorkspaceSettings getState() {
        MavenExplicitProfiles profiles = MavenProjectsManager.getInstance(this.myProject).getExplicitProfiles();
        this.mySettings.setEnabledProfiles(profiles.getEnabledProfiles());
        this.mySettings.setDisabledProfiles(profiles.getDisabledProfiles());
        MavenWorkspaceSettings mavenWorkspaceSettings = this.mySettings;
        if (mavenWorkspaceSettings == null) {
            MavenWorkspaceSettingsComponent.$$$reportNull$$$0(0);
        }
        return mavenWorkspaceSettings;
    }

    public void loadState(MavenWorkspaceSettings state) {
        this.mySettings = state;
        MavenWorkspaceSettingsComponent.applyDefaults(this.mySettings);
    }

    public MavenWorkspaceSettings getSettings() {
        return this.mySettings;
    }

    private static void applyDefaults(MavenWorkspaceSettings settings) {
        if (StringUtil.isEmptyOrSpaces((String)settings.generalSettings.getMavenHome())) {
            if (MavenServerManager.getInstance().isUsedMaven2ForProjectImport() || ApplicationManager.getApplication().isUnitTestMode()) {
                settings.generalSettings.setMavenHome("Bundled (Maven 2)");
            } else {
                settings.generalSettings.setMavenHome("Bundled (Maven 3)");
            }
        } else {
            MavenServerManager.getInstance().setMavenHome(settings.generalSettings.getMavenHome());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenWorkspaceSettingsComponent", "getState"));
    }
}

