/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.uml.java.JavaUmlDataModel;
import com.intellij.uml.java.actions.CreateNewInfo;
import com.intellij.uml.java.actions.NewClassOnUmlDialog;
import com.intellij.uml.utils.UmlBundle;
import com.intellij.uml.utils.UmlJavaUtils;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class CreateNewBase
extends DiagramCreateNewElementAction<PsiElement, CreateNewInfo> {
    protected CreateNewBase(String name, Icon icon) {
        super(name, null, icon);
    }

    protected abstract String getTitle();

    @Nullable
    protected abstract PsiClass create(PsiDirectory var1, String var2);

    public CreateNewInfo prepare(AnActionEvent e) {
        DiagramBuilder builder = CreateNewBase.getBuilder((AnActionEvent)e);
        if (builder != null) {
            DiagramNode node;
            PsiElement initialElement = ((JavaUmlDataModel)builder.getDataModel()).getInitialElement();
            PsiPackage psiPackage = null;
            List nodes = GraphViewUtil.getSelectedNodes((Graph2D)builder.getGraph());
            if (nodes.size() == 1 && (node = builder.getNodeObject((Node)nodes.get(0))) != null && node.getIdentifyingElement() instanceof PsiPackage) {
                psiPackage = (PsiPackage)node.getIdentifyingElement();
            }
            if (psiPackage == null) {
                psiPackage = UmlJavaUtils.getPackage(initialElement);
            }
            if (psiPackage == null) {
                return null;
            }
            NewClassOnUmlDialog dialog = new NewClassOnUmlDialog(psiPackage);
            dialog.setTitle("Create " + this.getTitle());
            dialog.show();
            if (dialog.getExitCode() != 0) {
                return null;
            }
            if (dialog.getPsiDirectory() != null) {
                return new CreateNewInfo(dialog.getClassName(), dialog.getPsiDirectory(), dialog.getPackage());
            }
        }
        return null;
    }

    public PsiElement createElement(DiagramDataModel<PsiElement> model, CreateNewInfo info, AnActionEvent event) {
        PsiDirectory directory = info.prepareDirectory();
        PsiClass cls = this.create(directory, info.fqn);
        if (cls == null) {
            ApplicationUtil.showDialogAfterWriteAction(() -> Messages.showErrorDialog((Project)model.getProject(), (String)UmlBundle.message("cant.create.element", info.fqn, directory.getVirtualFile().getPath()), (String)UmlBundle.message("error", new Object[0])));
            return null;
        }
        return cls;
    }
}

