/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.play.utils.PlayUtils;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayControllerActionPsiReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiElement originalElement;
        Module module;
        if (element == null) {
            PlayControllerActionPsiReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PlayControllerActionPsiReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)(originalElement = element.getOriginalElement()))) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PlayControllerActionPsiReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String text = ElementManipulators.getValueText((PsiElement)originalElement);
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PlayControllerActionPsiReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String actionName = text.startsWith("@") ? text.substring(1) : text;
        Set<PsiReference> references = PlayControllerActionPsiReferenceProvider.getActionNameReferences(originalElement, module, actionName, originalElement.getText().indexOf(actionName));
        PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
        if (psiReferenceArray == null) {
            PlayControllerActionPsiReferenceProvider.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    public static Set<PsiReference> getActionNameReferences(PsiElement psiElement, Module module, String actionName, Integer startOffset) {
        HashSet references = new HashSet();
        if (actionName.contains(".")) {
            String controller = actionName.substring(0, actionName.lastIndexOf("."));
            String action = actionName.substring(actionName.lastIndexOf(".") + 1);
            PsiClass controllerByName = PlayPathUtils.findControllerByName(controller, module);
            references.add(new ControllerPsiReference(psiElement, PlayControllerActionPsiReferenceProvider.createTextRange(startOffset, controller), controllerByName, module));
            if (controllerByName != null) {
                references.add(new ActionReference(psiElement, PlayControllerActionPsiReferenceProvider.createTextRange(startOffset + controller.length() + 1, action), controllerByName, action));
            }
        } else {
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            if (psiClass != null && PlayUtils.isController(psiClass)) {
                references.add(new LocalActionReference(psiElement, startOffset, actionName, psiClass, module));
            }
        }
        return references;
    }

    private static TextRange createTextRange(Integer startOffset, String name) {
        return new TextRange(startOffset.intValue(), startOffset + name.length());
    }

    private static List<PsiClass> getTopLevelControllers(@NotNull Module module) {
        PsiPackage psiPackage;
        if (module == null) {
            PlayControllerActionPsiReferenceProvider.$$$reportNull$$$0(5);
        }
        if ((psiPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage("controllers")) != null) {
            return Arrays.asList(psiPackage.getClasses(GlobalSearchScope.moduleWithDependenciesScope((Module)module)));
        }
        return new ArrayList<PsiClass>();
    }

    private static Set<PsiMethod> getActionMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PlayControllerActionPsiReferenceProvider.$$$reportNull$$$0(6);
        }
        HashSet names = new HashSet();
        for (PsiMethod psiMethod : psiClass.getAllMethods()) {
            if (!psiMethod.hasModifierProperty("static") || !psiMethod.hasModifierProperty("public")) continue;
            names.add(psiMethod);
        }
        return names;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/play/references/PlayControllerActionPsiReferenceProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/play/references/PlayControllerActionPsiReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelControllers";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getActionMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LocalActionReference
    extends ActionReference {
        private final PsiClass myPsiClass;
        private final Module myModule;

        public LocalActionReference(@NotNull PsiElement psiElement, int startOffset, @NotNull String actionName, @NotNull PsiClass psiClass, @NotNull Module module) {
            if (psiElement == null) {
                LocalActionReference.$$$reportNull$$$0(0);
            }
            if (actionName == null) {
                LocalActionReference.$$$reportNull$$$0(1);
            }
            if (psiClass == null) {
                LocalActionReference.$$$reportNull$$$0(2);
            }
            if (module == null) {
                LocalActionReference.$$$reportNull$$$0(3);
            }
            super(psiElement, PlayControllerActionPsiReferenceProvider.createTextRange(startOffset, actionName), psiClass, actionName);
            this.myPsiClass = psiClass;
            this.myModule = module;
        }

        @Override
        @NotNull
        public Object[] getVariants() {
            ArrayList variants = new ArrayList();
            variants.addAll(ContainerUtil.map((Collection)PlayControllerActionPsiReferenceProvider.getActionMethods(this.myPsiClass), psiMethod -> LookupElementBuilder.create((PsiNamedElement)psiMethod).withIcon(PlatformIcons.METHOD_ICON)));
            variants.addAll(PlayControllerActionPsiReferenceProvider.getTopLevelControllers(this.myModule));
            Object[] objectArray = variants.toArray(new Object[variants.size()]);
            if (objectArray == null) {
                LocalActionReference.$$$reportNull$$$0(4);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$LocalActionReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$LocalActionReference";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ActionReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiClass myController;
        private final String myAction;

        public ActionReference(@NotNull PsiElement psiElement, @NotNull TextRange textRange, @NotNull PsiClass controller, @NotNull String action) {
            if (psiElement == null) {
                ActionReference.$$$reportNull$$$0(0);
            }
            if (textRange == null) {
                ActionReference.$$$reportNull$$$0(1);
            }
            if (controller == null) {
                ActionReference.$$$reportNull$$$0(2);
            }
            if (action == null) {
                ActionReference.$$$reportNull$$$0(3);
            }
            super(psiElement, textRange);
            this.myController = controller;
            this.myAction = action;
        }

        public PsiElement resolve() {
            for (PsiMethod psiMethod : this.myController.getAllMethods()) {
                if (!psiMethod.getName().equals(this.myAction)) continue;
                return psiMethod;
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = ContainerUtil.map2Array((Collection)PlayControllerActionPsiReferenceProvider.getActionMethods(this.myController), LookupElementBuilder.class, s -> LookupElementBuilder.create((PsiNamedElement)s).withIcon(PlatformIcons.METHOD_ICON));
            if (objectArray == null) {
                ActionReference.$$$reportNull$$$0(4);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ActionReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ActionReference";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ControllerPsiReference
    extends PsiReferenceBase<PsiElement> {
        private PsiClass myControllerByName;
        private Module myModule;

        public ControllerPsiReference(@NotNull PsiElement psiElement, @NotNull TextRange textRange, @Nullable PsiClass controller, @NotNull Module module) {
            if (psiElement == null) {
                ControllerPsiReference.$$$reportNull$$$0(0);
            }
            if (textRange == null) {
                ControllerPsiReference.$$$reportNull$$$0(1);
            }
            if (module == null) {
                ControllerPsiReference.$$$reportNull$$$0(2);
            }
            super(psiElement, textRange);
            this.myControllerByName = controller;
            this.myModule = module;
        }

        public PsiElement resolve() {
            return this.myControllerByName;
        }

        public boolean isReferenceTo(PsiElement element) {
            return super.isReferenceTo(element);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                ControllerPsiReference.$$$reportNull$$$0(3);
            }
            if (element instanceof PsiClass) {
                this.myControllerByName = (PsiClass)element;
                return this.myControllerByName;
            }
            return super.bindToElement(element);
        }

        @NotNull
        public Object[] getVariants() {
            List controllers = PlayControllerActionPsiReferenceProvider.getTopLevelControllers(this.myModule);
            Object[] objectArray = controllers.toArray(new Object[controllers.size()]);
            if (objectArray == null) {
                ControllerPsiReference.$$$reportNull$$$0(4);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ControllerPsiReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/play/references/PlayControllerActionPsiReferenceProvider$ControllerPsiReference";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

