/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ArrayUtil;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.RSProjectComponent;
import com.intellij.ws.rest.actions.GenerateWadlFromJavaDialog;
import com.intellij.ws.rest.utils.RSUtils;
import com.intellij.ws.utils.BaseWSFromFileAction;
import com.intellij.ws.utils.ExternalProcessHandler;
import com.intellij.ws.utils.FileUtils;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GenerateWadlFromJavaAction
extends BaseWSFromFileAction {
    @NonNls
    private static final String WADL_EXT = ".wadl";
    @NonNls
    private static final String GEN_WADL_FQN = "com.intellij.ws.rest.GenerateWadlFromJava";

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        boolean visible = module != null && project != null && RSUtils.isRestLibAttached(module) && RSUtils.isRestLibAttached(module, "com.sun.jersey.server.impl.wadl.WadlFactory");
        e.getPresentation().setVisible(visible);
    }

    public void actionPerformed(AnActionEvent e) {
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module == null) {
            return;
        }
        GenerateWadlFromJavaAction.invokeDialog(module);
    }

    private static void invokeDialog(final @NotNull Module module) {
        if (module == null) {
            GenerateWadlFromJavaAction.$$$reportNull$$$0(0);
        }
        final GenerateWadlFromJavaDialog mainPanel = new GenerateWadlFromJavaDialog();
        RSProjectComponent.Settings settings = RSProjectComponent.getInstance(module.getProject()).getState();
        mainPanel.setBaseURI(settings.getLastRestClientHost());
        VirtualFile file = FileUtils.findWebInf((Module)module);
        if (file == null) {
            file = module.getModuleFile();
            VirtualFile virtualFile = file = file == null ? null : file.getParent();
        }
        if (file != null) {
            mainPanel.setWadlFilePath(file.getPath() + File.separator + module.getName() + WADL_EXT);
        }
        final Project project = module.getProject();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        CompileScope compileScope = compilerManager.createModuleCompileScope(module, false);
        compilerManager.make(compileScope, new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (!aborted && errors == 0) {
                    DialogBuilder builder = new DialogBuilder(project);
                    builder.setTitle(RSBundle.message("generate.wadl.from.java.dialog.title", new Object[0]));
                    builder.setCenterPanel((JComponent)mainPanel.getCentralPanel());
                    if (builder.show() == 0) {
                        GenerateWadlFromJavaAction.generateWadl(module, mainPanel);
                    }
                }
            }
        });
    }

    private static void generateWadl(Module module, GenerateWadlFromJavaDialog dialog) {
        String path = ((CompilerModuleExtension)ModuleRootManager.getInstance((Module)module).getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputUrl();
        if (path == null) {
            return;
        }
        path = StringUtil.trimStart((String)path, (String)"file://");
        VirtualFile[] roots = LibraryUtil.getLibraryRoots((Module[])new Module[]{module}, (boolean)false, (boolean)false);
        ArrayList<String> paths = new ArrayList<String>(roots.length + 1);
        paths.add(GenerateWadlFromJavaAction.getWadlGenPath());
        for (VirtualFile root : roots) {
            paths.add(root.getPresentableUrl());
        }
        String[] libs = ArrayUtil.toStringArray(paths);
        InvokeExternalCodeUtil.JavaExternalProcessHandler handler = new InvokeExternalCodeUtil.JavaExternalProcessHandler(RSBundle.message("generate.wadl.from.java.dialog.title", new Object[0]), GEN_WADL_FQN, libs, new String[]{path, dialog.getBaseURI(), dialog.getWadlFilePath()}, module, false);
        Runnable run = () -> {
            VirtualFile wadl = VirtualFileManager.getInstance().refreshAndFindFileByUrl("file://" + dialog.getWadlFilePath());
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)module.getProject());
            if (wadl != null) {
                PsiFile file = PsiManager.getInstance((Project)module.getProject()).findFile(wadl);
                boolean opened = editorManager.isFileOpen(wadl);
                if (file != null && file.getChildren().length > 0) {
                    if (opened) {
                        wadl.refresh(false, false);
                    }
                    editorManager.openFile(wadl, true);
                    CommandProcessor.getInstance().executeCommand(module.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
                        try {
                            CodeStyleManager.getInstance((Project)module.getProject()).reformat(file.getChildren()[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }), RSBundle.message("generate.wadl.from.java.reformat.wadl.dialog.title", new Object[0]), null);
                }
            }
        };
        InvokeExternalCodeUtil.runViaConsole((ExternalProcessHandler)handler, (Project)module.getProject(), (Runnable)run, e -> run.run(), () -> false, () -> GenerateWadlFromJavaAction.invokeDialog(module));
    }

    @NonNls
    private static String getWadlGenPath() {
        return PathManager.getPreInstalledPluginsPath() + "/WebServices/lib/wadlgen/wadlgen.jar".replace('/', File.separatorChar);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/actions/GenerateWadlFromJavaAction", "invokeDialog"));
    }
}

