/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRestJavaInspection
extends AbstractBaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Module module;
        if (file == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(1);
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)file) && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) != null && RSUtils.isRestLibAttached(module)) {
            ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
            this.checkJavaFile((PsiJavaFile)file, holder, isOnTheFly, module);
            List problemDescriptors = holder.getResults();
            return problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]);
        }
        return null;
    }

    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull Module module) {
        if (javaFile == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(3);
        }
        if (module == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(4);
        }
        for (PsiClass psiClass : javaFile.getClasses()) {
            this.checkClassInternal(psiClass, holder, module);
        }
    }

    private void checkClassInternal(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(5);
        }
        this.checkClass(aClass, holder, module);
        for (PsiClass psiClass : aClass.getInnerClasses()) {
            this.checkClass(psiClass, holder, module);
        }
    }

    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(6);
        }
        if (psiClass instanceof PsiAnonymousClass || psiClass instanceof PsiTypeParameter) {
            return;
        }
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            if (psiMethod.isConstructor()) continue;
            this.checkMethod(psiMethod, holder, module);
        }
        for (PsiMethod psiMethod : psiClass.getFields()) {
            this.checkFields((PsiField)psiMethod, holder, module);
        }
    }

    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiMethod == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(8);
        }
        if (module == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(9);
        }
    }

    protected void checkFields(@NotNull PsiField field, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (field == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(11);
        }
        if (module == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(12);
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = RSBundle.message("webservices.inspections.group.name", new Object[0]);
        if (string == null) {
            AbstractRestJavaInspection.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFile";
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/AbstractRestJavaInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/AbstractRestJavaInspection";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkJavaFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkClassInternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkFields";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

