/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.references;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.ws.references.WSReference;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.model.jam.RSJamModel;
import com.intellij.ws.rest.model.jam.RSJamPsiMethodPath;
import com.intellij.ws.rest.references.PathParamPsiElement;
import com.intellij.ws.rest.references.RestPathReference;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathParamReference
extends WSReference<PsiLiteralExpression> {
    private PsiLiteralExpression myParam;
    private final String myStringValue;
    private final Pattern GOOD_PATH_NAME = Pattern.compile("[a-zA-Z0-9_-]*");

    public PathParamReference(PsiLiteralExpression pathParamLiteral) {
        super((PsiElement)pathParamLiteral, true);
        this.myParam = pathParamLiteral;
        Object value = this.myParam.getValue();
        this.myStringValue = value instanceof String ? (String)value : null;
    }

    public PsiElement resolve() {
        if (this.myStringValue == null) {
            return null;
        }
        PsiLiteralExpression member = this.myParam;
        while ((member = PsiTreeUtil.getParentOfType((PsiElement)member, PsiMember.class)) != null) {
            RestPathReference pathReference;
            PsiMember psiMember = (PsiMember)member;
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMember, (String[])new String[]{"javax.ws.rs.Path"});
            if (annotation != null && (pathReference = this.getPathReference(annotation)) != null) {
                return pathReference.resolve();
            }
            if (!(member instanceof PsiClass)) continue;
            Project project = member.getProject();
            for (RSJamPsiMethodPath path : RSJamModel.getModel(project).getPsiMethodPaths(GlobalSearchScope.allScope((Project)project))) {
                RestPathReference reference;
                PsiAnnotation pathAnnotation;
                if (!PathParamReference.isSubResourcePath((PsiClass)member, path) || (pathAnnotation = path.getAnnotation()) == null || (reference = this.getPathReference(pathAnnotation)) == null) continue;
                return reference.resolve();
            }
        }
        return null;
    }

    private static boolean isSubResourcePath(@NotNull PsiClass psiClass, @NotNull RSJamPsiMethodPath path) {
        PsiMethod psiMethod;
        PsiType returnType;
        if (psiClass == null) {
            PathParamReference.$$$reportNull$$$0(0);
        }
        if (path == null) {
            PathParamReference.$$$reportNull$$$0(1);
        }
        if ((returnType = (psiMethod = path.getPsiElement()).getReturnType()) instanceof PsiClassType && psiClass.equals(((PsiClassType)returnType).resolve())) {
            return true;
        }
        for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
            PsiType psiType;
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"javax.ws.rs.BeanParam", (boolean)true) || !((psiType = parameter.getType()) instanceof PsiClassType) || !psiClass.equals(((PsiClassType)psiType).resolve())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private RestPathReference getPathReference(@NotNull PsiAnnotation annotation) {
        PsiElement element;
        PsiAnnotationMemberValue attributeValue;
        if (annotation == null) {
            PathParamReference.$$$reportNull$$$0(2);
        }
        if ((attributeValue = annotation.findAttributeValue("value")) != null && (element = attributeValue.getOriginalElement()) instanceof PsiLiteralExpression) {
            for (PsiReference reference : element.getReferences()) {
                RestPathReference pathReference;
                if (!(reference instanceof RestPathReference) || !this.myStringValue.equals((pathReference = (RestPathReference)reference).getName())) continue;
                return pathReference;
            }
        }
        return null;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.GOOD_PATH_NAME.matcher(newElementName).matches()) {
            PsiExpression newLiteral = JavaPsiFacade.getElementFactory((Project)((PsiLiteralExpression)this.getElement()).getProject()).createExpressionFromText("\"" + newElementName + "\"", this.myParam.getContext());
            this.myParam = (PsiLiteralExpression)this.myParam.replace((PsiElement)newLiteral);
        }
        return this.myParam;
    }

    @NotNull
    public String getValue() {
        String string = this.myStringValue == null ? "" : this.myStringValue;
        if (string == null) {
            PathParamReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PathParamPsiElement)) {
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myStringValue) || !this.myStringValue.equals(((PathParamPsiElement)element).getName())) {
            return false;
        }
        return this.isMyParent((PathParamPsiElement)element);
    }

    private boolean isMyParent(@NotNull PathParamPsiElement element) {
        PsiClass resourceClass;
        PsiMember myPathParent;
        PsiMember pathParent;
        if (element == null) {
            PathParamReference.$$$reportNull$$$0(4);
        }
        if ((pathParent = PathParamReference.findParent(this.myStringValue, (PsiElement)element)) == (myPathParent = PathParamReference.findParent(this.myStringValue, (PsiElement)this.myParam))) {
            return true;
        }
        if (myPathParent == null && (resourceClass = PathParamReference.getMemberClass(pathParent)) != null) {
            return resourceClass.equals(PsiTreeUtil.getParentOfType((PsiElement)this.myParam, PsiClass.class));
        }
        return false;
    }

    @Nullable
    private static PsiClass getMemberClass(@NotNull PsiMember pathParent) {
        if (pathParent == null) {
            PathParamReference.$$$reportNull$$$0(5);
        }
        PsiType type = null;
        if (pathParent instanceof PsiMethod) {
            type = ((PsiMethod)pathParent).getReturnType();
        }
        if (pathParent instanceof PsiField) {
            type = ((PsiField)pathParent).getType();
        }
        return type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
    }

    @Nullable
    private static PsiMember findParent(String param, @NotNull PsiElement member) {
        if (member == null) {
            PathParamReference.$$$reportNull$$$0(6);
        }
        PsiMember parent = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)member, PsiMember.class);
        while (parent != null) {
            PsiAnnotation path = AnnotationUtil.findAnnotation((PsiModifierListOwner)parent, (String[])new String[]{"javax.ws.rs.Path"});
            if (path != null && RSUtils.findPathParamNames(path).contains(param)) {
                return parent;
            }
            parent = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMember.class);
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            PathParamReference.$$$reportNull$$$0(7);
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = RSBundle.message("cannot.resolve.param", new Object[0]);
        if (string == null) {
            PathParamReference.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/references/PathParamReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathParent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/references/PathParamReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSubResourcePath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPathReference";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMyParent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMemberClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

