/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.presentation.valueresolvers.property;

import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.java.IJavaMethod;
import com.intellij.tapestry.core.model.presentation.valueresolvers.AbstractValueResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ValueResolverContext;
import com.intellij.tapestry.core.util.ClassUtils;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.chain.Context;

public class SinglePropertyResolver
extends AbstractValueResolver {
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z$_][a-zA-Z0-9$_.]*");

    public boolean execute(Context context) throws Exception {
        String cleanValue = SinglePropertyResolver.getCleanValue(((ValueResolverContext)context).getValue());
        if (cleanValue != null && PATTERN.matcher(cleanValue).matches()) {
            Map<String, Object> properties = ClassUtils.getClassProperties(((ValueResolverContext)context).getContextClass());
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                if (!property.getKey().toLowerCase().equals(cleanValue.toLowerCase())) continue;
                if (property.getValue() instanceof IJavaMethod) {
                    ((ValueResolverContext)context).setResultType(((IJavaMethod)property.getValue()).getReturnType());
                } else {
                    if (!(property.getValue() instanceof IJavaField)) continue;
                    ((ValueResolverContext)context).setResultType(((IJavaField)property.getValue()).getType());
                }
                ((ValueResolverContext)context).setResultCodeBind(property.getValue());
                return true;
            }
            return true;
        }
        return false;
    }
}

