/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.toolwindow;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.java.IJavaField;
import com.intellij.tapestry.core.model.presentation.InjectedElement;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.core.java.IntellijJavaField;
import com.intellij.tapestry.intellij.core.resource.IntellijResource;
import com.intellij.tapestry.intellij.toolwindow.DependenciesTreeCellRenderer;
import com.intellij.tapestry.intellij.toolwindow.nodes.DependenciesRootNode;
import com.intellij.tapestry.intellij.toolwindow.nodes.EmbeddedComponentNode;
import com.intellij.tapestry.intellij.toolwindow.nodes.EmbeddedComponentsNode;
import com.intellij.tapestry.intellij.toolwindow.nodes.EmbeddedTemplateNode;
import com.intellij.tapestry.intellij.toolwindow.nodes.InjectedPageNode;
import com.intellij.tapestry.intellij.toolwindow.nodes.InjectedPagesNode;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DependenciesTab {
    private JPanel _mainPanel;
    private JTree _dependenciesTree;
    private JSplitPane _splitPane;
    private JTextPane _documentationPane;
    private JToolBar _toolbar;
    private NavigateToElementAction _navigateToElementAction;
    private NavigateToUsageAction _navigateToUsageAction;

    public DependenciesTab() {
        this.$$$setupUI$$$();
        this._splitPane.setDividerLocation(0.5);
        UIUtil.setLineStyleAngled((JTree)this._dependenciesTree);
        this._dependenciesTree.setCellRenderer(new DependenciesTreeCellRenderer());
        this._navigateToElementAction = new NavigateToElementAction();
        this._navigateToUsageAction = new NavigateToUsageAction();
        this._dependenciesTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DefaultMutableTreeNode selectedNode;
                Object selectedObject;
                TreePath selected = DependenciesTab.this._dependenciesTree.getSelectionPath();
                if (selected != null && ((selectedObject = (selectedNode = (DefaultMutableTreeNode)DependenciesTab.this._dependenciesTree.getSelectionPath().getLastPathComponent()).getUserObject()) instanceof InjectedElement || selectedObject instanceof PresentationLibraryElement || selectedObject instanceof IResource)) {
                    DefaultActionGroup actions = new DefaultActionGroup("NavigateToGroup", true);
                    actions.add((AnAction)DependenciesTab.this._navigateToElementAction);
                    actions.add((AnAction)DependenciesTab.this._navigateToUsageAction);
                    actions.addSeparator();
                    actions.add((AnAction)new CollapseAllAction(DependenciesTab.this._dependenciesTree));
                    actions.add((AnAction)new ExpandAllAction(DependenciesTab.this._dependenciesTree));
                    ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ElementUsagesTree", (ActionGroup)actions);
                    popupMenu.getComponent().show(comp, x, y);
                }
                if (selected == null) {
                    DefaultActionGroup actions = new DefaultActionGroup("NavigateToGroup", true);
                    actions.add((AnAction)new CollapseAllAction(DependenciesTab.this._dependenciesTree));
                    actions.add((AnAction)new ExpandAllAction(DependenciesTab.this._dependenciesTree));
                    ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ElementUsagesTree", (ActionGroup)actions);
                    popupMenu.getComponent().show(comp, x, y);
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                TreePath selected = DependenciesTab.this._dependenciesTree.getSelectionPath();
                if (selected != null) {
                    DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)DependenciesTab.this._dependenciesTree.getSelectionPath().getLastPathComponent();
                    Object selectedObject = selectedNode.getUserObject();
                    if ((selectedNode.getParent() instanceof InjectedPagesNode || selectedNode.getParent() instanceof EmbeddedComponentsNode) && selectedObject instanceof InjectedElement) {
                        ((IntellijJavaField)((InjectedElement)selectedObject).getField()).getPsiField().navigate(true);
                    }
                    return true;
                }
                return false;
            }
        }.installOn((Component)this._dependenciesTree);
        this._dependenciesTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                if (event.getNewLeadSelectionPath() != null) {
                    DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)event.getNewLeadSelectionPath().getLastPathComponent();
                    Object selectedObject = selectedNode.getUserObject();
                    Object selectedClass = ((DefaultMutableTreeNode)event.getNewLeadSelectionPath().getPath()[0]).getUserObject();
                    IJavaClassType elementClass = ((PresentationLibraryElement)selectedClass).getElementClass();
                    String text = null;
                    if (DependenciesTab.this._dependenciesTree.getSelectionCount() == 1 && text != null && !(selectedNode instanceof EmbeddedComponentsNode) && !(selectedNode instanceof InjectedPagesNode)) {
                        DependenciesTab.this._documentationPane.setText(text);
                        DependenciesTab.this._documentationPane.setSelectionStart(0);
                        DependenciesTab.this._documentationPane.setSelectionEnd(0);
                        DependenciesTab.this._navigateToElementAction.getTemplatePresentation().setEnabled(true);
                        if (selectedNode instanceof EmbeddedTemplateNode || selectedNode.isRoot()) {
                            DependenciesTab.this._navigateToUsageAction.getTemplatePresentation().setEnabled(false);
                        } else {
                            DependenciesTab.this._navigateToUsageAction.getTemplatePresentation().setEnabled(true);
                        }
                    } else {
                        DependenciesTab.this._documentationPane.setText(text);
                        DependenciesTab.this._navigateToElementAction.getTemplatePresentation().setEnabled(false);
                        DependenciesTab.this._navigateToUsageAction.getTemplatePresentation().setEnabled(false);
                    }
                }
            }
        });
        this._dependenciesTree.setVisible(false);
        this._navigateToElementAction.getTemplatePresentation().setEnabled(false);
        this._navigateToUsageAction.getTemplatePresentation().setEnabled(false);
        CollapseAllAction collapseAllAction = new CollapseAllAction(this._dependenciesTree);
        ExpandAllAction expandAllAction = new ExpandAllAction(this._dependenciesTree);
        ActionButton navigateToElement = new ActionButton((AnAction)this._navigateToElementAction, this._navigateToElementAction.getTemplatePresentation(), "Navigate to Element", new Dimension(24, 24));
        navigateToElement.setToolTipText("Navigate to Element");
        this._toolbar.add((Component)navigateToElement);
        ActionButton navigateToUsage = new ActionButton((AnAction)this._navigateToUsageAction, this._navigateToUsageAction.getTemplatePresentation(), "Navigate to Usage", new Dimension(24, 24));
        navigateToUsage.setToolTipText("Navigate to Usage");
        this._toolbar.add((Component)navigateToUsage);
        this._toolbar.addSeparator();
        ActionButton expandAll = new ActionButton((AnAction)expandAllAction, expandAllAction.getTemplatePresentation(), expandAllAction.getTemplatePresentation().getText(), new Dimension(24, 24));
        expandAll.setToolTipText("Expand All");
        this._toolbar.add((Component)expandAll);
        ActionButton collapseAll = new ActionButton((AnAction)collapseAllAction, collapseAllAction.getTemplatePresentation(), collapseAllAction.getTemplatePresentation().getText(), new Dimension(24, 24));
        collapseAll.setToolTipText("Collapse All");
        this._toolbar.add((Component)collapseAll);
    }

    public JPanel getMainPanel() {
        return this._mainPanel;
    }

    public void showDependencies(Module module, Object element) {
        String text = null;
        if (this.shouldShowDependencies(element)) {
            this._dependenciesTree.setVisible(true);
            this._dependenciesTree.setModel(null);
            this._dependenciesTree.setModel(new DefaultTreeModel(new DependenciesRootNode(element)));
            this._documentationPane.setText(text);
            this._navigateToElementAction.getTemplatePresentation().setEnabled(false);
            this._navigateToUsageAction.getTemplatePresentation().setEnabled(false);
        } else {
            this.clear();
        }
    }

    public void clear() {
        this._dependenciesTree.setVisible(false);
        this._documentationPane.setText("<html><head></head><body></body></html>");
    }

    private boolean shouldShowDependencies(Object element) {
        return element instanceof PresentationLibraryElement;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JToolBar jToolBar;
        JTextPane jTextPane;
        JSplitPane jSplitPane;
        JPanel jPanel;
        this._mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this._splitPane = jSplitPane = new JSplitPane();
        jPanel.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jSplitPane.setRightComponent((Component)jBScrollPane);
        this._documentationPane = jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setEditable(false);
        jBScrollPane.setViewportView(jTextPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jSplitPane.setLeftComponent(jPanel2);
        this._toolbar = jToolBar = new JToolBar();
        jToolBar.setBorderPainted(false);
        jToolBar.setFloatable(false);
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.FALSE);
        jPanel2.add((Component)jToolBar, new GridConstraints(0, 0, 1, 1, 8, 0, 6, 0, null, new Dimension(-1, 20), null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        Tree tree = new Tree();
        this._dependenciesTree = tree;
        tree.setShowsRootHandles(true);
        jBScrollPane2.setViewportView((Component)tree);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this._mainPanel;
    }

    private class NavigateToUsageAction
    extends AnAction {
        public NavigateToUsageAction() {
            super("Navigate to Usage", "Navigate to part of code where the selected element is used", AllIcons.Nodes.EjbReference);
        }

        public void actionPerformed(AnActionEvent event) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)DependenciesTab.this._dependenciesTree.getSelectionPath().getLastPathComponent();
            Object selectedObject = selectedNode.getUserObject();
            if (selectedObject instanceof PresentationLibraryElement || selectedObject instanceof InjectedElement) {
                IJavaField elementField;
                PsiField field = null;
                PsiFile file = null;
                if (selectedNode instanceof EmbeddedComponentNode) {
                    elementField = ((EmbeddedComponentNode)selectedNode).getInjectedComponent().getField();
                    if (elementField != null) {
                        field = ((IntellijJavaField)elementField).getPsiField();
                    } else {
                        file = ((IntellijResource)((EmbeddedTemplateNode)selectedNode.getParent()).getUserObject()).getPsiFile();
                    }
                }
                if (selectedNode instanceof InjectedPageNode) {
                    elementField = ((InjectedPageNode)selectedNode).getInjectedPage().getField();
                    if (elementField != null) {
                        field = ((IntellijJavaField)elementField).getPsiField();
                    } else {
                        file = ((IntellijResource)((EmbeddedTemplateNode)selectedNode.getParent()).getUserObject()).getPsiFile();
                    }
                }
                if (field != null) {
                    field.navigate(true);
                }
                if (file != null) {
                    file.navigate(true);
                }
            }
        }
    }

    public class NavigateToElementAction
    extends AnAction {
        public NavigateToElementAction() {
            super("Navigate to Element", "Navigate to the selected element class", AllIcons.Actions.Browser_externalJavaDoc);
        }

        public void actionPerformed(AnActionEvent event) {
            PsiFile file;
            PsiClass psiClass;
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)DependenciesTab.this._dependenciesTree.getSelectionPath().getLastPathComponent();
            Object selectedObject = selectedNode.getUserObject();
            if (selectedObject instanceof PresentationLibraryElement && (psiClass = ((IntellijJavaClassType)((PresentationLibraryElement)selectedObject).getElementClass()).getPsiClass()) != null) {
                psiClass.navigate(true);
            }
            if (selectedObject instanceof InjectedElement && (psiClass = ((IntellijJavaClassType)((InjectedElement)selectedObject).getElement().getElementClass()).getPsiClass()) != null) {
                psiClass.navigate(true);
            }
            if (selectedObject instanceof IntellijResource && (file = ((IntellijResource)selectedObject).getPsiFile()) != null) {
                file.navigate(true);
            }
        }
    }
}

