/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.tapestry.lang.TelFileType;
import com.intellij.tapestry.psi.TelCompositeElementType;
import com.intellij.tapestry.psi.TelLexer;
import com.intellij.tapestry.psi.TelParser;
import com.intellij.tapestry.psi.TelTokenTypes;
import com.intellij.tapestry.psi.impl.TelExpressionHolder;
import org.jetbrains.annotations.NotNull;

public class TelParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        TelLexer telLexer = new TelLexer();
        if (telLexer == null) {
            TelParserDefinition.$$$reportNull$$$0(0);
        }
        return telLexer;
    }

    public IFileElementType getFileNodeType() {
        return TelTokenTypes.TEL_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TelTokenTypes.WHITESPACES;
        if (tokenSet == null) {
            TelParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            TelParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TelTokenTypes.STRING_LITERALS;
        if (tokenSet == null) {
            TelParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        TelParser telParser = new TelParser();
        if (telParser == null) {
            TelParserDefinition.$$$reportNull$$$0(4);
        }
        return telParser;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PsiFileBase(viewProvider, TelFileType.INSTANCE.getLanguage()){
            {
                this.init((IElementType)TelTokenTypes.TEL_FILE, (IElementType)TelTokenTypes.TAP5_EL_HOLDER);
            }

            @NotNull
            public FileType getFileType() {
                TelFileType telFileType = TelFileType.INSTANCE;
                if (telFileType == null) {
                    1.$$$reportNull$$$0(0);
                }
                return telFileType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/psi/TelParserDefinition$1", "getFileType"));
            }
        };
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        Lexer lexer = this.createLexer(left.getPsi().getProject());
        return LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)lexer);
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType elementType = node.getElementType();
        if (elementType instanceof TelCompositeElementType) {
            PsiElement psiElement = ((TelCompositeElementType)elementType).createPsiElement(node);
            if (psiElement == null) {
                TelParserDefinition.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        if (elementType == TelTokenTypes.TAP5_EL_HOLDER) {
            TelExpressionHolder telExpressionHolder = new TelExpressionHolder(node);
            if (telExpressionHolder == null) {
                TelParserDefinition.$$$reportNull$$$0(6);
            }
            return telExpressionHolder;
        }
        throw new AssertionError((Object)("Unknown type: " + elementType));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/tapestry/psi/TelParserDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createParser";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

