/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.osgi.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.osgi.SpringOsgiBundle;
import com.intellij.spring.osgi.inspections.SpringOsgiBaseInspection;
import com.intellij.spring.osgi.model.xml.BaseOsgiReference;
import com.intellij.spring.osgi.model.xml.BaseReferenceCollection;
import com.intellij.spring.osgi.model.xml.Service;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringOsgiElementsInconsistencyInspection
extends SpringOsgiBaseInspection {
    @Override
    protected void checkOsgiService(Service service, Beans beans, DomElementAnnotationHolder holder, CommonSpringModel springModel) {
        super.checkOsgiService(service, beans, holder, springModel);
        if (service.getInterface().getXmlAttribute() != null && DomUtil.hasXml((DomElement)service.getInterfaces())) {
            holder.createProblem((DomElement)service, SpringOsgiBundle.message("service.inconsistency.illegal.use.of.interfaces", new Object[0]), new LocalQuickFix[0]);
        }
        if (service.getRef().getXmlAttribute() != null && DomUtil.hasXml((DomElement)service.getBean())) {
            holder.createProblem((DomElement)service, SpringOsgiBundle.message("service.inconsistency.illegal.use.of.ref.and.bean", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Override
    protected void checkOsgiReferenceCollection(BaseReferenceCollection referenceCollection, Beans beans, DomElementAnnotationHolder holder, CommonSpringModel model) {
        if (referenceCollection.getComparatorRef().getXmlAttribute() != null && DomUtil.hasXml((DomElement)referenceCollection.getComparator())) {
            holder.createProblem((DomElement)referenceCollection, SpringOsgiBundle.message("collections.inconsistency.illegal.use.of.comparator", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Override
    protected void checkOsgiReference(BaseOsgiReference reference, Beans beans, DomElementAnnotationHolder holder, CommonSpringModel springModel) {
        super.checkOsgiReference(reference, beans, holder, springModel);
        if (reference.getInterface().getXmlAttribute() != null && DomUtil.hasXml((DomElement)reference.getInterfaces())) {
            holder.createProblem((DomElement)reference, SpringOsgiBundle.message("service.inconsistency.illegal.use.of.interfaces", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringOsgiElementsInconsistencyInspection" == null) {
            SpringOsgiElementsInconsistencyInspection.$$$reportNull$$$0(0);
        }
        return "SpringOsgiElementsInconsistencyInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/osgi/inspections/SpringOsgiElementsInconsistencyInspection", "getShortName"));
    }
}

