/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.IdeBundle;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.ProcessOutputCatcher;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class NodeCommandLineUtil {
    public static final String INSPECT = "--inspect";
    public static final String INSPECT_BRK = "--inspect-brk";
    public static final String INSPECT_EQ = "--inspect=";
    public static final String INSPECT_BRK_EQ = "--inspect-brk=";
    public static final String DEBUG = "--debug";
    public static final String DEBUG_BRK = "--debug-brk";
    public static final String DEBUG_EQ = "--debug=";
    public static final String DEBUG_BRK_EQ = "--debug-brk=";
    public static final String EXPOSE_DEBUG_AS_V8DEBUG = "--expose_debug_as=v8debug";
    private static final Key<Boolean> USE_WIP_CONNECTION = Key.create((String)"USE_WIP_CONNECTION");

    private NodeCommandLineUtil() {
    }

    @NotNull
    public static ProcessOutput execute(@NotNull GeneralCommandLine commandLine, long timeoutMillis) throws ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(0);
        }
        ProcessOutput processOutput = NodeCommandLineUtil.execute(commandLine, null, timeoutMillis);
        if (processOutput == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(1);
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput execute(@NotNull GeneralCommandLine commandLine, @Nullable ProgressIndicator indicator, long timeoutMillis) throws ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(2);
        }
        commandLine.setCharset(StandardCharsets.UTF_8);
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine, false);
        processHandler.setShouldDestroyProcessRecursively(true);
        processHandler.setShouldKillProcessSoftly(true);
        ProcessOutputCatcher outputCatcher = new ProcessOutputCatcher((BaseOSProcessHandler)processHandler);
        ProcessOutput processOutput = outputCatcher.run(indicator, timeoutMillis);
        if (processOutput == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(3);
        }
        return processOutput;
    }

    @NotNull
    public static GeneralCommandLine createNpmCommandLine(@Nullable File workingDir, @NotNull NodeJsLocalInterpreter interpreter, @NotNull List<String> arguments) throws ExecutionException {
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(4);
        }
        if (arguments == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(5);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withCharset(StandardCharsets.UTF_8);
        if (workingDir != null) {
            commandLine.withWorkDirectory(workingDir);
        }
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        commandLine.addParameter(interpreter.getValidNpmCliJsFilePath());
        commandLine.addParameters(arguments);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(6);
        }
        return generalCommandLine;
    }

    public static void configureUsefulEnvironment(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(7);
        }
        Map env = commandLine.getEnvironment();
        env.putIfAbsent("DEBUG_COLORS", "true");
        env.putIfAbsent("FORCE_COLOR", "true");
        env.putIfAbsent("npm_config_color", "always");
        env.putIfAbsent("MOCHA_COLORS", "1");
        env.putIfAbsent("ELECTRON_NO_ATTACH_CONSOLE", "true");
    }

    public static void addDebugParameters(@NotNull GeneralCommandLine commandLine, int debugPort) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(8);
        }
        if (debugPort > 0) {
            commandLine.addParameter(DEBUG_BRK_EQ + debugPort);
            commandLine.addParameter(EXPOSE_DEBUG_AS_V8DEBUG);
        }
    }

    public static void addNodeOptions(@NotNull GeneralCommandLine commandLine, @NotNull List<String> nodeOptions, int debugPort, @NotNull NodeJsInterpreter interpreter, boolean preferWipProtocol) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(9);
        }
        if (nodeOptions == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(10);
        }
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(11);
        }
        NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, nodeOptions, debugPort, true, interpreter, preferWipProtocol);
    }

    public static void addNodeOptionsForDebugging(@NotNull GeneralCommandLine commandLine, @NotNull List<String> nodeOptions, int debugPort, boolean breakAtStartOfUserScript, @NotNull NodeJsInterpreter interpreter, boolean preferWipProtocol) {
        List<String> transformedOptions;
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(12);
        }
        if (nodeOptions == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(13);
        }
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(14);
        }
        if ((transformedOptions = NodeCommandLineUtil.transformNodeOptionsForDebugging(nodeOptions, debugPort, breakAtStartOfUserScript, interpreter, preferWipProtocol)).stream().anyMatch(NodeCommandLineUtil::isInspectOption)) {
            commandLine.putUserData(USE_WIP_CONNECTION, (Object)true);
        }
        commandLine.addParameters(transformedOptions);
    }

    public static boolean shouldUseInspectorProtocol(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(15);
        }
        return Boolean.TRUE.equals(commandLine.getUserData(USE_WIP_CONNECTION));
    }

    @NotNull
    private static List<String> transformNodeOptionsForDebugging(@NotNull List<String> nodeOptions, int debugPort, boolean breakAtStartOfUserScript, @NotNull NodeJsInterpreter interpreter, boolean preferInspectorProtocol) {
        boolean useInspectorProtocol;
        if (nodeOptions == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(16);
        }
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(17);
        }
        if (debugPort == -1) {
            List<String> list = nodeOptions;
            if (list == null) {
                NodeCommandLineUtil.$$$reportNull$$$0(18);
            }
            return list;
        }
        boolean hasInspectOption = false;
        boolean hasV8DebugOption = false;
        ArrayList<String> resultOptions = new ArrayList<String>();
        for (String option : nodeOptions) {
            boolean isInspectOption = NodeCommandLineUtil.isInspectOption(option);
            hasInspectOption |= isInspectOption;
            boolean isV8DebugOption = NodeCommandLineUtil.isV8DebugOption(option);
            hasV8DebugOption |= isV8DebugOption;
            if (option == null || isInspectOption || isV8DebugOption) continue;
            resultOptions.add(option);
        }
        SemVer version = null;
        if (hasInspectOption) {
            useInspectorProtocol = true;
        } else if (hasV8DebugOption) {
            useInspectorProtocol = false;
        } else {
            if (NodeCommandLineUtil.shouldUseInspectorProtocolRegardlessOfVersion(interpreter)) {
                version = new SemVer("8.0.0", 8, 0, 0);
            } else {
                Promise<SemVer> versionPromise = interpreter.provideCachedVersionOrFetch();
                version = (SemVer)versionPromise.blockingGet(1500, TimeUnit.MILLISECONDS);
            }
            boolean bl = version == null ? preferInspectorProtocol : (useInspectorProtocol = version.getMajor() >= 8 || version.getMajor() >= 7 && preferInspectorProtocol);
        }
        if (useInspectorProtocol) {
            if (breakAtStartOfUserScript) {
                if (version == null || version.isGreaterOrEqualThan(7, 6, 0)) {
                    resultOptions.add(INSPECT_BRK_EQ + debugPort);
                } else {
                    resultOptions.add(INSPECT_EQ + debugPort);
                    resultOptions.add(DEBUG_BRK);
                }
            } else {
                resultOptions.add(INSPECT_EQ + debugPort);
            }
        } else {
            resultOptions.add((breakAtStartOfUserScript ? DEBUG_BRK_EQ : DEBUG_EQ) + debugPort);
            resultOptions.add(EXPOSE_DEBUG_AS_V8DEBUG);
        }
        ArrayList<String> arrayList = resultOptions;
        if (arrayList == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static boolean shouldUseInspectorProtocolRegardlessOfVersion(@NotNull NodeJsInterpreter interpreter) {
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(20);
        }
        return interpreter instanceof NodeJsRemoteInterpreter || interpreter instanceof NodeJsLocalInterpreter && ((NodeJsLocalInterpreter)interpreter).isElectron();
    }

    private static boolean isInspectOption(@Nullable String option) {
        if (option == null) {
            return false;
        }
        return option.equals(INSPECT) || option.equals(INSPECT_BRK) || option.startsWith(INSPECT_EQ) || option.startsWith(INSPECT_BRK_EQ);
    }

    private static boolean isV8DebugOption(@Nullable String option) {
        if (option == null) {
            return false;
        }
        return option.equals(DEBUG) || option.equals(DEBUG_BRK) || option.startsWith(DEBUG_EQ) || option.startsWith(DEBUG_BRK_EQ);
    }

    @NotNull
    public static OSProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(21);
        }
        if (NodeCommandLineUtil.shouldUseInspectorProtocol(commandLine)) {
            SkippingProcessHandler skippingProcessHandler = new SkippingProcessHandler(commandLine, withMediator);
            if (skippingProcessHandler == null) {
                NodeCommandLineUtil.$$$reportNull$$$0(22);
            }
            return skippingProcessHandler;
        }
        KillableColoredProcessHandler killableColoredProcessHandler = new KillableColoredProcessHandler(commandLine, withMediator);
        if (killableColoredProcessHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(23);
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    public static ProcessHandler createSkippingProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(24);
        }
        SkippingProcessHandler skippingProcessHandler = new SkippingProcessHandler(commandLine, false);
        if (skippingProcessHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(25);
        }
        return skippingProcessHandler;
    }

    public static boolean shouldUseWipConnection(@Nullable ProcessHandler processHandler) {
        return processHandler instanceof SkippingProcessHandler || processHandler instanceof BaseOSProcessHandler && ((BaseOSProcessHandler)processHandler).getCommandLine().contains(" --inspect");
    }

    public static String formatErrorMessage(@NotNull GeneralCommandLine commandLine, @NotNull ProcessOutput output) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(26);
        }
        if (output == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(27);
        }
        StringBuilder buf = new StringBuilder(commandLine.getCommandLineString());
        if (output.getStderr().length() > 0) {
            buf.append("\n\n");
            buf.append("Standard error:\n").append(output.getStderr());
        }
        if (output.getStdout().length() > 0) {
            buf.append("\n\n");
            buf.append("Standard output:\n").append(output.getStdout());
        }
        buf.append("\n\n");
        buf.append(IdeBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{output.getExitCode()}));
        return buf.toString();
    }

    @NotNull
    public static String getInstallPackageCommand(@NotNull NodeJsLocalInterpreter interpreter) {
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(28);
        }
        String string = interpreter.isYarnAlikePackage() ? "add" : "install";
        if (string == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeCommandLineUtil";
                break;
            }
            case 4: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeOptions";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeCommandLineUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNpmCommandLine";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "transformNodeOptionsForDebugging";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createSkippingProcessHandler";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallPackageCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 29: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNpmCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureUsefulEnvironment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDebugParameters";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addNodeOptions";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addNodeOptionsForDebugging";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseInspectorProtocol";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "transformNodeOptionsForDebugging";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseInspectorProtocolRegardlessOfVersion";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createSkippingProcessHandler";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getInstallPackageCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SkippingProcessHandler
    extends KillableColoredProcessHandler {
        private boolean myWarnSkipped;
        private boolean myExpectChromeTipLine1;
        private boolean myExpectChromeTipLine2;

        public SkippingProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
            if (commandLine == null) {
                SkippingProcessHandler.$$$reportNull$$$0(0);
            }
            super(commandLine, withMediator);
            this.myWarnSkipped = false;
            this.myExpectChromeTipLine1 = false;
            this.myExpectChromeTipLine2 = false;
        }

        public void coloredTextAvailable(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                SkippingProcessHandler.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                SkippingProcessHandler.$$$reportNull$$$0(2);
            }
            if (!this.myWarnSkipped && outputType == ProcessOutputTypes.STDERR && text.startsWith("Warning: This is an experimental feature")) {
                this.myWarnSkipped = true;
                this.myExpectChromeTipLine1 = true;
                return;
            }
            if (this.myExpectChromeTipLine1 && outputType == ProcessOutputTypes.STDERR && text.startsWith("To start debugging, open the following URL in Chrome:")) {
                this.myExpectChromeTipLine1 = false;
                this.myExpectChromeTipLine2 = true;
                return;
            }
            if (this.myExpectChromeTipLine2) {
                this.myExpectChromeTipLine2 = false;
                if (text.contains("chrome-devtools://")) {
                    return;
                }
            }
            super.coloredTextAvailable(text, outputType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/NodeCommandLineUtil$SkippingProcessHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coloredTextAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

