/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.gjslint;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.gjslint.GjsLintConfiguration;
import com.intellij.lang.javascript.linter.gjslint.GjsLintState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.util.text.StringTokenizer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class GjsLintConfigFileChangeTracker {
    private static final AtomicBoolean INSTALLED = new AtomicBoolean(false);
    private static final Key<Boolean> PASS_REAL_PATH_KEY = Key.create((String)"PASS_REAL_PATH");

    public static void startTracking() {
        if (INSTALLED.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new GjsLintConfigFileVfsListener());
                EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
                multicaster.addDocumentListener((DocumentListener)new GjsLintConfigFileDocumentListener());
            }));
        }
    }

    private static void onChange(@NotNull VirtualFile file) {
        Project[] projects;
        if (file == null) {
            GjsLintConfigFileChangeTracker.$$$reportNull$$$0(0);
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        for (Project project : projects = projectManager.getOpenProjects()) {
            if (project.isDisposed()) continue;
            GjsLintConfigFileChangeTracker.restartCodeAnalyzerIfNeeded(project, file);
        }
    }

    private static void restartCodeAnalyzerIfNeeded(@NotNull Project project, @NotNull VirtualFile changedFile) {
        String configFilePath;
        VirtualFile configVirtualFile;
        GjsLintConfiguration configuration;
        ExtendedLinterState extendedState;
        if (project == null) {
            GjsLintConfigFileChangeTracker.$$$reportNull$$$0(1);
        }
        if (changedFile == null) {
            GjsLintConfigFileChangeTracker.$$$reportNull$$$0(2);
        }
        if ((extendedState = (configuration = GjsLintConfiguration.getInstance(project)).getExtendedState()).isEnabled() && changedFile.equals(configVirtualFile = JSLinterConfigFileUtil.findLocalFileByPath(configFilePath = ((GjsLintState)extendedState.getState()).getConfigFilePath()))) {
            PASS_REAL_PATH_KEY.set((UserDataHolder)configVirtualFile, null);
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }
    }

    public static boolean checkPassRealPath(@NotNull VirtualFile configFile) {
        Boolean passRealPath;
        if (configFile == null) {
            GjsLintConfigFileChangeTracker.$$$reportNull$$$0(3);
        }
        if ((passRealPath = (Boolean)PASS_REAL_PATH_KEY.get((UserDataHolder)configFile)) == null) {
            passRealPath = GjsLintConfigFileChangeTracker.isPassRealPath(configFile);
            PASS_REAL_PATH_KEY.set((UserDataHolder)configFile, (Object)passRealPath);
        }
        return passRealPath;
    }

    private static boolean isPassRealPath(@NotNull VirtualFile configFile) {
        String text;
        if (configFile == null) {
            GjsLintConfigFileChangeTracker.$$$reportNull$$$0(4);
        }
        try {
            text = JSLinterConfigFileUtil.loadActualText(configFile);
        }
        catch (IOException e) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(text, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (!"--passRealFilePath".equals(line = line.trim())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/gjslint/GjsLintConfigFileChangeTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onChange";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "restartCodeAnalyzerIfNeeded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPassRealPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isPassRealPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GjsLintConfigFileDocumentListener
    implements DocumentListener {
        private GjsLintConfigFileDocumentListener() {
        }

        public void documentChanged(DocumentEvent event) {
            VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
            if (file != null) {
                GjsLintConfigFileChangeTracker.onChange(file);
            }
        }
    }

    private static class GjsLintConfigFileVfsListener
    implements VirtualFileListener {
        private GjsLintConfigFileVfsListener() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                GjsLintConfigFileVfsListener.$$$reportNull$$$0(0);
            }
            GjsLintConfigFileChangeTracker.onChange(event.getFile());
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                GjsLintConfigFileVfsListener.$$$reportNull$$$0(1);
            }
            GjsLintConfigFileChangeTracker.onChange(event.getFile());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                GjsLintConfigFileVfsListener.$$$reportNull$$$0(2);
            }
            GjsLintConfigFileChangeTracker.onChange(event.getFile());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                GjsLintConfigFileVfsListener.$$$reportNull$$$0(3);
            }
            GjsLintConfigFileChangeTracker.onChange(event.getFile());
            GjsLintConfigFileChangeTracker.onChange(event.getOriginalFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/lang/javascript/linter/gjslint/GjsLintConfigFileChangeTracker$GjsLintConfigFileVfsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

