/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypedJSAnnotatingVisitor
extends JSAnnotatingVisitor {
    public TypedJSAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            TypedJSAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            TypedJSAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        super(psiElement, holder);
    }

    protected static ASTNode findElementForAccessModifierError(@NotNull JSFunction o, JSAttributeList attributeList) {
        PsiElement accessTypeElement;
        if (o == null) {
            TypedJSAnnotatingVisitor.$$$reportNull$$$0(2);
        }
        if (attributeList != null && (accessTypeElement = attributeList.findAccessTypeElement()) != null) {
            return accessTypeElement.getNode();
        }
        return o.findNameIdentifier();
    }

    @Override
    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        JSExpression qualifier;
        if (node == null) {
            TypedJSAnnotatingVisitor.$$$reportNull$$$0(3);
        }
        if ((qualifier = node.getQualifier()) == null && node instanceof JSReferenceExpressionImpl) {
            qualifier = ((JSReferenceExpressionImpl)node).getResolveQualifier();
        }
        if (qualifier == null) {
            JSExpression expression;
            JSWithStatement withStatement = (JSWithStatement)PsiTreeUtil.getParentOfType((PsiElement)node, JSWithStatement.class);
            if (withStatement != null && (expression = withStatement.getExpression()) != null && expression != node && PsiTreeUtil.findCommonParent((PsiElement)node, (PsiElement)expression) != expression) {
                return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
            }
            return ProblemHighlightType.ERROR;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    @Nullable
    protected JSType getResolveResultType(JSExpression qualifier, PsiElement resultElement) {
        return JSResolveUtil.getExpressionJSType(qualifier);
    }

    public void visitJSReferenceList(JSReferenceList referenceList) {
        boolean isImplements;
        JSClass jsClass = (JSClass)referenceList.getParent();
        if (JSResolveUtil.isArtificialClassUsedForReferenceList(jsClass)) {
            return;
        }
        boolean isExtends = jsClass.getExtendsList() == referenceList;
        boolean bl = isImplements = jsClass.getImplementsList() == referenceList;
        if (isImplements && jsClass.isInterface()) {
            this.myProblemReporter.registerGenericError((PsiElement)referenceList, JSBundle.message((String)"javascript.validation.message.implements.for.interface.not.allowed", (Object[])new Object[0]), JSFixFactory.getInstance().replaceImplementsKeywordByExtendsFix(referenceList));
            return;
        }
        HashSet hasErrorExpressions = ContainerUtil.newHashSet();
        HashSet hasCircularErrorErrorExpressions = ContainerUtil.newHashSet();
        for (Pair pair : referenceList.getResolvedExpressions()) {
            JSExpression expr = ((JSReferenceListMember)pair.first).getExpression();
            Collection second = (Collection)pair.getSecond();
            if (second == null || second.isEmpty()) {
                this.checkNotResolvedReferenceListExpression(jsClass, expr, isExtends);
                continue;
            }
            for (JSClass clazz : second) {
                if (isImplements && !hasErrorExpressions.contains(expr)) {
                    if (!this.checkImplementsRef(clazz, expr)) {
                        hasErrorExpressions.add(expr);
                    }
                } else if (isExtends && !hasErrorExpressions.contains(expr) && !this.checkExtendsRef(jsClass, clazz, expr)) {
                    hasErrorExpressions.add(expr);
                }
                if (clazz != jsClass || hasCircularErrorErrorExpressions.contains(expr)) continue;
                this.myProblemReporter.registerGenericError((PsiElement)expr, JSBundle.message((String)"javascript.validation.message.circular.dependency", (Object[])new Object[0]), new IntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.circular.dependency", referenceList.getNode())});
                hasCircularErrorErrorExpressions.add(expr);
            }
        }
        if (isImplements || isExtends && DialectDetector.isTypeScript((PsiElement)jsClass)) {
            this.checkImplementedMethods(jsClass, new JSAnnotatingVisitor.SimpleErrorReportingClient());
        }
        if (isExtends) {
            this.checkOverriddenMethods(jsClass);
        }
    }

    @Override
    protected boolean suggestCreateVarFromUsage(JSReferenceExpression node) {
        JSClass clazz;
        JSExpression qualifier = node.getQualifier();
        JSClass targetClass = null;
        if (qualifier == null) {
            targetClass = JSResolveUtil.getClassOfContext((PsiElement)node);
        } else if (qualifier instanceof JSReferenceExpression && DialectDetector.isActionScript((PsiElement)node) && (clazz = JSResolveUtil.findClassOfQualifier(qualifier, node.getContainingFile())) != null) {
            targetClass = clazz;
        }
        if (targetClass != null) {
            return !targetClass.isInterface();
        }
        return true;
    }

    protected void checkNotResolvedReferenceListExpression(JSClass jsClass, JSExpression expression, boolean isExtends) {
    }

    protected boolean checkExtendsRef(JSClass jsClass, JSClass referencedClass, JSExpression expr) {
        if (referencedClass.isInterface() != jsClass.isInterface()) {
            this.myProblemReporter.registerGenericError((PsiElement)expr, JSBundle.message((String)(jsClass.isInterface() ? "javascript.validation.message.interface.name.expected.here" : "javascript.validation.message.class.name.expected.here"), (Object[])new Object[0]), new IntentionAction[0]);
            return false;
        }
        return true;
    }

    protected boolean checkImplementsRef(JSClass jsClass, JSExpression expr) {
        if (!jsClass.isInterface()) {
            this.myProblemReporter.registerGenericError((PsiElement)expr, JSBundle.message((String)"javascript.validation.message.interface.name.expected.here", (Object[])new Object[0]), new IntentionAction[0]);
            return false;
        }
        return true;
    }

    protected void checkImplementedMethods(@NotNull JSClass jsClass, JSAnnotatingVisitor.ErrorReportingClient reportingClient) {
        if (jsClass == null) {
            TypedJSAnnotatingVisitor.$$$reportNull$$$0(4);
        }
    }

    protected void checkOverriddenMethods(JSClass aClass) {
    }

    @Override
    protected boolean checkAssignmentToConst(@NotNull JSReferenceExpression lExpr) {
        PsiElement resolved;
        if (lExpr == null) {
            TypedJSAnnotatingVisitor.$$$reportNull$$$0(5);
        }
        if ((resolved = lExpr.resolve()) instanceof JSVariable && ((JSVariable)resolved).isConst() || resolved instanceof JSField && ((JSField)resolved).isConst() || resolved instanceof JSFunction && ((JSFunction)resolved).isGetProperty()) {
            if (this.isConstAssignable(lExpr, resolved)) {
                return false;
            }
            PsiElement place = lExpr.getReferenceNameElement();
            if (place == null) {
                place = lExpr;
            }
            this.myProblemReporter.registerGenericError(place, JSBundle.message((String)"javascript.validation.message.assignment.to.const", (Object[])new Object[0]), new IntentionAction[0]);
            return true;
        }
        return super.checkAssignmentToConst(lExpr);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lExpr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/TypedJSAnnotatingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForAccessModifierError";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnresolvedReferenceHighlightType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkImplementedMethods";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAssignmentToConst";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

