/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAllAction;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileCurrentAction;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServiceStructureBuilder;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigsChangedListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import icons.JavaScriptLanguageIcons;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeScriptLanguageServiceToolWindowManager
extends JSLanguageServiceToolWindowManager {
    private final Project myProject;
    private final TypeScriptCompilerSettings mySettings;
    private volatile ToggleAction showErrors;
    @Nullable
    private volatile TypeScriptServiceStructureBuilder.StructurePanel myStructurePanel;

    @NotNull
    private static AnAction[] convertConfigToActions(final Project project, @NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(0);
        }
        ArrayList actions = ContainerUtil.newArrayList();
        actions.add(new TypeScriptCompileCurrentAction(JSBundle.message((String)"typescript.compiler.action.compile.current", (Object[])new Object[0]), null, null){

            @Override
            protected VirtualFile[] getFiles(Project project2, DataContext dataContext) {
                return FileEditorManager.getInstance((Project)project2).getSelectedFiles();
            }

            @Override
            protected void logErrors(@NotNull JSLanguageServiceToolWindowManager manager, @NotNull Collection<JSAnnotationError> infos) {
                if (manager == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (infos == null) {
                    1.$$$reportNull$$$0(1);
                }
                manager.logCurrentErrors((List<JSAnnotationError>)ContainerUtil.immutableList((List)ContainerUtil.newArrayList(infos)), true);
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (project.isDisposed() || DumbService.isDumb((Project)project)) {
                    return;
                }
                VirtualFile[] files = this.getFiles(project, e.getDataContext());
                if (files.length == 1 && TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(files[0].getFileType())) {
                    e.getPresentation().setText(files[0].getPath());
                    e.getPresentation().setEnabledAndVisible(true);
                } else {
                    e.getPresentation().setEnabledAndVisible(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "manager";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "infos";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "logErrors";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        actions.add(new Separator());
        actions.addAll(configs.stream().map(el -> new CompileForConfigAction((TypeScriptConfig)el)).collect(Collectors.toList()));
        actions.add(new Separator());
        actions.add(new TypeScriptCompileAllAction(JSBundle.message((String)"typescript.compiler.action.compile.all", (Object[])new Object[0]), null, null));
        AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(1);
        }
        return anActionArray;
    }

    @NotNull
    private static AnAction compileActions(final @NotNull Project project) {
        TypeScriptConfigService service;
        if (project == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(2);
        }
        if ((service = TypeScriptConfigService.Provider.get(project)) == null) {
            TypeScriptCompileAllAction typeScriptCompileAllAction = new TypeScriptCompileAllAction();
            if (typeScriptCompileAllAction == null) {
                TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(3);
            }
            return typeScriptCompileAllAction;
        }
        final AtomicReference<Object> ref = new AtomicReference<Object>();
        service.addChangeListener(new TypeScriptConfigsChangedListener(){

            @Override
            public void afterUpdate(@NotNull Collection<TypeScriptConfig> configs) {
                if (configs == null) {
                    2.$$$reportNull$$$0(0);
                }
                ref.set(TypeScriptLanguageServiceToolWindowManager.convertConfigToActions(project, configs));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$2", "afterUpdate"));
            }
        });
        ref.set(ReadAction.compute(() -> {
            if (project == null) {
                TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(8);
            }
            Collection<Object> files = ContainerUtil.emptyList();
            try {
                files = service.getConfigFiles();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            return TypeScriptLanguageServiceToolWindowManager.convertConfigToActions(project, files);
        }));
        ActionGroup actionGroup = new ActionGroup(JSBundle.message((String)"typescript.compiler.action.compile.toolbar", (Object[])new Object[0]), JSBundle.message((String)"typescript.compiler.action.compile.toolbar", (Object[])new Object[0]), JavaScriptLanguageIcons.Typescript.CompileCurrentFile2){

            public boolean isDumbAware() {
                return false;
            }

            public void update(AnActionEvent e) {
                this.setPopup(true);
                super.update(e);
            }

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                VirtualFile config2;
                AnAction[] actions = (AnAction[])ref.get();
                if (e != null && (config2 = TypeScriptCompileCurrentAction.getTypeScriptConfigVirtualFile(e.getDataContext())) != null) {
                    ArrayList newActions = ContainerUtil.newArrayList();
                    ArrayList configActions = ContainerUtil.newArrayList();
                    for (AnAction action : actions) {
                        if (action instanceof CompileForConfigAction) {
                            configActions.add((CompileForConfigAction)action);
                            continue;
                        }
                        if (!configActions.isEmpty()) {
                            ContainerUtil.sort((List)configActions, Comparator.comparing(el -> !((CompileForConfigAction)el).myConfigFile.getConfigFile().equals(config2)));
                            newActions.addAll(configActions);
                            configActions.clear();
                        }
                        newActions.add(action);
                    }
                    AnAction[] anActionArray = newActions.toArray(AnAction.EMPTY_ARRAY);
                    if (anActionArray == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return anActionArray;
                }
                if (actions == null) {
                    3.$$$reportNull$$$0(1);
                }
                return actions;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$3", "getChildren"));
            }
        };
        if (actionGroup == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(4);
        }
        return actionGroup;
    }

    private static AnAction createShowSettingsAction(final Project project) {
        return new AnAction(JSBundle.message((String)"typescript.compiler.notification.editor.configure", (Object[])new Object[0]), null, AllIcons.General.Settings){

            public void actionPerformed(AnActionEvent e) {
                ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"settings.typescriptcompiler", (String)"");
            }
        };
    }

    TypeScriptLanguageServiceToolWindowManager(Project project, AnAction restartCompilerAction, TypeScriptCompilerSettings settings) {
        super(project, "TypeScript", "reference.tool.windows.typescript", JavaScriptLanguageIcons.Typescript.TypeScript_Compiler, TypeScriptLanguageServiceToolWindowManager.compileActions(project), TypeScriptLanguageServiceToolWindowManager.createShowSettingsAction(project), restartCompilerAction);
        this.myProject = project;
        this.mySettings = settings;
    }

    @Override
    @NotNull
    protected ConsoleViewImpl createConsole() {
        ConsoleViewImpl consoleViewImpl = new ConsoleViewImpl(this.myProject, GlobalSearchScope.allScope((Project)this.myProject), true, false){

            public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
                if (s == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (contentType == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (!TypeScriptLanguageServiceToolWindowManager.this.myProject.isOpen() || TypeScriptLanguageServiceToolWindowManager.this.myProject.isDisposed()) {
                    return;
                }
                if (contentType == ConsoleViewContentType.ERROR_OUTPUT) {
                    super.print(s, ConsoleViewContentType.NORMAL_OUTPUT);
                } else if (contentType == ConsoleViewContentType.NORMAL_OUTPUT && JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                    if (s.length() > 1000) {
                        s = s.substring(0, 1000) + "............(truncated)\n";
                    }
                    super.print(s, ConsoleViewContentType.NORMAL_OUTPUT);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "s";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "contentType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$5";
                objectArray[2] = "print";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (consoleViewImpl == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(5);
        }
        return consoleViewImpl;
    }

    @Override
    @Nullable
    protected AnAction[] getConsoleActions() {
        AnAction[] anActionArray;
        Object[] actions = super.getConsoleActions();
        AnAction showStructure = new AnAction("Show structure", null, AllIcons.Actions.PreviewDetails){

            public void actionPerformed(AnActionEvent e) {
                ToolWindow window = TypeScriptLanguageServiceToolWindowManager.this.myToolWindow;
                if (window != null) {
                    TypeScriptServiceStructureBuilder.StructurePanel panel = TypeScriptLanguageServiceToolWindowManager.this.getOrCreateStructurePanel(window);
                    if (panel == null) {
                        return;
                    }
                    ContentManager manager = window.getContentManager();
                    for (Content content : manager.getContents()) {
                        String name = panel.getName();
                        if (!name.equals(content.getDisplayName())) continue;
                        manager.setSelectedContent(content);
                        panel.refresh();
                        return;
                    }
                }
            }
        };
        if (actions == null) {
            AnAction[] anActionArray2 = new AnAction[1];
            anActionArray = anActionArray2;
            anActionArray2[0] = showStructure;
        } else {
            anActionArray = (AnAction[])ArrayUtil.append((Object[])actions, (Object)showStructure);
        }
        return anActionArray;
    }

    @Override
    protected AnAction[] getErrorPanelRightActions(boolean all) {
        if (all) {
            return super.getErrorPanelRightActions(true);
        }
        String showErrorsText = JSBundle.message((String)"javascript.language.service.default.project.errors", (Object[])new Object[0]);
        this.showErrors = new ToggleAction(showErrorsText, showErrorsText, AllIcons.General.ProjectTab){

            public boolean isSelected(AnActionEvent e) {
                return TypeScriptLanguageServiceToolWindowManager.this.mySettings.isShowAllProjectErrors();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                TypeScriptLanguageServiceToolWindowManager.this.mySettings.setShowAllProjectErrors(state);
                DaemonCodeAnalyzer.getInstance((Project)TypeScriptLanguageServiceToolWindowManager.this.myProject).restart();
                NewErrorTreeViewPanel panel = TypeScriptLanguageServiceToolWindowManager.this.getCurrentErrorTreeViewPanel();
                if (panel != null) {
                    TypeScriptLanguageServiceToolWindowManager.this.updateCurrentErrorsEmptyText(panel);
                }
            }
        };
        return new AnAction[]{this.showErrors};
    }

    @Override
    @NotNull
    protected String getProjectErrorsTitle() {
        if ("Compile errors" == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(6);
        }
        return "Compile errors";
    }

    @Override
    protected void updateCurrentErrorsEmptyText(@NotNull NewErrorTreeViewPanel panel) {
        if (panel == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        StatusText text = panel.getEmptyText();
        if (!this.mySettings.useService()) {
            text.clear();
            text.setText(JSBundle.message((String)"javascript.language.service.tracking.disabled", (Object[])new Object[0]));
            return;
        }
        if (!this.mySettings.isShowAllProjectErrors() && !this.myServiceConsoles.isEmpty()) {
            text.clear();
            text.setText("No errors in the current file. ");
            text.appendText("Show project errors", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    TypeScriptLanguageServiceToolWindowManager.this.showErrors.setSelected(null, true);
                }
            });
            return;
        }
        super.updateCurrentErrorsEmptyText(panel);
    }

    @Override
    public boolean needActivateProgressPanel() {
        return true;
    }

    @Override
    protected void initDefaultPanels(@Nullable ToolWindow toolWindow) {
        super.initDefaultPanels(toolWindow);
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            this.getOrCreateStructurePanel(toolWindow);
        }
    }

    @Nullable
    private TypeScriptServiceStructureBuilder.StructurePanel getOrCreateStructurePanel(@Nullable ToolWindow toolWindow) {
        TypeScriptServiceStructureBuilder.StructurePanel panel = this.myStructurePanel;
        if (panel != null) {
            return panel;
        }
        if (toolWindow != null) {
            this.myStructurePanel = panel = TypeScriptServiceStructureBuilder.registerStructureContent(this.myProject, toolWindow, this.myHelpId);
        }
        return panel;
    }

    @Override
    public synchronized void resetToolWindow() {
        TypeScriptServiceStructureBuilder.StructurePanel panel = this.myStructurePanel;
        if (panel != null) {
            Disposer.dispose((Disposable)panel);
            this.myStructurePanel = null;
        }
        super.resetToolWindow();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertConfigToActions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "compileActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectErrorsTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertConfigToActions";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compileActions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentErrorsEmptyText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$compileActions$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompileForConfigAction
    extends TypeScriptCompileCurrentAction {
        private final TypeScriptConfig myConfigFile;

        public CompileForConfigAction(TypeScriptConfig configFile) {
            super(configFile.getConfigFile().getPath(), null, null);
            this.myConfigFile = configFile;
        }

        @Override
        protected boolean canUseOnlyConfigs(@NotNull Project project, TypeScriptCompilerSettings settings) {
            if (project == null) {
                CompileForConfigAction.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        protected VirtualFile getConfigFile(@Nullable DataContext context) {
            return this.myConfigFile.getConfigFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$CompileForConfigAction", "canUseOnlyConfigs"));
        }
    }
}

