/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceConfigurationEditorUtils {
    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createConfigurationFileTextField(@NotNull Project project) {
        if (project == null) {
            TraceConfigurationEditorUtils.$$$reportNull$$$0(0);
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> {
            if (project == null) {
                TraceConfigurationEditorUtils.$$$reportNull$$$0(5);
            }
            List<VirtualFile> newFiles = TraceConfigurationEditorUtils.listPossibleConfigFilesInProject(project);
            List newFilePaths = ContainerUtil.map(newFiles, file -> FileUtil.toSystemDependentName((String)file.getPath()));
            Collections.sort(newFilePaths);
            return newFilePaths;
        });
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithHistoryWithBrowseButton)textFieldWithHistoryWithBrowseButton, (String)TraceBundle.message("configuration.dialogTitle.config", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)JavaScriptFileType.INSTANCE));
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton2 = textFieldWithHistoryWithBrowseButton;
        if (textFieldWithHistoryWithBrowseButton2 == null) {
            TraceConfigurationEditorUtils.$$$reportNull$$$0(1);
        }
        return textFieldWithHistoryWithBrowseButton2;
    }

    public static void setTextAndAddToHistory(@NotNull TextFieldWithHistory textFieldWithHistory, @Nullable String text) {
        if (textFieldWithHistory == null) {
            TraceConfigurationEditorUtils.$$$reportNull$$$0(2);
        }
        textFieldWithHistory.setText(text);
        textFieldWithHistory.getModel().setSelectedItem(text);
        textFieldWithHistory.addCurrentTextToHistory();
    }

    @NotNull
    private static List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            TraceConfigurationEditorUtils.$$$reportNull$$$0(3);
        }
        GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
        Collection files = FileTypeIndex.getFiles((FileType)JavaScriptFileType.INSTANCE, (GlobalSearchScope)scope);
        ArrayList result = ContainerUtil.newArrayList();
        for (VirtualFile file : files) {
            if (!file.getName().endsWith(".conf.js")) continue;
            result.add(file);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            TraceConfigurationEditorUtils.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/TraceConfigurationEditorUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldWithHistory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/TraceConfigurationEditorUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurationFileTextField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleConfigFilesInProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationFileTextField";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTextAndAddToHistory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleConfigFilesInProject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createConfigurationFileTextField$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

