/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.session;

import com.intellij.javascript.trace.execution.code.CodeRange;
import com.intellij.javascript.trace.execution.code.MappedCodePosition;
import com.intellij.javascript.trace.execution.code.StaticAnotherStatement;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.code.StaticConditionalAlternate;
import com.intellij.javascript.trace.execution.code.StaticConditionalConsequent;
import com.intellij.javascript.trace.execution.code.StaticExceptionElement;
import com.intellij.javascript.trace.execution.code.StaticFuncEnd;
import com.intellij.javascript.trace.execution.code.StaticFuncStart;
import com.intellij.javascript.trace.execution.code.StaticFunctionParameter;
import com.intellij.javascript.trace.execution.code.StaticInReturn;
import com.intellij.javascript.trace.execution.code.StaticLogicalLeft;
import com.intellij.javascript.trace.execution.code.StaticLogicalRight;
import com.intellij.javascript.trace.execution.code.StaticProgramEnd;
import com.intellij.javascript.trace.execution.code.StaticProgramStart;
import com.intellij.javascript.trace.execution.code.StaticReturn;
import com.intellij.javascript.trace.execution.code.StaticSwitch;
import com.intellij.javascript.trace.execution.code.StaticTest;
import com.intellij.javascript.trace.execution.session.TraceSessionCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;

public class StaticCodeElementParser {
    private static final String NODE_PS = "PS";
    private static final String NODE_FS = "FS";
    private static final String NODE_PE = "PE";
    private static final String NODE_FE = "FE";
    private static final String NODE_R = "R";
    private static final String NODE_RB = "RB";
    private static final String NODE_E = "E";
    private static final String NODE_CDC = "CDC";
    private static final String NODE_CDA = "CDA";
    private static final String NODE_LGL = "LGL";
    private static final String NODE_LGR = "LGR";
    private static final String NODE_SWT = "SWT";
    private static final String NODE_TST = "TST";

    public static StaticCodeElement parseCodeElement(String entry, TraceSessionCache cache) {
        String[] callData = entry.split(";");
        String[] params = ArrayUtil.EMPTY_STRING_ARRAY;
        if (callData.length > 1) {
            params = Arrays.copyOfRange(callData, 1, callData.length);
        }
        callData = callData[0].split(",");
        String type = callData[4];
        String func = callData[5];
        String[] fileAndFuncId = callData[6].split("_");
        String fileId = fileAndFuncId[0];
        int funcId = Integer.parseInt(fileAndFuncId[1]);
        String file = cache.getRemoteUrlByFileId(fileId);
        if (!type.equals(NODE_E)) {
            CodeRange codeRange = new CodeRange(Integer.parseInt(callData[0]), Integer.parseInt(callData[1]), Integer.parseInt(callData[2]), Integer.parseInt(callData[3]));
            if (callData.length == 10) {
                codeRange.setMappedCodePosition(new MappedCodePosition(Integer.parseInt(callData[7]), Integer.parseInt(callData[8]), Integer.parseInt(callData[9])));
            }
            if (type.equals(NODE_PS)) {
                return new StaticProgramStart(fileId, file, funcId, func, codeRange);
            }
            if (type.equals(NODE_FS)) {
                return new StaticFuncStart(fileId, file, funcId, func, codeRange, StaticCodeElementParser.parseFuncParams(params));
            }
            if (type.equals(NODE_PE)) {
                return new StaticProgramEnd(file, func, codeRange);
            }
            if (type.equals(NODE_FE)) {
                return new StaticFuncEnd(file, func, codeRange);
            }
            if (type.equals(NODE_R)) {
                return new StaticReturn(file, func, codeRange);
            }
            if (type.equals(NODE_CDC)) {
                return new StaticConditionalConsequent(file, func, codeRange);
            }
            if (type.equals(NODE_CDA)) {
                return new StaticConditionalAlternate(file, func, codeRange);
            }
            if (type.equals(NODE_LGL)) {
                return new StaticLogicalLeft(file, func, codeRange);
            }
            if (type.equals(NODE_LGR)) {
                return new StaticLogicalRight(file, func, codeRange);
            }
            if (type.equals(NODE_RB)) {
                return new StaticInReturn(file, func, codeRange);
            }
            if (type.equals(NODE_SWT)) {
                return new StaticSwitch(file, func, codeRange);
            }
            if (type.equals(NODE_TST)) {
                return new StaticTest(file, func, codeRange);
            }
            return new StaticAnotherStatement(file, func, codeRange);
        }
        return new StaticExceptionElement(file, func, new CodeRange(0, 0, 0, 0));
    }

    private static StaticFunctionParameter[] parseFuncParams(String[] params) {
        return (StaticFunctionParameter[])ContainerUtil.map((Object[])params, data -> {
            String[] paramData = data.split(",");
            CodeRange range = new CodeRange(Integer.parseInt(paramData[0]), Integer.parseInt(paramData[1]), Integer.parseInt(paramData[2]), Integer.parseInt(paramData[3]));
            if (paramData.length == 8) {
                range.setMappedCodePosition(new MappedCodePosition(Integer.parseInt(paramData[5]), Integer.parseInt(paramData[6]), Integer.parseInt(paramData[7])));
            }
            String name = paramData[4];
            return new StaticFunctionParameter(name, range);
        }, (Object[])new StaticFunctionParameter[0]);
    }
}

