/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbGridGotoRelatedProvider;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.StatePreservingNavigatable;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public abstract class OpenEditorAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        boolean mouseSelection = e.getInputEvent() instanceof MouseEvent && UIUtil.isToggleListSelectionEvent((MouseEvent)((MouseEvent)e.getInputEvent()));
        boolean enabled = project != null && e.getData(DatabaseView.DATABASE_VIEW_KEY) != null && !mouseSelection && this.getNavigatables(project, e, false).find(o -> o.canNavigate()) != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || e.isFromActionToolbar());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        for (Navigatable n : this.getNavigatables(project, e, true)) {
            if (n instanceof StatePreservingNavigatable) {
                ((StatePreservingNavigatable)n).navigate(true, true);
                continue;
            }
            n.navigate(true);
        }
    }

    @NotNull
    protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
        if (project == null) {
            OpenEditorAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            OpenEditorAction.$$$reportNull$$$0(3);
        }
        JBIterable jBIterable = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY)));
        if (jBIterable == null) {
            OpenEditorAction.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/OpenEditorAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/OpenEditorAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatables";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class OpenDDLGridAction
    extends AlignedIconWithTextAction
    implements DumbAware {
        OpenDDLGridAction() {
        }

        public void update(AnActionEvent e) {
            PsiElement element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
            boolean enabled = e.getData(DatabaseDataKeys.DATA_GRID_KEY) != null && DbGridGotoRelatedProvider.getTargetElement(element) != null;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            DbElement target2 = DbGridGotoRelatedProvider.getTargetElement((PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT));
            if (target2 == null) {
                return;
            }
            DatabaseTargetElementEvaluator.navigateToSource(target2, true);
        }
    }

    static class OpenDDLAction
    extends OpenEditorAction {
        OpenDDLAction() {
        }

        @Override
        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenDDLAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                OpenDDLAction.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = super.getNavigatables(project, e, forInvoke).filterMap(o -> {
                if (project == null) {
                    OpenDDLAction.$$$reportNull$$$0(3);
                }
                if (!(o instanceof DbElement)) {
                    return o;
                }
                DbElement major = DatabaseTargetElementEvaluator.adjustForNavigation((DbElement)o);
                VirtualFile file = DbImplUtil.findSourceVirtualFile(major, forInvoke);
                if (file == null) {
                    return null;
                }
                if (!forInvoke) {
                    return new OpenFileDescriptor(project, file);
                }
                return DatabaseTargetElementEvaluator.createToSourceNavigatable((DbElement)o);
            }).filter(Navigatable.class);
            if (jBIterable == null) {
                OpenDDLAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDDLAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDDLAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getNavigatables$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class OpenDataAction
    extends OpenEditorAction {
        OpenDataAction() {
        }

        @Override
        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenDataAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                OpenDataAction.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = super.getNavigatables(project, e, forInvoke).map(o -> o instanceof DbTableChild ? ((DbTableChild)o).getParent() : o).filter(DbTable.class).filter(o -> DbImplUtil.isDataTable(o.getKind())).map(o -> o.getVirtualFile()).filter(Conditions.notNull()).map(o -> {
                if (project == null) {
                    OpenDataAction.$$$reportNull$$$0(3);
                }
                return new OpenFileDescriptor(project, o);
            });
            if (jBIterable == null) {
                OpenDataAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDataAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDataAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getNavigatables$3";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class OpenDefaultAction
    extends OpenEditorAction {
        OpenDefaultAction() {
        }

        @Override
        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                OpenDefaultAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                OpenDefaultAction.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = super.getNavigatables(project, e, forInvoke).filter(o -> o instanceof DbElement);
            if (jBIterable == null) {
                OpenDefaultAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/OpenEditorAction$OpenDefaultAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/OpenEditorAction$OpenDefaultAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getNavigatables";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

