/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.vfs.SearchPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlExecutionFlowAnalyzer;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ThreeState;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseAccessController {
    @NotNull
    public Token requestAccess(@NotNull String var1);

    public static class Token {
        final boolean success;
        final String message;
        final String logMessage;

        Token(@Nullable String message, @Nullable String logMessage, boolean success) {
            this.success = success;
            this.message = message;
            this.logMessage = logMessage;
        }

        @NotNull
        static Token success() {
            Token token = new Token(null, null, true);
            if (token == null) {
                Token.$$$reportNull$$$0(0);
            }
            return token;
        }

        static Token rejected(@NotNull String message, @NotNull String logMessage) {
            if (message == null) {
                Token.$$$reportNull$$$0(1);
            }
            if (logMessage == null) {
                Token.$$$reportNull$$$0(2);
            }
            return new Token(message, logMessage, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseAccessController$Token";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "success";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseAccessController$Token";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "rejected";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PsiBased
    implements DatabaseAccessController {
        private final Project myProject;
        private final SqlLanguageDialect myLanguage;
        private final DbDataSource mySource;
        private final Supplier<SearchPath> myPath;

        public PsiBased(@NotNull Project project, @NotNull SqlLanguageDialect language, @NotNull DbDataSource source, @NotNull Supplier<SearchPath> path) {
            if (project == null) {
                PsiBased.$$$reportNull$$$0(0);
            }
            if (language == null) {
                PsiBased.$$$reportNull$$$0(1);
            }
            if (source == null) {
                PsiBased.$$$reportNull$$$0(2);
            }
            if (path == null) {
                PsiBased.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myLanguage = language;
            this.mySource = source;
            this.myPath = path;
        }

        @Override
        @NotNull
        public Token requestAccess(@NotNull String query) {
            if (query == null) {
                PsiBased.$$$reportNull$$$0(4);
            }
            if (this.mySource.isWritable()) {
                Token token = Token.success();
                if (token == null) {
                    PsiBased.$$$reportNull$$$0(5);
                }
                return token;
            }
            SqlExecutionFlowAnalyzer analyzer = SqlPsiFacade.getInstance((Project)this.myProject).getExecutionFlowAnalyzer();
            SqlExecutionFlowAnalyzer.Flow first = (SqlExecutionFlowAnalyzer.Flow)this.traverser(query, (SqlExecutionFlowAnalyzer<PsiElement>)analyzer).traverse().filter(e -> analyzer.isAcceptable(e)).map(e -> analyzer.analyze(e)).filter(Conditions.notNull()).filter(f -> f.isPure() != ThreeState.YES).first();
            Couple message = first == null ? null : (Couple)first.transform((SqlExecutionFlowAnalyzer.FlowTransformer)MyTransformer.INSTANCE);
            Token token = message == null ? Token.success() : Token.rejected((String)message.first, (String)message.second);
            if (token == null) {
                PsiBased.$$$reportNull$$$0(6);
            }
            return token;
        }

        @NotNull
        private SyntaxTraverser<PsiElement> traverser(@NotNull CharSequence text2, @NotNull SqlExecutionFlowAnalyzer<PsiElement> analyzer) {
            if (text2 == null) {
                PsiBased.$$$reportNull$$$0(7);
            }
            if (analyzer == null) {
                PsiBased.$$$reportNull$$$0(8);
            }
            SqlFile psi = SqlPsiFacade.getInstance((Project)this.myProject).createSqlReader().getReadOnlyPsi(this.myLanguage, text2);
            psi.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, (Object)this.mySource);
            psi.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, (Object)this.myPath.get());
            SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)psi).expand(e -> {
                if (analyzer == null) {
                    PsiBased.$$$reportNull$$$0(10);
                }
                return !analyzer.isAcceptable(e);
            });
            if (syntaxTraverser == null) {
                PsiBased.$$$reportNull$$$0(9);
            }
            return syntaxTraverser;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/DatabaseAccessController$PsiBased";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "analyzer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/DatabaseAccessController$PsiBased";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "requestAccess";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "traverser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "requestAccess";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "traverser";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$traverser$3";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyTransformer
        implements SqlExecutionFlowAnalyzer.FlowTransformer<Couple<String>> {
            static final MyTransformer INSTANCE = new MyTransformer();
            static final String DML = "%s to execute a statement that leads to modification of data during a read-only connection";
            static final String DDL = "%s to execute a DDL statement during a read-only connection";
            static final String ROUTINE = "%s to execute a routine that may cause side effects during a read-only connection";

            private MyTransformer() {
            }

            public Couple<String> dml() {
                return MyTransformer.messages(DML);
            }

            public Couple<String> ddl() {
                return MyTransformer.messages(DDL);
            }

            public Couple<String> routine() {
                return MyTransformer.messages(ROUTINE);
            }

            @NotNull
            private static Couple<String> messages(@NotNull String mask) {
                if (mask == null) {
                    MyTransformer.$$$reportNull$$$0(0);
                }
                Couple couple = Couple.of((Object)String.format(mask, "You are attempting"), (Object)String.format(mask, "Attempt"));
                if (couple == null) {
                    MyTransformer.$$$reportNull$$$0(1);
                }
                return couple;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mask";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/DatabaseAccessController$PsiBased$MyTransformer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/DatabaseAccessController$PsiBased$MyTransformer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "messages";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "messages";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

