/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.TranspositionAwareDefaultExtractor;
import com.intellij.database.settings.DatabaseSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SeparatedValuesExtractor<T extends DatabaseSettings.StdState>
extends TranspositionAwareDefaultExtractor<T> {
    public SeparatedValuesExtractor(T state, ObjectFormatter converter) {
        super(state, converter);
    }

    public String getOpeningQuote() {
        return "\"";
    }

    public String getClosingQuote() {
        return "\"";
    }

    @Override
    public String getColumnName(DataConsumer.Column column) {
        return this.getValueLiteral(GenericDialect.INSTANCE, column.name, null, null);
    }

    @Override
    @NotNull
    public String getStringValue(@NotNull DatabaseDialect dialect, @Nullable DataConsumer.Column column, @NotNull String value) {
        if (dialect == null) {
            SeparatedValuesExtractor.$$$reportNull$$$0(0);
        }
        if (value == null) {
            SeparatedValuesExtractor.$$$reportNull$$$0(1);
        }
        String string = this.getOpeningQuote() + this.escapeStringValue(value) + this.getClosingQuote();
        if (string == null) {
            SeparatedValuesExtractor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String escapeStringValue(@NotNull String value) {
        if (value == null) {
            SeparatedValuesExtractor.$$$reportNull$$$0(3);
        }
        String string = value.replace(this.getOpeningQuote(), this.getOpeningQuote() + this.getOpeningQuote());
        if (string == null) {
            SeparatedValuesExtractor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected boolean isStringLiteral(@NotNull DatabaseDialect dialect, @NotNull String value, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column) {
        if (dialect == null) {
            SeparatedValuesExtractor.$$$reportNull$$$0(5);
        }
        if (value == null) {
            SeparatedValuesExtractor.$$$reportNull$$$0(6);
        }
        if (value.length() > 1024 || value.contains(this.getOpeningQuote()) || value.contains(this.getClosingQuote()) || value.contains(this.getValueSeparator())) {
            return true;
        }
        int len = value.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = value.charAt(i2);
            if (!Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/SeparatedValuesExtractor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/SeparatedValuesExtractor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringValue";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "escapeStringValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

