/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.introspection.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Factory;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.JBIterator;
import java.io.Closeable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClosableIt<T>
extends JBIterator<T>
implements Closeable {
    private static final ClosableIt<Object> EMPTY = new ClosableIt<Object>(){

        @Override
        public void close() {
        }

        protected Object nextImpl() {
            return this.stop();
        }
    };

    public static <T> ClosableIt<T> empty() {
        return EMPTY;
    }

    @NotNull
    public static <T> ClosableIt<T> from(final @NotNull Iterator<T> it) {
        if (it == null) {
            ClosableIt.$$$reportNull$$$0(0);
        }
        if (it instanceof ClosableIt) {
            ClosableIt closableIt = (ClosableIt)((Object)it);
            if (closableIt == null) {
                ClosableIt.$$$reportNull$$$0(1);
            }
            return closableIt;
        }
        ClosableIt closableIt = new ClosableIt<T>(){

            @Override
            public void close() {
            }

            protected T nextImpl() {
                return it.hasNext() ? it.next() : this.stop();
            }
        };
        if (closableIt == null) {
            ClosableIt.$$$reportNull$$$0(2);
        }
        return closableIt;
    }

    @NotNull
    static <T> ClosableIt<T> lazyAppend(@NotNull ClosableIt<T> it1, final @NotNull Factory<ClosableIt<T>> next) {
        if (it1 == null) {
            ClosableIt.$$$reportNull$$$0(3);
        }
        if (next == null) {
            ClosableIt.$$$reportNull$$$0(4);
        }
        LazyAppendableClosableIt lazyAppendableClosableIt = new LazyAppendableClosableIt<T>(it1){
            boolean myFirst;
            {
                super(init);
                this.myFirst = true;
            }

            @Override
            @Nullable
            protected ClosableIt<? extends T> nextIt() {
                if (!this.myFirst) {
                    return null;
                }
                this.myFirst = false;
                return (ClosableIt)next.create();
            }
        };
        if (lazyAppendableClosableIt == null) {
            ClosableIt.$$$reportNull$$$0(5);
        }
        return lazyAppendableClosableIt;
    }

    @NotNull
    static <T> ClosableIt<T> lazyAppendIfEmpty(@NotNull ClosableIt<T> it1, @NotNull Factory<ClosableIt<T>> next) {
        if (it1 == null) {
            ClosableIt.$$$reportNull$$$0(6);
        }
        if (next == null) {
            ClosableIt.$$$reportNull$$$0(7);
        }
        boolean[] empty = new boolean[]{true};
        it1.map(cur -> {
            empty[0] = false;
            return cur;
        });
        ClosableIt<T> closableIt = ClosableIt.lazyAppend(it1, () -> {
            if (next == null) {
                ClosableIt.$$$reportNull$$$0(9);
            }
            return empty[0] ? (ClosableIt)next.create() : null;
        });
        if (closableIt == null) {
            ClosableIt.$$$reportNull$$$0(8);
        }
        return closableIt;
    }

    @Override
    public abstract void close();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/ClosableIt";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it1";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/ClosableIt";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "lazyAppend";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "lazyAppendIfEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lazyAppend";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lazyAppendIfEmpty";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$lazyAppendIfEmpty$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class GroupingItImpl<Item, SubItem, Delegate>
    extends GroupingIt<Item, SubItem> {
        protected final ClosableIt<Delegate> myDelegate;
        private GroupIt<SubItem> mySubIt;

        protected GroupingItImpl(@NotNull ClosableIt<Delegate> delegate) {
            if (delegate == null) {
                GroupingItImpl.$$$reportNull$$$0(0);
            }
            this.mySubIt = null;
            this.myDelegate = delegate;
        }

        @NotNull
        protected abstract GroupIt<SubItem> createGroupIt(ClosableIt<Delegate> var1);

        protected abstract Item getItem(ClosableIt<Delegate> var1);

        @Override
        public void close() {
            this.myDelegate.close();
        }

        protected Item nextImpl() {
            if (this.mySubIt == null) {
                if (!this.myDelegate.hasNext()) {
                    return (Item)this.stop();
                }
                this.myDelegate.next();
            }
            while (this.mySubIt != null && this.mySubIt.hasNext()) {
                this.mySubIt.next();
            }
            if (!this.myDelegate.hasNext() && this.mySubIt != null && this.mySubIt.isEof()) {
                return (Item)this.stop();
            }
            this.mySubIt = this.createGroupIt(this.myDelegate);
            return this.getItem(this.myDelegate);
        }

        @Override
        @NotNull
        public JBIterator<SubItem> groupIt() {
            GroupIt<SubItem> groupIt = this.mySubIt;
            if (groupIt == null) {
                GroupingItImpl.$$$reportNull$$$0(1);
            }
            return groupIt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/ClosableIt$GroupingItImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/ClosableIt$GroupingItImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "groupIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        protected static abstract class GroupIt<T>
        extends JBIterator<T> {
            private final JBIterator<T> myIt;
            private boolean myFirst = true;
            private boolean myEof = false;

            public GroupIt(JBIterator<T> it) {
                this.myIt = it;
            }

            protected T nextImpl() {
                if (this.myFirst) {
                    this.myFirst = false;
                    return (T)this.myIt.current();
                }
                if (!this.myIt.advance()) {
                    this.myEof = true;
                    return (T)this.stop();
                }
                return (T)(this.isInGroup(this.myIt.current()) ? this.myIt.current() : this.stop());
            }

            protected abstract boolean isInGroup(T var1);

            public boolean isEof() {
                return this.myEof;
            }
        }
    }

    public static abstract class GroupingIt<Item, SubItem>
    extends ClosableIt<Item> {
        @NotNull
        public abstract JBIterator<SubItem> groupIt();
    }

    static abstract class ResultSetDelegateIt<T>
    extends ClosableIt<T> {
        protected final MetaDataUtil.ResultSetWrapper myRs;
        private final AutoCloseable myHook;
        private PairConsumer<String, Throwable> myErrorSink;
        private Boolean myInitialHasNext;

        public ResultSetDelegateIt(@Nullable ResultSet rs, @Nullable AutoCloseable hook) throws SQLException {
            this(MetaDataUtil.ResultSetWrapper.wrap(rs), hook, null);
        }

        public ResultSetDelegateIt(@NotNull MetaDataUtil.ResultSetWrapper rs, @Nullable AutoCloseable hook, @Nullable Boolean initialHasNext) throws SQLException {
            if (rs == null) {
                ResultSetDelegateIt.$$$reportNull$$$0(0);
            }
            this.myRs = rs;
            this.myHook = hook;
            this.myInitialHasNext = initialHasNext;
        }

        public ClosableIt<T> withErrorSink(PairConsumer<String, Throwable> errorSink2) {
            this.myErrorSink = errorSink2;
            return this;
        }

        @Override
        public void close() {
            try {
                MetaDataUtil.ResultSetWrapper.close(this.myRs);
            }
            finally {
                block9: {
                    if (this.myHook != null) {
                        try {
                            this.myHook.close();
                        }
                        catch (Exception e) {
                            if (this.myErrorSink == null) break block9;
                            this.myErrorSink.consume(null, (Object)e);
                        }
                    }
                }
            }
        }

        protected T nextImpl() {
            try {
                if (this.myInitialHasNext != null) {
                    boolean hasNext = this.myInitialHasNext;
                    this.myInitialHasNext = null;
                    return (T)(hasNext ? this.calcValue() : this.stop());
                }
                if (this.myRs.next()) {
                    return this.calcValue();
                }
            }
            catch (SQLException e) {
                this.onError(null, e);
            }
            return (T)this.stop();
        }

        protected abstract T calcValue() throws SQLException;

        public void onError(T cur, SQLException e) {
            if (this.myErrorSink != null) {
                this.myErrorSink.consume(null, (Object)e);
            }
        }

        public void addError(String title, SQLException e) {
            if (this.myErrorSink != null) {
                this.myErrorSink.consume((Object)title, (Object)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/database/introspection/jdbcMetadataWrappers/ClosableIt$ResultSetDelegateIt", "<init>"));
        }
    }

    static class AutoCloseableGuard<T extends AutoCloseable>
    implements AutoCloseable {
        private final Logger LOG = Logger.getInstance(AutoCloseableGuard.class);
        private T myStored;

        public static <T extends AutoCloseable> AutoCloseableGuard<T> guarded(@Nullable T ac) {
            return new AutoCloseableGuard<T>(ac);
        }

        public AutoCloseableGuard(@Nullable T stored) {
            this.myStored = stored;
        }

        @Override
        public void close() {
            if (this.myStored == null) {
                return;
            }
            try {
                this.myStored.close();
            }
            catch (Exception e) {
                this.LOG.warn((Throwable)e);
            }
        }

        public T get() {
            return this.myStored;
        }

        public T release() {
            T stored = this.myStored;
            this.myStored = null;
            return stored;
        }
    }

    static abstract class ResultSetClosableIt<T>
    extends ResultSetDelegateIt<T> {
        private MutableStorage<T> myStorage;

        public ResultSetClosableIt(@Nullable ResultSet rs) throws SQLException {
            super(rs, null);
        }

        public ResultSetClosableIt(@NotNull MetaDataUtil.ResultSetWrapper rs, @Nullable Boolean initialHasNext) throws SQLException {
            if (rs == null) {
                ResultSetClosableIt.$$$reportNull$$$0(0);
            }
            super(rs, null, initialHasNext);
        }

        private MutableStorage<T> getStorage() {
            if (this.myStorage == null) {
                this.myStorage = new MutableStorage<T>(this.createStorage(), this.createStorage());
            }
            return this.myStorage;
        }

        @NotNull
        protected T getStorageToFill() {
            T t = this.getStorage().current();
            if (t == null) {
                ResultSetClosableIt.$$$reportNull$$$0(1);
            }
            return t;
        }

        @NotNull
        protected abstract T createStorage();

        protected void currentChanged() {
            this.getStorage().flip();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/ClosableIt$ResultSetClosableIt";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/ClosableIt$ResultSetClosableIt";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStorageToFill";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static abstract class DelegateMutableIt<E, T>
    extends DelegateIt<E, T> {
        private MutableStorage<T> myStorage;

        public DelegateMutableIt(Iterator<? extends E> it) {
            super(it);
        }

        private MutableStorage<T> getStorage() {
            if (this.myStorage == null) {
                this.myStorage = new MutableStorage<T>(this.createStorage(), this.createStorage());
            }
            return this.myStorage;
        }

        @NotNull
        protected T getStorageToFill() {
            T t = this.getStorage().current();
            if (t == null) {
                DelegateMutableIt.$$$reportNull$$$0(0);
            }
            return t;
        }

        @NotNull
        protected abstract T createStorage();

        protected void currentChanged() {
            this.getStorage().flip();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/ClosableIt$DelegateMutableIt", "getStorageToFill"));
        }
    }

    static abstract class DelegateIt<E, T>
    extends ClosableIt<T> {
        private final Iterator<? extends E> myIt;

        public DelegateIt(Iterator<? extends E> it) {
            this.myIt = it;
        }

        @Override
        public void close() {
            if (this.myIt instanceof ClosableIt) {
                ((ClosableIt)((Object)this.myIt)).close();
            }
        }

        protected T nextImpl() {
            if (!this.myIt.hasNext()) {
                return (T)this.stop();
            }
            return this.calcValue(this.myIt.next());
        }

        protected abstract T calcValue(E var1);
    }

    static class MutableStorage<T> {
        private T myCurStorage;
        private T myBackStorage;

        public MutableStorage(T curStorage, T backStorage) {
            this.myCurStorage = curStorage;
            this.myBackStorage = backStorage;
        }

        @NotNull
        protected T current() {
            T t = this.myBackStorage;
            if (t == null) {
                MutableStorage.$$$reportNull$$$0(0);
            }
            return t;
        }

        protected void flip() {
            T tmp = this.myCurStorage;
            this.myCurStorage = this.myBackStorage;
            this.myBackStorage = tmp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/jdbcMetadataWrappers/ClosableIt$MutableStorage", "current"));
        }
    }

    static abstract class LazyAppendableClosableIt<T>
    extends ClosableIt<T> {
        private ClosableIt<? extends T> myIt;

        public LazyAppendableClosableIt(@Nullable ClosableIt<? extends T> init) {
            this.myIt = init;
        }

        @Override
        public void close() {
            if (this.myIt != null) {
                this.myIt.close();
            }
        }

        @Nullable
        protected abstract ClosableIt<? extends T> nextIt();

        protected T nextImpl() {
            if (this.myIt != null && this.myIt.hasNext()) {
                return (T)this.myIt.next();
            }
            do {
                if (this.myIt != null) {
                    this.myIt.close();
                    this.myIt = null;
                }
                this.myIt = this.nextIt();
            } while (this.myIt != null && !this.myIt.hasNext());
            return (T)(this.myIt == null ? this.stop() : this.myIt.next());
        }
    }
}

