/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.postgresbase.PostgresBaseDatabase;
import com.intellij.database.model.postgresbase.PostgresBaseModel;
import com.intellij.database.model.postgresbase.PostgresBaseRoutine;
import com.intellij.database.model.properties.RedshiftTableBackupMode;
import com.intellij.database.model.properties.RedshiftTableDistStyle;
import com.intellij.database.model.redshift.RedshiftDatabase;
import com.intellij.database.model.redshift.RedshiftModel;
import com.intellij.database.model.redshift.RedshiftModelFunKt;
import com.intellij.database.model.redshift.RedshiftSchema;
import com.intellij.database.model.redshift.RedshiftTable;
import com.intellij.database.model.redshift.RedshiftTableColumn;
import com.intellij.database.model.redshift.RedshiftUser;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.PostgresBaseScriptingService;
import com.intellij.database.scripting.RedshiftScriptingService$PROVIDER$WhenMappings;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.redshift.RedshiftDropGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0002\r\u000eB\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/scripting/RedshiftScriptingService;", "Lcom/intellij/database/scripting/PostgresBaseScriptingService;", "Lcom/intellij/database/model/redshift/RedshiftModel;", "Lcom/intellij/database/model/redshift/RedshiftDatabase;", "Lcom/intellij/database/model/redshift/RedshiftSchema;", "model", "database", "(Lcom/intellij/database/model/redshift/RedshiftModel;Lcom/intellij/database/model/redshift/RedshiftDatabase;)V", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "createDropGenerator", "PROVIDER", "RedshiftCreatingGenerator", "database-scripting"})
public final class RedshiftScriptingService
extends PostgresBaseScriptingService<RedshiftModel, RedshiftDatabase, RedshiftSchema> {
    @Override
    @NotNull
    protected AbstractCodeGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new RedshiftCreatingGenerator(this.getContext(), task);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createDropGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new RedshiftDropGenerator(super.getContext(), task);
    }

    public RedshiftScriptingService(@NotNull RedshiftModel model, @NotNull RedshiftDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        super((PostgresBaseModel)model, (PostgresBaseDatabase)database);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/scripting/RedshiftScriptingService$PROVIDER;", "Lcom/intellij/database/scripting/AbstractScriptingService$Provider;", "()V", "VERSION", "Lcom/intellij/database/model/PerObjectVersion;", "create", "Lcom/intellij/database/scripting/RedshiftScriptingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "isSupported", "", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "kind", "Lcom/intellij/database/model/ObjectKind;", "context", "", "scriptingVersion", "", "database-scripting"})
    public static final class PROVIDER
    implements AbstractScriptingService.Provider {
        private static final PerObjectVersion VERSION;
        public static final PROVIDER INSTANCE;

        @NotNull
        public RedshiftScriptingService create(@NotNull BasicModel model, @Nullable BasicDatabase database) {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            BasicDatabase basicDatabase = database;
            if (basicDatabase == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.redshift.RedshiftDatabase");
            }
            return new RedshiftScriptingService((RedshiftModel)model, (RedshiftDatabase)basicDatabase);
        }

        @Override
        public int scriptingVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            return VERSION.get(kind);
        }

        @Override
        public boolean isSupported(@NotNull ScriptingTask task, @NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            switch (RedshiftScriptingService$PROVIDER$WhenMappings.$EnumSwitchMapping$0[task.ordinal()]) {
                case 1: {
                    bl = RedshiftDropGenerator.Companion.canDrop(kind, context);
                    break;
                }
                default: {
                    bl = true;
                }
            }
            return bl;
        }

        private PROVIDER() {
        }

        static {
            PROVIDER pROVIDER;
            INSTANCE = pROVIDER = new PROVIDER();
            VERSION = new PerObjectVersion();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00180\u0001R\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0002B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/scripting/RedshiftScriptingService$RedshiftCreatingGenerator;", "Lcom/intellij/database/scripting/PostgresBaseScriptingService$PgBaseCreatingGenerator;", "Lcom/intellij/database/scripting/PostgresBaseScriptingService;", "Lcom/intellij/database/model/redshift/RedshiftModel;", "Lcom/intellij/database/model/redshift/RedshiftDatabase;", "Lcom/intellij/database/model/redshift/RedshiftSchema;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/RedshiftScriptingService;Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateUser", "role", "Lcom/intellij/database/model/redshift/RedshiftUser;", "getVolatilityKind", "", "f", "Lcom/intellij/database/model/postgresbase/PostgresBaseRoutine;", "makeColumnDefinition", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "table", "Lcom/intellij/database/model/basic/BasicTable;", "tableFooter", "database-scripting"})
    private final class RedshiftCreatingGenerator
    extends PostgresBaseScriptingService.PgBaseCreatingGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof RedshiftUser) {
                this.generateUser((RedshiftUser)element);
            } else {
                super.generateElement(element);
            }
        }

        @Override
        @Nullable
        protected String getVolatilityKind(@NotNull PostgresBaseRoutine f) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
            Object object = f.getVolatilityKind();
            if (object != null && (object = object.name()) != null) {
                Object object2;
                Object object3 = object2 = object;
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object3).toLowerCase();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            } else {
                string = null;
            }
            return string;
        }

        private final void generateUser(RedshiftUser role) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, role){
                final /* synthetic */ RedshiftCreatingGenerator this$0;
                final /* synthetic */ RedshiftUser $role;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $receiver$iv;
                    CodeTextBuilder this_$iv;
                    CharSequence[] charSequenceArray = new CharSequence[5];
                    charSequenceArray[0] = "create";
                    charSequenceArray[1] = "user";
                    String string = this.$role.getName();
                    RedshiftCreatingGenerator redshiftCreatingGenerator = this.this$0;
                    int n = 2;
                    CharSequence[] charSequenceArray2 = charSequenceArray;
                    CharSequence[] charSequenceArray3 = charSequenceArray;
                    CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                    String string2 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)((Object)this_$iv)).nameToScript((String)$receiver$iv);
                    charSequenceArray2[n] = string2;
                    CharSequence[] charSequenceArray4 = charSequenceArray3;
                    charSequenceArray3[3] = "password";
                    charSequenceArray4[4] = "disable";
                    codeTextBuilder.phrase(charSequenceArray4);
                    this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        String validUntil;
                        if (this.$role.isCreateDb()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "createdb", null, false, 6, null);
                        }
                        if (this.$role.isSuperUser()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "createuser", null, false, 6, null);
                        }
                        if (this.$role.getConnectionLimit() >= 0L) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "connection limit " + this.$role.getConnectionLimit(), null, false, 6, null);
                        }
                        if ((validUntil = this.$role.getValidUntil()) != null) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "valid until " + this.this$0.getSqlString(validUntil), null, false, 6, null);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                }
                {
                    this.this$0 = redshiftCreatingGenerator;
                    this.$role = redshiftUser;
                    super(0);
                }
            }, 3, null);
            for (String param : role.getConfig()) {
                AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, role, param){
                    final /* synthetic */ RedshiftCreatingGenerator this$0;
                    final /* synthetic */ RedshiftUser $role;
                    final /* synthetic */ String $param;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $receiver$iv;
                        void this_$iv;
                        CharSequence[] charSequenceArray = new CharSequence[5];
                        charSequenceArray[0] = "alter";
                        charSequenceArray[1] = "user";
                        String string = this.$role.getName();
                        RedshiftCreatingGenerator redshiftCreatingGenerator = this.this$0;
                        int n = 2;
                        CharSequence[] charSequenceArray2 = charSequenceArray;
                        CharSequence[] charSequenceArray3 = charSequenceArray;
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        String string2 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                        charSequenceArray2[n] = string2;
                        CharSequence[] charSequenceArray4 = charSequenceArray3;
                        charSequenceArray3[3] = "set";
                        charSequenceArray4[4] = this.$param;
                        codeTextBuilder.phrase(charSequenceArray4);
                    }
                    {
                        this.this$0 = redshiftCreatingGenerator;
                        this.$role = redshiftUser;
                        this.$param = string;
                        super(0);
                    }
                }, 3, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final String tableFooter(BasicTable table) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            RedshiftTableDistStyle style;
            StringBuilder b = new StringBuilder();
            BasicTable basicTable = table;
            if (!(basicTable instanceof RedshiftTable)) {
                basicTable = null;
            }
            RedshiftTable redshiftTable = (RedshiftTable)basicTable;
            if (redshiftTable == null) {
                return "";
            }
            RedshiftTable rsTable = redshiftTable;
            if (Intrinsics.areEqual((Object)((Object)rsTable.getBackupMode()), (Object)((Object)RedshiftTableBackupMode.ON)) ^ true) {
                b.append("backup no\n");
            }
            if (Intrinsics.areEqual((Object)((Object)(style = rsTable.getDistStyle())), (Object)((Object)RedshiftTableDistStyle.EVEN)) ^ true) {
                String string = style.name();
                StringBuilder stringBuilder = new StringBuilder().append("diststyle ");
                StringBuilder stringBuilder2 = b;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                String string4 = string3;
                stringBuilder2.append(stringBuilder.append(string4).append('\n').toString());
            }
            Iterable iterable = $receiver$iv = (Iterable)rsTable.getColumns();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                RedshiftTableColumn it = (RedshiftTableColumn)element$iv$iv;
                if (!(it.getSortKeyOrder() != 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            List sortedColumns = CollectionsKt.sortedWith((Iterable)$receiver$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    RedshiftTableColumn it = (RedshiftTableColumn)a;
                    Comparable comparable = Integer.valueOf(Math.abs(it.getSortKeyOrder()));
                    it = (RedshiftTableColumn)b;
                    Comparable comparable2 = comparable;
                    Integer n = Math.abs(it.getSortKeyOrder());
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
            if (sortedColumns.isEmpty()) {
                String string = b.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
                return string;
            }
            if (RedshiftModelFunKt.hasInterleavedSortKey(rsTable)) {
                b.append("interleaved ");
            }
            b.append("sortkey(");
            $receiver$iv = sortedColumns;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void col;
                Object element$iv$iv;
                int n = index$iv++;
                element$iv$iv = (RedshiftTableColumn)item$iv;
                int idx = n;
                if (idx != 0) {
                    b.append(", ");
                }
                b.append(col.getName());
            }
            b.append(")\n");
            String string = b.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
            return string;
        }

        @Override
        @NotNull
        protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            HeaderFooter hf = super.makeTableHeaderFooter(table);
            return new HeaderFooter(hf.getHeader(), this.tableFooter(table));
        }

        @Override
        @Nullable
        protected String makeColumnDefinition(@NotNull BasicLikeColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            String string = super.makeColumnDefinition(column);
            if (string == null) {
                return null;
            }
            String def = string;
            StringBuilder b = new StringBuilder();
            if (!(column instanceof RedshiftTableColumn)) {
                return def + b;
            }
            if (!RedshiftModelFunKt.isDefaultEncoding((RedshiftTableColumn)column)) {
                b.append(" encode " + ((RedshiftTableColumn)column).getEncoding());
            }
            if (((RedshiftTableColumn)column).isDistKey()) {
                b.append(" distkey");
            }
            return def + b;
        }

        public RedshiftCreatingGenerator(@NotNull ScriptingContext context, ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(context, task);
        }
    }
}

