/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.mssql;

import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.mssql.MsCheck;
import com.intellij.database.model.mssql.MsConstraint;
import com.intellij.database.model.mssql.MsCustomType;
import com.intellij.database.model.mssql.MsDatabase;
import com.intellij.database.model.mssql.MsForeignKey;
import com.intellij.database.model.mssql.MsIndex;
import com.intellij.database.model.mssql.MsKey;
import com.intellij.database.model.mssql.MsRoutine;
import com.intellij.database.model.mssql.MsSchema;
import com.intellij.database.model.mssql.MsSequence;
import com.intellij.database.model.mssql.MsSynonym;
import com.intellij.database.model.mssql.MsTable;
import com.intellij.database.model.mssql.MsTableColumn;
import com.intellij.database.model.mssql.MsTrigger;
import com.intellij.database.model.mssql.MsView;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseDropGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.H\u0002\u00a8\u00060"}, d2={"Lcom/intellij/database/scripting/mssql/MsDropGenerator;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateConstraint", "", "constraint", "Lcom/intellij/database/model/mssql/MsConstraint;", "generateDatabase", "db", "Lcom/intellij/database/model/mssql/MsDatabase;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateIndex", "index", "Lcom/intellij/database/model/mssql/MsIndex;", "generateRoutine", "r", "Lcom/intellij/database/model/mssql/MsRoutine;", "generateSchema", "schema", "Lcom/intellij/database/model/mssql/MsSchema;", "generateSequence", "seq", "Lcom/intellij/database/model/mssql/MsSequence;", "generateSynonym", "syn", "Lcom/intellij/database/model/mssql/MsSynonym;", "generateTable", "table", "Lcom/intellij/database/model/mssql/MsTable;", "generateTableColumn", "column", "Lcom/intellij/database/model/mssql/MsTableColumn;", "generateTrigger", "trigger", "Lcom/intellij/database/model/mssql/MsTrigger;", "generateType", "type", "Lcom/intellij/database/model/mssql/MsCustomType;", "generateView", "view", "Lcom/intellij/database/model/mssql/MsView;", "Companion", "database-scripting"})
public final class MsDropGenerator
extends BaseDropGenerator {
    private static final Set<ObjectKind> SUPPORTED;
    public static final Companion Companion;

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element.getParent();
        if (Intrinsics.areEqual((Object)(basicElement != null ? basicElement.getKind() : null), (Object)ObjectKind.TABLE_TYPE)) {
            this.unknownHowToDrop(element);
            return;
        }
        BasicElement basicElement2 = element;
        if (basicElement2 instanceof MsDatabase) {
            this.generateDatabase((MsDatabase)element);
        } else if (basicElement2 instanceof MsRoutine) {
            this.generateRoutine((MsRoutine)element);
        } else if (basicElement2 instanceof MsIndex) {
            this.generateIndex((MsIndex)element);
        } else if (basicElement2 instanceof MsSchema) {
            this.generateSchema((MsSchema)element);
        } else if (basicElement2 instanceof MsSequence) {
            this.generateSequence((MsSequence)element);
        } else if (basicElement2 instanceof MsSynonym) {
            this.generateSynonym((MsSynonym)element);
        } else if (basicElement2 instanceof MsTable) {
            this.generateTable((MsTable)element);
        } else if (basicElement2 instanceof MsTrigger) {
            this.generateTrigger((MsTrigger)element);
        } else if (basicElement2 instanceof MsCustomType) {
            this.generateType((MsCustomType)element);
        } else if (basicElement2 instanceof MsView) {
            this.generateView((MsView)element);
        } else if (basicElement2 instanceof MsKey || basicElement2 instanceof MsCheck || basicElement2 instanceof MsForeignKey) {
            this.generateConstraint((MsConstraint)element);
        } else if (basicElement2 instanceof MsTableColumn) {
            this.generateTableColumn((MsTableColumn)element);
        } else {
            this.unknownHowToDrop(element);
        }
    }

    private final void generateTableColumn(MsTableColumn column) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, column){
            final /* synthetic */ MsDropGenerator this$0;
            final /* synthetic */ MsTableColumn $column;

            public final void invoke() {
                Object object;
                MsDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", (object = this.$column.getLikeTable()) != null && (object = MsDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop column", MsDropGenerator.access$ifExists(this.this$0), MsDropGenerator.access$getScr$p(this.this$0, this.$column.getName()));
            }
            {
                this.this$0 = msDropGenerator;
                this.$column = msTableColumn;
                super(0);
            }
        }, 3, null);
    }

    private final void generateConstraint(MsConstraint constraint) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, constraint){
            final /* synthetic */ MsDropGenerator this$0;
            final /* synthetic */ MsConstraint $constraint;

            public final void invoke() {
                Object object;
                MsDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", (object = this.$constraint.getLikeTable()) != null && (object = MsDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop constraint", MsDropGenerator.access$ifExists(this.this$0), MsDropGenerator.access$getScr$p(this.this$0, this.$constraint.getName()));
            }
            {
                this.this$0 = msDropGenerator;
                this.$constraint = msConstraint;
                super(0);
            }
        }, 3, null);
    }

    private final void generateView(MsView view) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view){
            final /* synthetic */ MsDropGenerator this$0;
            final /* synthetic */ MsView $view;

            public final void invoke() {
                MsDropGenerator.access$getBuilder$p(this.this$0).phrase("drop view", MsDropGenerator.access$ifExists(this.this$0), MsDropGenerator.access$currentScopeName(this.this$0, this.$view));
            }
            {
                this.this$0 = msDropGenerator;
                this.$view = msView;
                super(0);
            }
        }, 3, null);
    }

    private final void generateType(MsCustomType type) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, type){
            final /* synthetic */ MsDropGenerator this$0;
            final /* synthetic */ MsCustomType $type;

            public final void invoke() {
                MsDropGenerator.access$getBuilder$p(this.this$0).phrase("drop type", MsDropGenerator.access$ifExists(this.this$0), MsDropGenerator.access$currentScopeName(this.this$0, this.$type));
            }
            {
                this.this$0 = msDropGenerator;
                this.$type = msCustomType;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTrigger(MsTrigger trigger) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger){
            final /* synthetic */ MsDropGenerator this$0;
            final /* synthetic */ MsTrigger $trigger;

            public final void invoke() {
                Object object;
                MsDropGenerator.access$getBuilder$p(this.this$0).phrase("drop trigger", MsDropGenerator.access$ifExists(this.this$0), MsDropGenerator.access$getScr$p(this.this$0, this.$trigger.getName()), "on", (object = this.$trigger.getLikeTable()) != null && (object = MsDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???");
            }
            {
                this.this$0 = msDropGenerator;
                this.$trigger = msTrigger;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTable(MsTable table) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
            final /* synthetic */ MsDropGenerator this$0;
            final /* synthetic */ MsTable $table;

            public final void invoke() {
                MsDropGenerator.access$getBuilder$p(this.this$0).phrase("drop table", MsDropGenerator.access$ifExists(this.this$0), MsDropGenerator.access$currentScopeName(this.this$0, this.$table));
            }
            {
                this.this$0 = msDropGenerator;
                this.$table = msTable;
                super(0);
            }
        }, 3, null);
    }

    private final void generateSynonym(MsSynonym syn) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, syn){
            final /* synthetic */ MsDropGenerator this$0;
            final /* synthetic */ MsSynonym $syn;

            public final void invoke() {
                MsDropGenerator.access$getBuilder$p(this.this$0).phrase("drop synonym", MsDropGenerator.access$ifExists(this.this$0), MsDropGenerator.access$currentScopeName(this.this$0, this.$syn));
            }
            {
                this.this$0 = msDropGenerator;
                this.$syn = msSynonym;
                super(0);
            }
        }, 3, null);
    }

    private final void generateSequence(MsSequence seq) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, seq){
            final /* synthetic */ MsDropGenerator this$0;
            final /* synthetic */ MsSequence $seq;

            public final void invoke() {
                MsDropGenerator.access$getBuilder$p(this.this$0).phrase("drop sequence", MsDropGenerator.access$ifExists(this.this$0), MsDropGenerator.access$currentScopeName(this.this$0, this.$seq));
            }
            {
                this.this$0 = msDropGenerator;
                this.$seq = msSequence;
                super(0);
            }
        }, 3, null);
    }

    private final void generateSchema(MsSchema schema) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, schema){
            final /* synthetic */ MsDropGenerator this$0;
            final /* synthetic */ MsSchema $schema;

            public final void invoke() {
                MsDropGenerator.access$getBuilder$p(this.this$0).phrase("drop schema", MsDropGenerator.access$ifExists(this.this$0), MsDropGenerator.access$currentScopeName(this.this$0, this.$schema));
            }
            {
                this.this$0 = msDropGenerator;
                this.$schema = msSchema;
                super(0);
            }
        }, 3, null);
    }

    private final void generateIndex(MsIndex index) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, index){
            final /* synthetic */ MsDropGenerator this$0;
            final /* synthetic */ MsIndex $index;

            public final void invoke() {
                Object object;
                MsDropGenerator.access$getBuilder$p(this.this$0).phrase("drop index", MsDropGenerator.access$ifExists(this.this$0), MsDropGenerator.access$getScr$p(this.this$0, this.$index.getName()), "on", (object = this.$index.getLikeTable()) != null && (object = MsDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???");
            }
            {
                this.this$0 = msDropGenerator;
                this.$index = msIndex;
                super(0);
            }
        }, 3, null);
    }

    private final void generateRoutine(MsRoutine r) {
        String rt = Intrinsics.areEqual((Object)r.getRoutineKind(), (Object)DasRoutine.Kind.FUNCTION) ? "function" : "procedure";
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, rt, r){
            final /* synthetic */ MsDropGenerator this$0;
            final /* synthetic */ String $rt;
            final /* synthetic */ MsRoutine $r;

            public final void invoke() {
                MsDropGenerator.access$getBuilder$p(this.this$0).phrase("drop", this.$rt, MsDropGenerator.access$ifExists(this.this$0), MsDropGenerator.access$currentScopeName(this.this$0, this.$r));
            }
            {
                this.this$0 = msDropGenerator;
                this.$rt = string;
                this.$r = msRoutine;
                super(0);
            }
        }, 3, null);
    }

    private final void generateDatabase(MsDatabase db) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, db){
            final /* synthetic */ MsDropGenerator this$0;
            final /* synthetic */ MsDatabase $db;

            public final void invoke() {
                MsDropGenerator.access$getBuilder$p(this.this$0).phrase("drop database", MsDropGenerator.access$ifExists(this.this$0), MsDropGenerator.access$currentScopeName(this.this$0, this.$db));
            }
            {
                this.this$0 = msDropGenerator;
                this.$db = msDatabase;
                super(0);
            }
        }, 3, null);
    }

    public MsDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        super(context, task);
    }

    static {
        Companion = new Companion(null);
        SUPPORTED = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.DATABASE, ObjectKind.ROUTINE, ObjectKind.SCHEMA, ObjectKind.SEQUENCE, ObjectKind.SYNONYM, ObjectKind.TABLE, ObjectKind.TRIGGER, ObjectKind.ALIAS_TYPE, ObjectKind.TABLE_TYPE, ObjectKind.VIEW, ObjectKind.FOREIGN_KEY});
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(MsDropGenerator $this) {
        return $this.getBuilder();
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(MsDropGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }

    @Nullable
    public static final /* synthetic */ String access$ifExists(MsDropGenerator $this) {
        return $this.ifExists();
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(MsDropGenerator $this, @NotNull String $receiver) {
        return $this.getScr($receiver);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rR\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/mssql/MsDropGenerator$Companion;", "", "()V", "SUPPORTED", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "getSUPPORTED", "()Ljava/util/Set;", "canDrop", "", "kind", "context", "", "database-scripting"})
    public static final class Companion {
        private final Set<ObjectKind> getSUPPORTED() {
            return SUPPORTED;
        }

        public final boolean canDrop(@NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            ObjectKind objectKind = kind;
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLUMN)) {
                ObjectKind objectKind2 = (ObjectKind)CollectionsKt.firstOrNull(context);
                if (objectKind2 == null) {
                    objectKind2 = ObjectKind.TABLE;
                }
                bl = Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.TABLE);
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.KEY) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.CHECK) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.INDEX)) {
                ObjectKind objectKind3 = (ObjectKind)CollectionsKt.firstOrNull(context);
                if (objectKind3 == null) {
                    objectKind3 = ObjectKind.TABLE;
                }
                bl = Intrinsics.areEqual((Object)objectKind3, (Object)ObjectKind.TABLE_TYPE) ^ true;
            } else {
                bl = this.getSUPPORTED().contains(kind);
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

