/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.postgres;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.postgresbase.PostgresBaseConstraint;
import com.intellij.database.model.postgresbase.PostgresBaseDatabase;
import com.intellij.database.model.postgresbase.PostgresBaseRoutine;
import com.intellij.database.model.postgresbase.PostgresBaseSchema;
import com.intellij.database.model.postgresbase.PostgresBaseTable;
import com.intellij.database.model.postgresbase.PostgresBaseTableColumn;
import com.intellij.database.model.postgresbase.PostgresBaseView;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseDropGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Postgres;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0010\u0018\u0000 #2\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0002\u00a8\u0006$"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresBaseDropGenerator;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateDatabase", "", "db", "Lcom/intellij/database/model/postgresbase/PostgresBaseDatabase;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateFunction", "Lcom/intellij/database/model/postgresbase/PostgresBaseRoutine;", "generateSchema", "sc", "Lcom/intellij/database/model/postgresbase/PostgresBaseSchema;", "generateTable", "table", "Lcom/intellij/database/model/postgresbase/PostgresBaseTable;", "generateTableColumn", "column", "Lcom/intellij/database/model/postgresbase/PostgresBaseTableColumn;", "generateTableConstraint", "c", "Lcom/intellij/database/model/postgresbase/PostgresBaseConstraint;", "generateView", "view", "Lcom/intellij/database/model/postgresbase/PostgresBaseView;", "isPg", "", "pgIfExists", "", "Companion", "database-scripting"})
public class PostgresBaseDropGenerator
extends BaseDropGenerator {
    private static final Set<ObjectKind> SUPPORTED;
    public static final Companion Companion;

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof PostgresBaseDatabase) {
            this.generateDatabase((PostgresBaseDatabase)element);
        } else if (basicElement instanceof PostgresBaseRoutine) {
            this.generateFunction((PostgresBaseRoutine)element);
        } else if (basicElement instanceof PostgresBaseSchema) {
            this.generateSchema((PostgresBaseSchema)element);
        } else if (basicElement instanceof PostgresBaseTable) {
            this.generateTable((PostgresBaseTable)element);
        } else if (basicElement instanceof PostgresBaseView) {
            this.generateView((PostgresBaseView)element);
        } else if (basicElement instanceof PostgresBaseTableColumn) {
            this.generateTableColumn((PostgresBaseTableColumn)element);
        } else if (basicElement instanceof PostgresBaseConstraint) {
            this.generateTableConstraint((PostgresBaseConstraint)element);
        } else {
            this.unknownHowToDrop(element);
        }
    }

    private final void generateTableConstraint(PostgresBaseConstraint c) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, c){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseConstraint $c;

            public final void invoke() {
                Object object;
                PostgresBaseDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", (object = this.$c.getLikeTable()) != null && (object = PostgresBaseDropGenerator.access$currentScopeName(this.this$0, (BasicElement)object)) != null ? (CharSequence)object : (CharSequence)"???", "drop constraint", PostgresBaseDropGenerator.access$pgIfExists(this.this$0), PostgresBaseDropGenerator.access$getScr$p(this.this$0, this.$c.getName()), PostgresBaseDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$c = postgresBaseConstraint;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTableColumn(PostgresBaseTableColumn column) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, column){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseTableColumn $column;

            public final void invoke() {
                PostgresBaseDropGenerator.access$getBuilder$p(this.this$0).phrase("alter table", PostgresBaseDropGenerator.access$currentScopeName(this.this$0, this.$column.getTable()), "drop column", PostgresBaseDropGenerator.access$pgIfExists(this.this$0), PostgresBaseDropGenerator.access$getScr$p(this.this$0, this.$column.getName()), PostgresBaseDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$column = postgresBaseTableColumn;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTable(PostgresBaseTable table) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseTable $table;

            public final void invoke() {
                PostgresBaseDropGenerator.access$getBuilder$p(this.this$0).phrase("drop table", PostgresBaseDropGenerator.access$ifExists(this.this$0), PostgresBaseDropGenerator.access$currentScopeName(this.this$0, this.$table), PostgresBaseDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$table = postgresBaseTable;
                super(0);
            }
        }, 3, null);
    }

    private final void generateView(PostgresBaseView view) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseView $view;

            public final void invoke() {
                PostgresBaseDropGenerator.access$getBuilder$p(this.this$0).phrase("drop view", PostgresBaseDropGenerator.access$ifExists(this.this$0), PostgresBaseDropGenerator.access$currentScopeName(this.this$0, this.$view), PostgresBaseDropGenerator.access$restrictCascade(this.this$0));
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$view = postgresBaseView;
                super(0);
            }
        }, 3, null);
    }

    private final void generateDatabase(PostgresBaseDatabase db) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, db){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseDatabase $db;

            public final void invoke() {
                PostgresBaseDropGenerator.access$getBuilder$p(this.this$0).phrase("drop database", PostgresBaseDropGenerator.access$pgIfExists(this.this$0), PostgresBaseDropGenerator.access$getScr$p(this.this$0, this.$db.getName()));
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$db = postgresBaseDatabase;
                super(0);
            }
        }, 3, null);
    }

    private final void generateSchema(PostgresBaseSchema sc) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, sc){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseSchema $sc;

            public final void invoke() {
                PostgresBaseDropGenerator.access$getBuilder$p(this.this$0).phrase("drop schema", PostgresBaseDropGenerator.access$ifExists(this.this$0), PostgresBaseDropGenerator.access$getScr$p(this.this$0, this.$sc.getName()));
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$sc = postgresBaseSchema;
                super(0);
            }
        }, 3, null);
    }

    private final void generateFunction(PostgresBaseRoutine element) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, element){
            final /* synthetic */ PostgresBaseDropGenerator this$0;
            final /* synthetic */ PostgresBaseRoutine $element;

            public final void invoke() {
                CodeTextBuilder codeTextBuilder = PostgresBaseDropGenerator.access$getBuilder$p(this.this$0);
                CharSequence[] charSequenceArray = new CharSequence[4];
                charSequenceArray[0] = "drop function";
                charSequenceArray[1] = PostgresBaseDropGenerator.access$pgIfExists(this.this$0);
                StringBuilder stringBuilder = new StringBuilder().append("").append(PostgresBaseDropGenerator.access$currentScopeName(this.this$0, this.$element)).append('(');
                String string = this.$element.getArgumentsDefinition();
                if (string == null) {
                    string = "";
                }
                charSequenceArray[2] = stringBuilder.append(string).append(')').toString();
                charSequenceArray[3] = PostgresBaseDropGenerator.access$restrictCascade(this.this$0);
                codeTextBuilder.phrase(charSequenceArray);
            }
            {
                this.this$0 = postgresBaseDropGenerator;
                this.$element = postgresBaseRoutine;
                super(0);
            }
        }, 3, null);
    }

    private final String pgIfExists() {
        return this.isPg() ? this.ifExists() : null;
    }

    private final boolean isPg() {
        return Intrinsics.areEqual((Object)this.getContext().getModel().getRdbms(), (Object)Postgres.RDBMS);
    }

    public PostgresBaseDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        super(context, task);
    }

    static {
        Companion = new Companion(null);
        SUPPORTED = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.DATABASE, ObjectKind.SCHEMA, ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE, ObjectKind.KEY, ObjectKind.FOREIGN_KEY});
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(PostgresBaseDropGenerator $this) {
        return $this.getBuilder();
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(PostgresBaseDropGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }

    @Nullable
    public static final /* synthetic */ String access$pgIfExists(PostgresBaseDropGenerator $this) {
        return $this.pgIfExists();
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(PostgresBaseDropGenerator $this, @NotNull String $receiver) {
        return $this.getScr($receiver);
    }

    @Nullable
    public static final /* synthetic */ String access$restrictCascade(PostgresBaseDropGenerator $this) {
        return $this.restrictCascade();
    }

    @Nullable
    public static final /* synthetic */ String access$ifExists(PostgresBaseDropGenerator $this) {
        return $this.ifExists();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rR\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/postgres/PostgresBaseDropGenerator$Companion;", "", "()V", "SUPPORTED", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "getSUPPORTED", "()Ljava/util/Set;", "canDrop", "", "kind", "context", "", "database-scripting"})
    public static final class Companion {
        private final Set<ObjectKind> getSUPPORTED() {
            return SUPPORTED;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean canDrop(@NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.COLUMN)) {
                ObjectKind objectKind = (ObjectKind)CollectionsKt.firstOrNull(context);
                if (objectKind == null) {
                    objectKind = ObjectKind.TABLE;
                }
                if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) return true;
            }
            if (!this.getSUPPORTED().contains(kind)) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

