/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.plus;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.oracle.OracleLexer;
import com.intellij.sql.dialects.oracle.plus.OrapElementTypes;
import com.intellij.sql.dialects.oracle.plus.OrapOptionalKeywords;
import com.intellij.sql.dialects.oracle.plus.OrapReservedKeywords;
import com.intellij.sql.dialects.oracle.plus.OrapTokens;
import com.intellij.sql.dialects.oracle.plus.OrapTypes;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer._OrapLexer;
import java.util.regex.Pattern;

public class OrapLexer
extends OracleLexer {
    private static final Pattern SUBS_ID;
    private static final Pattern VERSION_PATTERN;
    private ExpectationState myExpectingFormat = null;
    private boolean myExpectingSubsVar;
    private boolean myExpectingVersion;
    private DefineState myDefineState = null;

    public OrapLexer() {
        super(OrapTokens.class, new _OrapLexer());
    }

    @Override
    protected void lookAhead(Lexer baseLexer) {
        if (!(this.remapRemark(baseLexer) || this.remapSlashSeparator(baseLexer) || this.remapParams(baseLexer) || this.remapBackslash(baseLexer) || this.remapDotSymbol(baseLexer) || this.remapVersion(baseLexer) || this.remapSubsVar(baseLexer) || this.remapFormat(baseLexer))) {
            super.lookAhead(baseLexer);
        }
        this.updateStates();
    }

    private boolean remapFormat(Lexer lexer) {
        if (this.myExpectingFormat == null) {
            return false;
        }
        IElementType type = lexer.getTokenType();
        if (type == SqlTokens.BAD_CHARACTER) {
            this.advanceAs(lexer, (IElementType)SqlTokens.SQL_IDENT);
            return true;
        }
        return false;
    }

    private static boolean isStartOfLine(Lexer lexer) {
        int start = lexer.getTokenStart();
        CharSequence buf = lexer.getBufferSequence();
        int prev = start > 0 ? (int)buf.charAt(start - 1) : 10;
        return prev == 10 || prev == 13;
    }

    private boolean remapRemark(Lexer lexer) {
        if (lexer.getTokenType() != SqlTokens.SQL_IDENT) {
            return false;
        }
        String text2 = lexer.getTokenText();
        if ("REM".equalsIgnoreCase(text2) || "REMARK".equalsIgnoreCase(text2)) {
            CharSequence buf = lexer.getBufferSequence();
            if (!OrapLexer.isStartOfLine(lexer)) {
                return false;
            }
            int idx = StringUtil.indexOfAny((CharSequence)buf, (String)"\n\r", (int)lexer.getTokenEnd(), (int)lexer.getBufferEnd());
            if (idx == -1) {
                idx = lexer.getBufferEnd();
            }
            this.addToken(idx, (IElementType)SqlTokens.ORAP_LINE_COMMENT);
            lexer.start(buf, idx, lexer.getBufferEnd(), lexer.getState());
            return true;
        }
        return false;
    }

    private boolean remapSlashSeparator(Lexer lexer) {
        IElementType type = lexer.getTokenType();
        if (type != SqlTokens.ORAP_DELIMITER_TOKEN) {
            return false;
        }
        LexerPosition position = lexer.getCurrentPosition();
        int num = 0;
        while (type == SqlTokens.ORAP_DELIMITER_TOKEN || type == SqlTokens.SQL_OP_DIV || type == SqlTokens.SQL_WHITE_SPACE) {
            lexer.advance();
            type = lexer.getTokenType();
            ++num;
        }
        if (num < 2) {
            lexer.restore(position);
            return false;
        }
        this.addToken(lexer.getTokenStart(), (IElementType)SqlTokens.ORAP_SLASH_DELIMITER_TOKEN);
        return true;
    }

    private boolean remapSubsVar(Lexer lexer) {
        if (this.myExpectingSubsVar) {
            IElementType firstType;
            int advances = 0;
            IElementType type = firstType = lexer.getTokenType();
            LexerPosition position = lexer.getCurrentPosition();
            while (!OrapElementTypes.WHITE_SPACE_TOKENS.contains(type) && SUBS_ID.matcher(lexer.getTokenText()).matches()) {
                type = lexer.getTokenType();
                lexer.advance();
                ++advances;
            }
            if (advances == 0) {
                return false;
            }
            if (advances == 1 && firstType != SqlTokens.BAD_CHARACTER) {
                lexer.restore(position);
                return false;
            }
            this.addToken(lexer.getTokenStart(), (IElementType)SqlTokens.SQL_IDENT);
            return true;
        }
        return false;
    }

    private void updateStates() {
        IElementType current = this.getTokenType();
        if (!OrapElementTypes.WHITE_SPACE_TOKENS.contains(current)) {
            this.myExpectingFormat = this.myExpectingFormat == null ? (current == OrapTypes.ORAP_FORMAT || current == OrapTypes.ORAP_FOR || current == OrapTypes.ORAP_NUMFORMAT || current == OrapTypes.ORAP_NUMF ? ExpectationState.EXPECTING : null) : (current != SqlTokens.ORAP_DELIMITER_TOKEN && current != SqlTokens.ORAP_SLASH_DELIMITER_TOKEN && current != SqlTokens.SQL_WHITE_SPACE && current != SqlTokens.SQL_OP_BITWISE_AND && current != SqlTokens.SQL_STRING_TOKEN && current != SqlTokens.SQL_IDENT_DELIMITED ? ExpectationState.PROCESSING : null);
            boolean bl = this.myExpectingVersion = current == OrapTypes.ORAP_SQLPLUSCOMPATIBILITY || current == OrapTypes.ORAP_SQLPLUSCOMPAT;
            if ((current == OrapTypes.ORAP_DEFINE || current == OrapTypes.ORAP_DEF) && this.myDefineState == null) {
                this.myDefineState = DefineState.DEF_VAR;
                this.myExpectingSubsVar = true;
            } else if (this.myDefineState == DefineState.DEF_VAR) {
                this.myDefineState = DefineState.DEF_EQ;
                this.myExpectingSubsVar = false;
            } else if (current == SqlTokens.SQL_OP_EQ && this.myDefineState == DefineState.DEF_EQ) {
                this.myDefineState = DefineState.DEF_VAL;
                this.myExpectingSubsVar = true;
            } else {
                this.myDefineState = null;
                this.myExpectingSubsVar = current == SqlTokens.SQL_OP_BITWISE_AND;
            }
        } else if (this.myExpectingFormat == ExpectationState.PROCESSING) {
            this.myExpectingFormat = null;
        }
    }

    private boolean remapBackslash(Lexer lexer) {
        if (lexer.getTokenType() == SqlTokens.BAD_CHARACTER && StringUtil.equals((CharSequence)lexer.getTokenText(), (CharSequence)"\\")) {
            this.advanceAs(lexer, (IElementType)SqlTokens.SQL_IDENT);
            return true;
        }
        return false;
    }

    private boolean remapDotSymbol(Lexer lexer) {
        if (lexer.getTokenType() == SqlTokens.BAD_CHARACTER && lexer.getTokenText().equals(".")) {
            this.advanceAs(lexer, (IElementType)SqlTokens.SQL_INTEGER_TOKEN);
            return true;
        }
        return false;
    }

    private boolean remapVersion(Lexer lexer) {
        if (!this.myExpectingVersion) {
            return false;
        }
        IElementType type = lexer.getTokenType();
        if ((type == SqlTokens.BAD_CHARACTER || type == SqlTokens.SQL_INTEGER_TOKEN || type == SqlTokens.SQL_FLOAT_TOKEN) && VERSION_PATTERN.matcher(lexer.getTokenText()).matches()) {
            this.advanceAs(lexer, (IElementType)OrapTokens.ORAP_VERSION_TOKEN);
            return true;
        }
        return false;
    }

    private boolean remapParams(Lexer lexer) {
        LexerPosition position = lexer.getCurrentPosition();
        IElementType type = lexer.getTokenType();
        if (type == SqlTokens.SQL_OP_BITWISE_AND) {
            lexer.advance();
            if (lexer.getTokenType() == SqlTokens.SQL_INTEGER_TOKEN) {
                this.advanceAs(lexer, (IElementType)SqlTokens.SQL_IDENT);
                return true;
            }
        }
        lexer.restore(position);
        return false;
    }

    static {
        OrapLexer.initTokensAndFunctions(OrapElementTypes.SQL_PLUS_SQL_FILE, OrapTokens.class, OrapReservedKeywords.class, OrapOptionalKeywords.class);
        SUBS_ID = Pattern.compile("[a-z0-9_]+", 2);
        VERSION_PATTERN = Pattern.compile("\\d+(\\.\\d+){1,2}");
    }

    private static enum ExpectationState {
        EXPECTING,
        PROCESSING;

    }

    private static enum DefineState {
        DEF_VAR,
        DEF_EQ,
        DEF_VAL;

    }
}

