/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostgresDialectBase
extends SqlLanguageDialectEx {
    public PostgresDialectBase(@NotNull String id) {
        if (id == null) {
            PostgresDialectBase.$$$reportNull$$$0(0);
        }
        super(id);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "dpn", "double precision", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "bigint", "bigint", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "numeric", "numeric", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "dp", "double precision", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "bytea", "bytea", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "name", "name", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "oid", "oid", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "gobject", "geometric object", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "circle", "circle", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "path", "path", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "box", "box", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "polygon", "polygon", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "lseg", "lseg", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "point", "point", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "line", "line", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "cidr", "cidr", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "inet", "inet", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "macaddr", "macaddr", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "tsvector", "tsvector", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "tsquery", "tsquery", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "trigger", "trigger", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "range", "range", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "txid_snapshot", "txid_snapshot", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "void", "void", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "record", "record", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "enum", "enum", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "xml", "xml", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "float4", "float4", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "int2vector", "int2vector", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "json", "json", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "jsonb", "jsonb", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "regclass", "regclass", (SqlLanguageDialectEx)this);
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        SqlFunctionDefinition definition;
        SqlReferenceExpression ref;
        if (element == null) {
            PostgresDialectBase.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            PostgresDialectBase.$$$reportNull$$$0(2);
        }
        SqlExpression qualifier = (ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)element, SqlReferenceExpression.class)) == null ? null : ref.getQualifierExpression();
        boolean isFunctionCall = element.getParent() instanceof SqlFunctionCallExpression;
        SqlFunctionDefinition sqlFunctionDefinition = definition = name == null || qualifier == null || isFunctionCall ? null : this.getSupportedFunctions().get(name);
        if (definition != null) {
            for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
                SqlType type;
                if (prototype.getParams().length != 1 || processor.executeTarget((DasObject)definition, (PsiElement)ref, type = SqlFunctionCallExpressionImpl.createBuiltinFunctionReturnType(prototype, ref, (PsiElement)qualifier, (PsiElement)ref), null, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            PostgresDialectBase.$$$reportNull$$$0(3);
        }
        switch (cat) {
            case INTEGER: {
                return "integer";
            }
            case REAL: {
                return "numeric";
            }
            case STRING: {
                return "text";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "date";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "bytea";
            }
            case ARRAY: {
                return "anyarray";
            }
            case TABLE: {
                return "anyarray";
            }
            case RECORD: {
                return "record";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            PostgresDialectBase.$$$reportNull$$$0(4);
        }
        if ((name = super.getNormalizedTypeName(name)).endsWith("[]")) {
            String string = this.getNormalizedTypeName(name.substring(0, name.length() - 2)) + "[]";
            if (string == null) {
                PostgresDialectBase.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (name.equals("int8")) {
            if ("bigint" == null) {
                PostgresDialectBase.$$$reportNull$$$0(6);
            }
            return "bigint";
        }
        if (name.equals("serial8")) {
            if ("bigserial" == null) {
                PostgresDialectBase.$$$reportNull$$$0(7);
            }
            return "bigserial";
        }
        if (name.equals("bool")) {
            if ("boolean" == null) {
                PostgresDialectBase.$$$reportNull$$$0(8);
            }
            return "boolean";
        }
        if (name.equals("character varying")) {
            if ("varchar" == null) {
                PostgresDialectBase.$$$reportNull$$$0(9);
            }
            return "varchar";
        }
        if (name.equals("float8")) {
            if ("double precision" == null) {
                PostgresDialectBase.$$$reportNull$$$0(10);
            }
            return "double precision";
        }
        if (name.equals("int4")) {
            if ("integer" == null) {
                PostgresDialectBase.$$$reportNull$$$0(11);
            }
            return "integer";
        }
        if (name.equals("int")) {
            if ("integer" == null) {
                PostgresDialectBase.$$$reportNull$$$0(12);
            }
            return "integer";
        }
        if (name.equals("decimal")) {
            if ("numeric" == null) {
                PostgresDialectBase.$$$reportNull$$$0(13);
            }
            return "numeric";
        }
        if (name.equals("float4")) {
            if ("real" == null) {
                PostgresDialectBase.$$$reportNull$$$0(14);
            }
            return "real";
        }
        if (name.equals("int2")) {
            if ("smallint" == null) {
                PostgresDialectBase.$$$reportNull$$$0(15);
            }
            return "smallint";
        }
        if (name.equals("serial4")) {
            if ("serial" == null) {
                PostgresDialectBase.$$$reportNull$$$0(16);
            }
            return "serial";
        }
        if (name.equals("serial2")) {
            if ("smallserial" == null) {
                PostgresDialectBase.$$$reportNull$$$0(17);
            }
            return "smallserial";
        }
        String string = name;
        if (string == null) {
            PostgresDialectBase.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            PostgresDialectBase.$$$reportNull$$$0(19);
        }
        if (typeName.equals("record")) {
            SqlType.Category category = SqlType.Category.RECORD;
            if (category == null) {
                PostgresDialectBase.$$$reportNull$$$0(20);
            }
            return category;
        }
        if (typeName.endsWith("[]")) {
            SqlType.Category category = SqlType.Category.ARRAY;
            if (category == null) {
                PostgresDialectBase.$$$reportNull$$$0(21);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            PostgresDialectBase.$$$reportNull$$$0(22);
        }
        return category;
    }

    @Override
    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref) {
        if (processor == null) {
            PostgresDialectBase.$$$reportNull$$$0(23);
        }
        if (state == null) {
            PostgresDialectBase.$$$reportNull$$$0(24);
        }
        if (ref == null) {
            PostgresDialectBase.$$$reportNull$$$0(25);
        }
        PsiElement place = ref.getElement();
        if (processor.isExpected(ObjectKind.ROUTINE)) {
            List exprs;
            SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)place.getParent(), SqlFunctionCallExpression.class);
            SqlExpressionList params2 = callExpression == null ? null : callExpression.getParameterList();
            List list = exprs = params2 == null ? Collections.emptyList() : params2.getExpressionList();
            if (exprs.size() == 1) {
                SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)((SqlExpression)exprs.get(0)).getSqlType(), SqlTableType.class);
                if (type == null) {
                    return true;
                }
                Set<ObjectKind> expected = processor.getInitialExpectedTypes();
                processor.handleEvent(SqlScopeProcessor.EXPECTED_TYPE, Collections.singleton(ObjectKind.COLUMN));
                boolean res = SqlImplUtil.processDeclarationsInType(type, (PsiScopeProcessor)processor, state, place);
                processor.handleEvent(SqlScopeProcessor.EXPECTED_TYPE, expected);
                if (!res) {
                    return false;
                }
            }
        }
        return super.processUnqualifiedResolve(processor, state, ref);
    }

    @Override
    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref, @NotNull SqlExpression qualifier) {
        if (processor == null) {
            PostgresDialectBase.$$$reportNull$$$0(26);
        }
        if (state == null) {
            PostgresDialectBase.$$$reportNull$$$0(27);
        }
        if (ref == null) {
            PostgresDialectBase.$$$reportNull$$$0(28);
        }
        if (qualifier == null) {
            PostgresDialectBase.$$$reportNull$$$0(29);
        }
        if (!processor.isExpected(ObjectKind.COLUMN)) {
            return true;
        }
        if (processor.referenceName == null && qualifier.getSqlType() == SqlType.UNKNOWN) {
            return true;
        }
        SqlScopeProcessor filteringProcessor = PostgresDialectBase.filterSingleArgumentRoutines(processor);
        SqlReferenceImpl refImpl = (SqlReferenceImpl)ObjectUtils.tryCast((Object)ref, SqlReferenceImpl.class);
        if (refImpl != null && !refImpl.processUnqualifiedResolveVariants(filteringProcessor, ResolveState.initial())) {
            return false;
        }
        return super.processQualifiedResolve(processor, state, ref, qualifier);
    }

    @NotNull
    private static SqlScopeProcessor filterSingleArgumentRoutines(final SqlScopeProcessor sqlProcessor) {
        SqlScopeProcessor processor = new SqlScopeProcessor(sqlProcessor.referenceName, sqlProcessor.dialect, sqlProcessor.dataSources, sqlProcessor.place){

            @Override
            public boolean isResultEmpty() {
                return sqlProcessor.isResultEmpty();
            }

            @Override
            public boolean executeTarget(@Nullable DasObject target2, @NotNull PsiElement element, @Nullable SqlType sqlType, @Nullable Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !SqlFunctionsUtil.isSingleArgumentRoutine(target2) || sqlProcessor.executeTarget(target2, element, sqlType, forcedCaseSens, state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/dialects/postgres/PostgresDialectBase$1";
                objectArray[2] = "executeTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor.handleEvent(SqlScopeProcessor.EXPECTED_TYPE, Collections.singleton(ObjectKind.ROUTINE));
        SqlScopeProcessor sqlScopeProcessor = processor;
        if (sqlScopeProcessor == null) {
            PostgresDialectBase.$$$reportNull$$$0(30);
        }
        return sqlScopeProcessor;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type == ObjectKind.COLUMN) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return super.getParentDbTypes(result2, type);
    }

    public boolean isResolveTargetAccepted(@Nullable PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            PostgresDialectBase.$$$reportNull$$$0(31);
        }
        if (strict) {
            return false;
        }
        if (expectedTypes.contains(ObjectKind.COLUMN) && type == ObjectKind.ROUTINE) {
            if (place instanceof SqlReferenceExpression) {
                return ((SqlReferenceExpression)place).getQualifierExpression() != null;
            }
            return true;
        }
        return super.isResolveTargetAccepted(element, type, expectedTypes, place, strict, isCompletion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/PostgresDialectBase";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/PostgresDialectBase";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSingleArgumentRoutines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 30: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

