/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlTableElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlTableStub
extends SqlNamedElementStub<SqlTableDefinition> {
    private final StringRef myExpressionText;
    private final StringRef[][] myAncestorTextRefs;
    private SqlExpression myExpression;
    private List<SqlReferenceExpression>[] myAncestorRefs;

    protected SqlTableStub(StubElement parent, @NotNull SqlTableElementType elementType, StringRef name, StringRef expressionText, StringRef[][] ancestorRefs) {
        if (elementType == null) {
            SqlTableStub.$$$reportNull$$$0(0);
        }
        super(parent, elementType, name);
        this.myExpressionText = expressionText;
        this.myAncestorTextRefs = ancestorRefs;
        this.myAncestorRefs = ancestorRefs == null ? null : new List[ancestorRefs.length];
    }

    public String getExpressionText() {
        return this.myExpressionText == null ? null : this.myExpressionText.getString();
    }

    public StringRef[][] getAncestorTextRefs() {
        return this.myAncestorTextRefs;
    }

    public SqlExpression getQueryExpression() {
        String text2;
        if (this.myExpression == null && StringUtil.isNotEmpty((String)(text2 = this.getExpressionText()))) {
            SqlTableDefinition psi = (SqlTableDefinition)this.getPsi();
            this.myExpression = SqlPsiElementFactory.createQueryExpressionFromText(text2, SqlImplUtil.getSqlDialectSafe((PsiElement)psi), (PsiElement)psi);
        }
        return this.myExpression;
    }

    @NotNull
    public List<SqlReferenceExpression> getAncestorRefs(int idx) {
        if (this.myAncestorRefs == null || idx < this.myAncestorRefs.length || idx >= this.myAncestorRefs.length) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                SqlTableStub.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (this.myAncestorRefs[idx] == null) {
            StringRef[] refs = this.myAncestorTextRefs[idx];
            SqlTableDefinition psi = (SqlTableDefinition)this.getPsi();
            this.myAncestorRefs[idx] = ContainerUtil.newArrayListWithCapacity((int)refs.length);
            for (StringRef ref : refs) {
                this.myAncestorRefs[idx].add(SqlPsiElementFactory.createReferenceFromText(ref.getString(), SqlImplUtil.getSqlDialectSafe((PsiElement)psi), SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (PsiElement)psi));
            }
        }
        List<SqlReferenceExpression> list = this.myAncestorRefs[idx];
        if (list == null) {
            SqlTableStub.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/SqlTableStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/SqlTableStub";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

