/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.admin;

import com.intellij.javaee.deployment.DeploymentMethod;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.admin.JavaeeAgentAdminServerBase;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.jboss.config.Jboss7DomainHostConfig;
import com.intellij.javaee.oss.jboss.config.Jboss7DomainServersConfig;
import com.intellij.javaee.oss.jboss.server.JBossDeploymentProvider;
import com.intellij.javaee.oss.jboss.server.JBossLocalModel;
import com.intellij.javaee.oss.jboss.server.JBossRemoteModel;
import com.intellij.javaee.oss.jboss.server.JBossServerModel;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;

public class JBoss7AdminServerBase
extends JavaeeAgentAdminServerBase {
    private static final Logger LOG = Logger.getInstance(JBoss7AdminServerBase.class);
    private static final String SPECIFICS_MODULE_NAME = "jboss-srv7";
    private static final String SPECIFICS_JAR_PATH = "specifics/jboss7-specifics.jar";
    private static final String TAG_CHILDREN_DEPLOYMENT = "deployment";
    private static final String TAG_CHILD_DEPLOYMENTS = "deployments";
    private static final String ATTRIBUTE_NAME = "name";
    private final JBossServerModel myServerModel;
    private final boolean myLocal;

    public JBoss7AdminServerBase(JBossServerModel serverModel, AgentProxyFactory agentProxyFactory, List<File> libraries, String agentClassName) throws Exception {
        super(agentProxyFactory, libraries, Collections.emptyList(), SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, agentClassName);
        this.myLocal = serverModel instanceof JBossLocalModel;
        this.myServerModel = serverModel;
    }

    protected void setupInitParameters(ParametersMap initParameters) {
        initParameters.put((Object)"is.local", (Object)Boolean.toString(this.myLocal));
        initParameters.put((Object)"is.domain", (Object)Boolean.toString(this.myServerModel.isDomain()));
        initParameters.put((Object)"server.group", (Object)this.myServerModel.getServerGroup());
        if (this.myLocal && this.myServerModel.isDomain()) {
            List<String> servers = Jboss7DomainServersConfig.getDomainServers(this.myServerModel);
            initParameters.put((Object)"server.names", (Object)StringUtil.join(servers, (String)";"));
            initParameters.put((Object)"domain.host", (Object)Jboss7DomainHostConfig.getDomainHost(this.myServerModel));
        }
    }

    protected void setupDeployParameters(DeploymentModel deployment, File source, ParametersMap deployParameters) throws Exception {
        String sourcePath = source.getAbsolutePath();
        DeploymentMethod deploymentMethod = deployment.getDeploymentMethod();
        if (!this.myLocal) {
            JBossRemoteModel remoteServerModel = (JBossRemoteModel)this.myServerModel;
            if (deploymentMethod == JBossDeploymentProvider.STAGING) {
                sourcePath = remoteServerModel.prepareDeployment(sourcePath, false);
            }
        }
        deployParameters.put((Object)"source.path", (Object)sourcePath);
        deployParameters.put((Object)"native.deployment.method", (Object)Boolean.toString(!source.isDirectory() && deployment.getDeploymentMethod() == JBossDeploymentProvider.NATIVE));
        Artifact artifact = deployment.getArtifact();
        deployParameters.put((Object)"runtime.name.for.war", (Object)Boolean.toString(!FileUtilRt.extensionEquals((String)source.getName(), (String)"war") && artifact != null && artifact.getArtifactType() == ExplodedWarArtifactType.getInstance()));
    }

    @NotNull
    protected String getDeploymentName(DeploymentModel deployment, File source) throws Exception {
        String string = JBoss7AdminServerBase.doGetDeploymentName(source);
        if (string == null) {
            JBoss7AdminServerBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String doGetDeploymentName(File source) {
        return source.getName();
    }

    public void cleanDeployments(List<DeploymentModel> deploymentModels) {
        File configFile = this.myServerModel.isDomain() ? JBossVersion7Handler.getDomainConfigFile(this.myServerModel) : JBossVersion7Handler.getConfigFile(this.myServerModel);
        try {
            Namespace namespace;
            if (deploymentModels.isEmpty()) {
                return;
            }
            Document document = JDOMUtil.loadDocument((File)configFile);
            Element rootElement = document.getRootElement();
            Element deployments = rootElement.getChild(TAG_CHILD_DEPLOYMENTS, namespace = rootElement.getNamespace());
            if (deployments == null) {
                return;
            }
            List listDeployment = deployments.getChildren(TAG_CHILDREN_DEPLOYMENT, namespace);
            block3: for (DeploymentModel deploymentModel : deploymentModels) {
                File deploymentFile = deploymentModel.getDeploymentSource().getFile();
                if (deploymentFile == null) continue;
                String deploymentName = JBoss7AdminServerBase.doGetDeploymentName(deploymentFile);
                for (Element deployment : new ArrayList(listDeployment)) {
                    if (!deploymentName.equals(deployment.getAttributeValue(ATTRIBUTE_NAME))) continue;
                    deployment.detach();
                    continue block3;
                }
            }
            if (listDeployment.size() == 0) {
                deployments.detach();
            }
            JDOMUtil.writeDocument((Document)document, (String)configFile.getPath(), (String)"\n");
        }
        catch (JDOMException e) {
            LOG.info((Throwable)e);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/admin/JBoss7AdminServerBase", "getDeploymentName"));
    }
}

