/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor.reference;

import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.JndiEnvironmentRefsGroup;
import com.intellij.javaee.model.xml.MessageDestinationRef;
import com.intellij.javaee.oss.editor.JavaeeSectionInfo;
import com.intellij.javaee.oss.editor.JavaeeSectionInfoEditable;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.editor.reference.JBossReferenceSection;
import com.intellij.javaee.oss.jboss.editor.reference.JBossReferenceUtil;
import com.intellij.javaee.oss.jboss.model.JBossMessageDestinationRef;
import com.intellij.javaee.oss.jboss.model.JBossReferenceHolder;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class JBossMessageDestinationRefSection
extends JBossReferenceSection<MessageDestinationRef> {
    private final JndiEnvironmentRefsGroup group;
    private final JBossReferenceHolder holder;

    JBossMessageDestinationRefSection(JndiEnvironmentRefsGroup group, JBossReferenceHolder holder) {
        this.group = group;
        this.holder = holder;
    }

    public List<MessageDestinationRef> getValues() {
        return this.group == null ? Collections.emptyList() : this.group.getMessageDestinationRefs();
    }

    @Override
    JavaeeSectionInfo<MessageDestinationRef> createFirstColumn() {
        return new JavaeeSectionInfo<MessageDestinationRef>(JBossBundle.getText("JBossReferenceEditor.message.destination", new Object[0])){

            public String valueOf(MessageDestinationRef source) {
                return (String)source.getMessageDestinationRefName().getValue();
            }
        };
    }

    @Override
    JavaeeSectionInfo<MessageDestinationRef> createSecondColumn() {
        return new JavaeeSectionInfoEditable<MessageDestinationRef>(JBossBundle.getText("JBossReferenceEditor.jndi.name", new Object[0]), (JavaeeDomModelElement)this.holder){

            @Nullable
            public String valueOf(MessageDestinationRef source) {
                JBossMessageDestinationRef target = JBossReferenceUtil.findMessageDestinationRef(JBossMessageDestinationRefSection.this.holder, source);
                return target == null ? null : (String)target.getJndiName().getValue();
            }

            protected void write(MessageDestinationRef item, String value) {
                JBossMessageDestinationRef target = JBossReferenceUtil.findMessageDestinationRef(JBossMessageDestinationRefSection.this.holder, item);
                if (!StringUtil.isEmpty((String)value)) {
                    if (target == null) {
                        target = JBossMessageDestinationRefSection.this.holder.addMessageDestinationRef();
                        target.getMessageDestinationRefName().setValue((Object)item);
                    }
                    target.getJndiName().setValue((Object)value);
                } else if (target != null) {
                    target.undefine();
                }
            }
        };
    }
}

