/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.model.common;

import com.intellij.jam.model.common.CommonDomModelElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.Nullable;

public abstract class BaseImpl
implements CommonDomModelElement {
    @Override
    public PsiManager getPsiManager() {
        return PsiManager.getInstance(this.getManager().getProject());
    }

    @Override
    public PsiElement getIdentifyingPsiElement() {
        DomTarget target = DomTarget.getTarget(this);
        return target == null ? this.getXmlElement() : PomService.convertToPsi(target);
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return DomUtil.getFile(this);
    }

    @Nullable
    protected final PsiClass findPsiClass(String className) {
        if (className == null) {
            return null;
        }
        Module module = this.getModule();
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module) : GlobalSearchScope.projectScope(this.getManager().getProject());
        return JavaPsiFacade.getInstance(this.getManager().getProject()).findClass(className, scope);
    }

    @Override
    @Nullable
    public Module getModule() {
        if (!this.isValid()) {
            return null;
        }
        if (this.getManager().isMockElement(this)) {
            return (Module)DomUtil.getFile(this).getUserData(DomManager.MOCK_ELEMENT_MODULE);
        }
        DomElement root = DomUtil.getRoot(this);
        if (this.equals(root)) {
            PsiElement element = this.getIdentifyingPsiElement();
            return element == null ? null : ModuleUtil.findModuleForPsiElement(element);
        }
        return root.getModule();
    }
}

