/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.versionBrowser;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SyncDateFormat;
import com.intellij.util.xmlb.annotations.Transient;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeBrowserSettings
implements JDOMExternalizable {
    public static final String HEAD = "HEAD";
    public static final SyncDateFormat DATE_FORMAT = new SyncDateFormat(DateFormat.getDateTimeInstance(1, 1));
    private static final Logger LOG = Logger.getInstance(ChangeBrowserSettings.class);
    public boolean USE_DATE_BEFORE_FILTER = false;
    public boolean USE_DATE_AFTER_FILTER = false;
    public boolean USE_CHANGE_BEFORE_FILTER = false;
    public boolean USE_CHANGE_AFTER_FILTER = false;
    public String DATE_BEFORE = "";
    public String DATE_AFTER = "";
    public String CHANGE_BEFORE = "";
    public String CHANGE_AFTER = "";
    public boolean USE_USER_FILTER = false;
    public String USER = "";
    public boolean STOP_ON_COPY = false;
    @Transient
    public boolean STRICTLY_AFTER = false;

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    @Nullable
    private static Date parseDate(@Nullable String dateValue) {
        try {
            return !StringUtil.isEmpty((String)dateValue) ? DATE_FORMAT.parse(dateValue) : null;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Long parseLong(@Nullable String longValue) {
        try {
            return !StringUtil.isEmpty((String)longValue) ? Long.valueOf(Long.parseLong(longValue)) : null;
        }
        catch (NumberFormatException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public void setDateBefore(@Nullable Date value) {
        this.DATE_BEFORE = value == null ? null : DATE_FORMAT.format(value);
    }

    @Nullable
    public Date getDateBefore() {
        return ChangeBrowserSettings.parseDate(this.DATE_BEFORE);
    }

    @Nullable
    public Date getDateAfter() {
        return ChangeBrowserSettings.parseDate(this.DATE_AFTER);
    }

    @Nullable
    public Long getChangeBeforeFilter() {
        return this.USE_CHANGE_BEFORE_FILTER && !HEAD.equals(this.CHANGE_BEFORE) ? ChangeBrowserSettings.parseLong(this.CHANGE_BEFORE) : null;
    }

    @Nullable
    public Date getDateBeforeFilter() {
        return this.USE_DATE_BEFORE_FILTER ? ChangeBrowserSettings.parseDate(this.DATE_BEFORE) : null;
    }

    @Nullable
    public Long getChangeAfterFilter() {
        return this.USE_CHANGE_AFTER_FILTER ? ChangeBrowserSettings.parseLong(this.CHANGE_AFTER) : null;
    }

    @Nullable
    public Date getDateAfterFilter() {
        return this.USE_DATE_AFTER_FILTER ? ChangeBrowserSettings.parseDate(this.DATE_AFTER) : null;
    }

    public void setDateAfter(@Nullable Date value) {
        this.DATE_AFTER = value == null ? null : DATE_FORMAT.format(value);
    }

    @NotNull
    protected List<Filter> createFilters() {
        List list = ContainerUtil.packNullables((Object[])new Filter[]{ChangeBrowserSettings.createDateFilter(this.getDateBeforeFilter(), true), ChangeBrowserSettings.createDateFilter(this.getDateAfterFilter(), false), ChangeBrowserSettings.createChangeFilter(this.getChangeBeforeFilter(), true), ChangeBrowserSettings.createChangeFilter(this.getChangeAfterFilter(), false), this.USE_USER_FILTER ? changeList -> Comparing.equal((String)changeList.getCommitterName(), (String)this.USER, (boolean)false) : null});
        if (list == null) {
            ChangeBrowserSettings.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    private static Filter createDateFilter(@Nullable Date date, boolean before) {
        return date == null ? null : changeList -> {
            Date commitDate = changeList.getCommitDate();
            return commitDate != null && (before ? commitDate.before(date) : commitDate.after(date));
        };
    }

    @Nullable
    private static Filter createChangeFilter(@Nullable Long number, boolean before) {
        return number == null ? null : changeList -> before ? changeList.getNumber() <= number : changeList.getNumber() >= number;
    }

    @NotNull
    public Filter createFilter() {
        List<Filter> filters = this.createFilters();
        Filter filter = changeList -> filters.stream().allMatch(filter -> filter.accepts(changeList));
        if (filter == null) {
            ChangeBrowserSettings.$$$reportNull$$$0(1);
        }
        return filter;
    }

    public void filterChanges(@NotNull List<? extends CommittedChangeList> changeLists) {
        if (changeLists == null) {
            ChangeBrowserSettings.$$$reportNull$$$0(2);
        }
        Filter filter = this.createFilter();
        ContainerUtil.retainAll(changeLists, filter::accepts);
    }

    @Nullable
    public String getUserFilter() {
        return this.USE_USER_FILTER ? this.USER : null;
    }

    public boolean isAnyFilterSpecified() {
        return this.USE_CHANGE_AFTER_FILTER || this.USE_CHANGE_BEFORE_FILTER || this.USE_DATE_AFTER_FILTER || this.USE_DATE_BEFORE_FILTER || this.isNonDateFilterSpecified();
    }

    public boolean isNonDateFilterSpecified() {
        return this.USE_USER_FILTER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/versionBrowser/ChangeBrowserSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/versionBrowser/ChangeBrowserSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filterChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Filter {
        public boolean accepts(CommittedChangeList var1);
    }
}

