/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class RepositoryLibraryProperties
extends LibraryProperties<RepositoryLibraryProperties> {
    private JpsMavenRepositoryLibraryDescriptor myDescriptor;

    public RepositoryLibraryProperties() {
    }

    public RepositoryLibraryProperties(String mavenId, boolean includeTransitiveDependencies) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(mavenId, includeTransitiveDependencies);
    }

    public RepositoryLibraryProperties(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        if (groupId == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(1);
        }
        if (version == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(2);
        }
        this(groupId, artifactId, version, true);
    }

    public RepositoryLibraryProperties(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, boolean includeTransitiveDependencies) {
        if (groupId == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(3);
        }
        if (artifactId == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(4);
        }
        if (version == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(5);
        }
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(groupId, artifactId, version);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RepositoryLibraryProperties && Comparing.equal((Object)this.myDescriptor, (Object)((RepositoryLibraryProperties)obj).myDescriptor);
    }

    @Override
    public int hashCode() {
        return Comparing.hashcode((Object)this.getMavenId());
    }

    @Override
    public RepositoryLibraryProperties getState() {
        return this;
    }

    @Override
    public void loadState(RepositoryLibraryProperties state) {
        this.myDescriptor = state.myDescriptor;
    }

    @Attribute(value="maven-id")
    public String getMavenId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getMavenId);
    }

    public void setMavenId(String mavenId) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(mavenId, this.isIncludeTransitiveDependencies());
    }

    @Attribute(value="include-transitive-deps")
    public boolean isIncludeTransitiveDependencies() {
        return this.myDescriptor == null || this.myDescriptor.isIncludeTransitiveDependencies();
    }

    public void setIncludeTransitiveDependencies(boolean value) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getMavenId(), value);
    }

    public String getGroupId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getGroupId);
    }

    public String getArtifactId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getArtifactId);
    }

    public String getVersion() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getVersion);
    }

    public void changeVersion(String version) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getGroupId(), this.getArtifactId(), version, this.myDescriptor.isIncludeTransitiveDependencies());
    }

    private String call(Function<JpsMavenRepositoryLibraryDescriptor, String> method) {
        JpsMavenRepositoryLibraryDescriptor descriptor = this.myDescriptor;
        return descriptor != null ? method.apply(descriptor) : null;
    }

    @NotNull
    public JpsMavenRepositoryLibraryDescriptor getRepositoryLibraryDescriptor() {
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = this.myDescriptor != null ? this.myDescriptor : new JpsMavenRepositoryLibraryDescriptor(null, true);
        if (jpsMavenRepositoryLibraryDescriptor == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(6);
        }
        return jpsMavenRepositoryLibraryDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryLibraryDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

