/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldAccessor<E, T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.FieldAccessor");
    private Ref<Field> myFieldRef;
    private final Class<E> myClass;
    private final String myName;

    public FieldAccessor(@NotNull Class<E> cls, @NotNull String name) {
        if (cls == null) {
            FieldAccessor.$$$reportNull$$$0(0);
        }
        if (name == null) {
            FieldAccessor.$$$reportNull$$$0(1);
        }
        this.myClass = cls;
        this.myName = name;
    }

    public boolean isAvailable() {
        if (this.myFieldRef == null) {
            try {
                this.myFieldRef = new Ref();
                this.myFieldRef.set(this.myClass.getDeclaredField(this.myName));
                this.myFieldRef.get().setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                LOG.warn("Field not found: " + this.myClass.getName() + "." + this.myName);
            }
        }
        return this.myFieldRef.get() != null;
    }

    public T get(@Nullable E object) {
        if (!this.isAvailable() || object == null) {
            return null;
        }
        try {
            Object value = this.myFieldRef.get().get(object);
            return (T)value;
        }
        catch (IllegalAccessException e) {
            LOG.warn("Field not accessible: " + this.myClass.getName() + "." + this.myName);
            return null;
        }
    }

    public void set(@Nullable E object, @Nullable T value) {
        if (!this.isAvailable() || object == null) {
            return;
        }
        try {
            this.myFieldRef.get().set(object, value);
        }
        catch (IllegalAccessException e) {
            LOG.warn("Field not accessible: " + this.myClass.getName() + "." + this.myName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "cls";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/FieldAccessor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

