/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml.schema;

import com.intellij.ProjectTopics;
import com.intellij.javascript.flex.mxml.schema.CodeContext;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeContextHolder
extends AbstractProjectComponent {
    private final Set<Module> myModulesWithSdkComponentsHandled = new HashSet<Module>();
    private final Map<String, Map<Module, CodeContext>> myStandardContexts = new HashMap<String, Map<Module, CodeContext>>();
    private final Map<String, Map<Module, CodeContext>> myNSToCodeContextMap = new THashMap();
    static final CodeContext EMPTY = new CodeContext(null, null);

    public CodeContextHolder(Project project) {
        super(project);
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void rootsChanged(ModuleRootEvent event) {
                CodeContextHolder codeContextHolder = CodeContextHolder.this;
                synchronized (codeContextHolder) {
                    CodeContextHolder.this.myNSToCodeContextMap.clear();
                    CodeContextHolder.this.myStandardContexts.clear();
                    CodeContextHolder.this.myModulesWithSdkComponentsHandled.clear();
                }
            }
        });
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("CodeContextHolder" == null) {
            CodeContextHolder.$$$reportNull$$$0(0);
        }
        return "CodeContextHolder";
    }

    @Nullable
    public synchronized CodeContext getCodeContext(@NotNull String namespace, @NotNull Module module) {
        Map<Module, CodeContext> map;
        if (namespace == null) {
            CodeContextHolder.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CodeContextHolder.$$$reportNull$$$0(2);
        }
        if ((map = this.myNSToCodeContextMap.get(namespace)) != null) {
            return map.get(module);
        }
        return null;
    }

    public synchronized void putCodeContext(@NotNull String namespace, @NotNull Module module, @NotNull CodeContext codeContext) {
        THashMap map;
        if (namespace == null) {
            CodeContextHolder.$$$reportNull$$$0(3);
        }
        if (module == null) {
            CodeContextHolder.$$$reportNull$$$0(4);
        }
        if (codeContext == null) {
            CodeContextHolder.$$$reportNull$$$0(5);
        }
        if ((map = this.myNSToCodeContextMap.get(namespace)) == null) {
            map = new THashMap();
            this.myNSToCodeContextMap.put(namespace, (Map<Module, CodeContext>)map);
        }
        map.put(module, codeContext);
    }

    public synchronized void clearCodeContext(@NotNull String namespace, @NotNull Module module) {
        Map<Module, CodeContext> map;
        if (namespace == null) {
            CodeContextHolder.$$$reportNull$$$0(6);
        }
        if (module == null) {
            CodeContextHolder.$$$reportNull$$$0(7);
        }
        if ((map = this.myNSToCodeContextMap.get(namespace)) != null) {
            map.remove(module);
        }
    }

    public static CodeContextHolder getInstance(@NotNull Project project) {
        if (project == null) {
            CodeContextHolder.$$$reportNull$$$0(8);
        }
        return (CodeContextHolder)((Object)project.getComponent(CodeContextHolder.class));
    }

    @Nullable
    public synchronized CodeContext getStandardContext(String namespace, Module module) {
        Map<Module, CodeContext> map = this.myStandardContexts.get(namespace);
        return map == null ? null : map.get(module);
    }

    public synchronized Collection<String> getNamespaces(Module module) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Map<Module, CodeContext>> entry : this.myStandardContexts.entrySet()) {
            if (!entry.getValue().containsKey(module)) continue;
            result.add(entry.getKey());
        }
        for (Map.Entry<String, Map<Module, CodeContext>> entry : this.myNSToCodeContextMap.entrySet()) {
            if (!entry.getValue().containsKey(module)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    synchronized void putStandardContext(String namespace, Module module, CodeContext codeContext) {
        Map<Module, CodeContext> map = this.myStandardContexts.get(namespace);
        if (map == null) {
            map = new HashMap<Module, CodeContext>();
            this.myStandardContexts.put(namespace, map);
        }
        map.put(module, codeContext);
    }

    synchronized boolean areSdkComponentsHandledForModule(Module module) {
        return this.myModulesWithSdkComponentsHandled.contains(module);
    }

    synchronized boolean setSdkComponentsHandledForModule(Module module) {
        return this.myModulesWithSdkComponentsHandled.add(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/flex/mxml/schema/CodeContextHolder";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/flex/mxml/schema/CodeContextHolder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCodeContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putCodeContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clearCodeContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

