/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.resolve;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionScriptImportHandler
extends JSImportHandler {
    private static ActionScriptImportHandler INSTANCE = new ActionScriptImportHandler();
    public static final Key<CachedValue<Map<String, JSImportedElementResolveResult>>> ourImportResolveCache = Key.create((String)"js.import.resolve");
    public static final UserDataCache<CachedValue<Map<String, JSImportedElementResolveResult>>, PsiElement, Object> myImportResolveCache = new UserDataCache<CachedValue<Map<String, JSImportedElementResolveResult>>, PsiElement, Object>(){

        protected CachedValue<Map<String, JSImportedElementResolveResult>> compute(PsiElement psiElement, Object p) {
            return CachedValuesManager.getManager((Project)psiElement.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)ContainerUtil.newConcurrentMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
        }
    };

    protected ActionScriptImportHandler() {
    }

    public static JSImportHandler getInstance() {
        return INSTANCE;
    }

    @NotNull
    public JSTypeResolveResult resolveName(@NotNull String type, @NotNull PsiElement context) {
        JSImportedElementResolveResult result;
        if (type == null) {
            ActionScriptImportHandler.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ActionScriptImportHandler.$$$reportNull$$$0(1);
        }
        String resolvedType = (result = this._resolveTypeName(type, context)) != null ? result.qualifiedName : type;
        JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(resolvedType != null ? resolvedType : type, null);
        if (jSTypeResolveResult == null) {
            ActionScriptImportHandler.$$$reportNull$$$0(2);
        }
        return jSTypeResolveResult;
    }

    @Nullable
    private JSImportedElementResolveResult _resolveTypeName(@Nullable String _name, @NotNull PsiElement context) {
        String name;
        if (context == null) {
            ActionScriptImportHandler.$$$reportNull$$$0(3);
        }
        if ((name = _name) == null) {
            return null;
        }
        JSResolveUtil.GenericSignature genericSignature = JSResolveUtil.extractGenericSignature((String)name);
        if (genericSignature != null) {
            name = genericSignature.elementType;
        }
        Ref resultRef = new Ref();
        String name1 = name;
        JSResolveUtil.walkOverStructure((PsiElement)context, context1 -> {
            JSImportedElementResolveResult resolved = null;
            if (context1 instanceof XmlBackedJSClassImpl) {
                XmlTag rootTag = ((XmlBackedJSClassImpl)context1).getParent();
                if (rootTag != null && name1.equals(rootTag.getLocalName())) {
                    PsiElement element;
                    XmlElementDescriptor descriptor = rootTag.getDescriptor();
                    PsiElement psiElement = element = descriptor != null ? descriptor.getDeclaration() : null;
                    if (element instanceof XmlFile) {
                        element = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)element));
                    }
                    String s = element instanceof JSClass ? ((JSClass)element).getQualifiedName() : rootTag.getLocalName();
                    resolved = new JSImportedElementResolveResult(s);
                } else {
                    resolved = ActionScriptImportHandler.resolveTypeNameUsingImports(name1, context1);
                }
            } else if (context1 instanceof JSQualifiedNamedElement) {
                if (context1 instanceof JSClass && name1.equals(context1.getName())) {
                    resolved = new JSImportedElementResolveResult(((JSQualifiedNamedElement)context1).getQualifiedName());
                } else {
                    resolved = ActionScriptImportHandler.resolveTypeNameUsingImports(name1, context1);
                    if (resolved == null && context1.getParent() instanceof JSFile) {
                        PsiElement byQName;
                        String packageName;
                        String qName = ((JSQualifiedNamedElement)context1).getQualifiedName();
                        String string = qName == null ? "" : (packageName = context1 instanceof JSPackageStatement ? qName + "." : qName.substring(0, qName.lastIndexOf(46) + 1));
                        if (packageName.length() != 0 && (byQName = JSClassResolver.findClassFromNamespace((String)(packageName + name1), (PsiElement)context1)) instanceof JSQualifiedNamedElement) {
                            resolved = new JSImportedElementResolveResult(((JSQualifiedNamedElement)byQName).getQualifiedName());
                        }
                    }
                }
            } else {
                PsiElement contextOfContext;
                resolved = ActionScriptImportHandler.resolveTypeNameUsingImports(name1, context1);
                if (resolved == null && context1 instanceof JSFile && (contextOfContext = context1.getContext()) != null) {
                    XmlBackedJSClassImpl clazz;
                    XmlBackedJSClassImpl xmlBackedJSClassImpl = clazz = contextOfContext instanceof XmlElement ? (XmlBackedJSClassImpl)XmlBackedJSClassImpl.getContainingComponent((XmlElement)((XmlElement)contextOfContext)) : null;
                    if (clazz != null) {
                        SinkResolveProcessor r = new SinkResolveProcessor(name1, (ResultSink)new ResolveResultSink(null, name1));
                        r.setForceImportsForPlace(true);
                        boolean b = clazz.doImportFromScripts((PsiScopeProcessor)r, (PsiElement)clazz);
                        if (!b) {
                            JSQualifiedNamedElement clazzFromComponent;
                            PsiElement resultFromProcessor = r.getResult();
                            JSQualifiedNamedElement jSQualifiedNamedElement = clazzFromComponent = resultFromProcessor instanceof JSQualifiedNamedElement ? (JSQualifiedNamedElement)resultFromProcessor : null;
                            if (clazzFromComponent != null) {
                                resolved = new JSImportedElementResolveResult(clazzFromComponent.getQualifiedName(), (PsiElement)clazz, null);
                            }
                        }
                    }
                }
            }
            if (resolved != null) {
                resultRef.set((Object)resolved);
                return false;
            }
            return !(context1 instanceof JSPackageStatement);
        });
        JSImportedElementResolveResult result = (JSImportedElementResolveResult)resultRef.get();
        if (genericSignature != null && result != null) {
            StringBuilder genericSignatureBuffer = new StringBuilder();
            genericSignatureBuffer.append(".<");
            genericSignatureBuffer.append(this.resolveTypeName(genericSignature.genericType, context).getQualifiedName());
            genericSignatureBuffer.append(">");
            result = result.appendSignature(genericSignatureBuffer.toString());
        }
        return result;
    }

    private static JSNamedElement resolveTypeNameInTheSamePackage(@NotNull String str, PsiElement context) {
        PsiElement byQName;
        JSNamedElement fileLocalElement;
        if (str == null) {
            ActionScriptImportHandler.$$$reportNull$$$0(4);
        }
        if ((fileLocalElement = JSResolveUtil.findFileLocalElement((String)str, (PsiElement)context)) != null) {
            return fileLocalElement;
        }
        String packageQualifierText = JSResolveUtil.findPackageStatementQualifier((PsiElement)context);
        if (packageQualifierText != null && (byQName = JSClassResolver.findClassFromNamespace((String)(packageQualifierText + "." + str), (PsiElement)context)) instanceof JSQualifiedNamedElement) {
            return (JSQualifiedNamedElement)byQName;
        }
        byQName = JSDialectSpecificHandlersFactory.forElement((PsiElement)context).getClassResolver().findClassByQName(str, context);
        if (byQName instanceof JSQualifiedNamedElement && JSResolveUtil.acceptableSymbol((JSQualifiedNamedElement)((JSQualifiedNamedElement)byQName), (JSResolveUtil.GlobalSymbolsAcceptanceState)JSResolveUtil.GlobalSymbolsAcceptanceState.WHATEVER, (boolean)false, (PsiElement)context)) {
            return (JSQualifiedNamedElement)byQName;
        }
        return null;
    }

    @Nullable
    public JSImportedElementResolveResult resolveTypeNameUsingImports(@NotNull JSReferenceExpression expr) {
        if (expr == null) {
            ActionScriptImportHandler.$$$reportNull$$$0(5);
        }
        if (expr.getQualifier() != null) {
            return null;
        }
        if (JSResolveUtil.getElementThatShouldBeQualified((PsiElement)expr, null) != null) {
            return null;
        }
        if (expr.getReferencedName() == null) {
            return null;
        }
        return this._resolveTypeName(expr.getText(), (PsiElement)expr);
    }

    @Nullable
    private static JSImportedElementResolveResult resolveTypeNameUsingImports(@NotNull String referencedName, PsiNamedElement parent) {
        Map map;
        JSImportedElementResolveResult result;
        if (referencedName == null) {
            ActionScriptImportHandler.$$$reportNull$$$0(6);
        }
        if ((result = (JSImportedElementResolveResult)(map = (Map)((CachedValue)myImportResolveCache.get(ourImportResolveCache, (UserDataHolder)parent, null)).getValue()).get(referencedName)) == null) {
            SinkResolveProcessor resolveProcessor = new SinkResolveProcessor(referencedName, (ResultSink)new ResolveResultSink(null, referencedName));
            INSTANCE.resolveTypeNameUsingImportsInner((ResolveProcessor)resolveProcessor, parent);
            ResolveResult[] resolveResults = resolveProcessor.getResultsAsResolveResults();
            assert (resolveResults.length < 2);
            if (resolveResults.length == 1 && resolveResults[0] instanceof JSResolveResult) {
                JSResolveResult resolveResult = (JSResolveResult)resolveResults[0];
                PsiElement element = resolveResult.getElement();
                String typeName = ((JSQualifiedNamedElement)element).getQualifiedName();
                result = new JSImportedElementResolveResult(typeName, element, resolveResult.getActionScriptImport());
            }
            map.put(referencedName, result != null ? result : JSImportedElementResolveResult.EMPTY_RESULT);
        }
        return result != JSImportedElementResolveResult.EMPTY_RESULT ? result : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean resolveTypeNameUsingImportsInner(ResolveProcessor resolveProcessor, PsiNamedElement parent) {
        block10: {
            JSNamedElement jsClass;
            PsiElement element = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)parent);
            if (!JSImportHandlingUtil.ourPsiScopedImportSet.tryResolveImportedClass(parent, resolveProcessor)) {
                return false;
            }
            if (parent instanceof JSPackageStatement) {
                JSNamedElement jsClass2 = ActionScriptImportHandler.resolveTypeNameInTheSamePackage(resolveProcessor.getName(), (PsiElement)parent);
                if (jsClass2 == null) return true;
                if (resolveProcessor.execute((PsiElement)jsClass2, ResolveState.initial())) return true;
                return false;
            }
            if (parent instanceof JSFile && parent.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
                if (element instanceof XmlBackedJSClassImpl) {
                    JSClass parentClass;
                    JSClass[] classes;
                    jsClass = ActionScriptImportHandler.resolveTypeNameInTheSamePackage(resolveProcessor.getName(), element);
                    if (jsClass == null && (classes = (parentClass = (JSClass)element).getSuperClasses()) != null && classes.length > 0 && resolveProcessor.getName().equals(classes[0].getName())) {
                        jsClass = classes[0];
                    }
                    if (jsClass != null && !resolveProcessor.execute((PsiElement)jsClass, ResolveState.initial())) {
                        return false;
                    }
                    break block10;
                } else {
                    JSNamedElement jsClass3 = ActionScriptImportHandler.resolveTypeNameInTheSamePackage(resolveProcessor.getName(), element);
                    if (jsClass3 == null) return true;
                    if (resolveProcessor.execute((PsiElement)jsClass3, ResolveState.initial())) return true;
                    return false;
                }
            }
            if (parent instanceof XmlBackedJSClassImpl && (jsClass = ActionScriptImportHandler.resolveTypeNameInTheSamePackage(resolveProcessor.getName(), (PsiElement)parent)) != null && !resolveProcessor.execute((PsiElement)jsClass, ResolveState.initial())) {
                return false;
            }
        }
        JSResolveHelper[] jSResolveHelperArray = (JSResolveHelper[])Extensions.getExtensions((ExtensionPointName)JSResolveHelper.EP_NAME);
        int n = jSResolveHelperArray.length;
        int n2 = 0;
        while (n2 < n) {
            JSResolveHelper helper = jSResolveHelperArray[n2];
            if (!helper.resolveTypeNameUsingImports(resolveProcessor, parent)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean importClass(PsiScopeProcessor processor, PsiNamedElement parent) {
        ResolveProcessor resolveProcessor = (ResolveProcessor)processor;
        if (resolveProcessor.isLocalResolve() || resolveProcessor.needPackages()) {
            return true;
        }
        String s = resolveProcessor.getName();
        if (s != null) {
            if (resolveProcessor.needsAllVariants()) {
                return this.resolveTypeNameUsingImportsInner(resolveProcessor, parent);
            }
            JSImportedElementResolveResult expression = ActionScriptImportHandler.resolveTypeNameUsingImports(s, parent);
            return !ActionScriptImportHandler.dispatchResult(expression, processor);
        }
        return ActionScriptImportHandler.importClassViaHelper(processor, parent);
    }

    private static boolean dispatchResult(JSImportedElementResolveResult expression, PsiScopeProcessor processor) {
        PsiElement element;
        if (expression != null && (element = expression.resolvedElement) != null) {
            ResolveState state = ResolveState.initial();
            if (expression.importStatement != null) {
                state = state.put(JSResolveResult.IMPORT_KEY, (Object)expression.importStatement);
            }
            return !processor.execute(element, state);
        }
        return false;
    }

    public static boolean importClassViaHelper(PsiScopeProcessor processor, PsiNamedElement file) {
        for (JSResolveHelper helper : (JSResolveHelper[])Extensions.getExtensions((ExtensionPointName)JSResolveHelper.EP_NAME)) {
            if (helper.importClass(processor, file)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/flex/resolve/ActionScriptImportHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/flex/resolve/ActionScriptImportHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveName";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "_resolveTypeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeNameInTheSamePackage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeNameUsingImports";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

