/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.InfoFromConfigFile;
import com.intellij.lang.javascript.flex.build.NamespacesXmlBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;

public class FlexCompilerConfigFileUtil {
    private static final Key<Pair<Long, Collection<NamespacesInfo>>> MOD_STAMP_TO_NAMESPACES_INFOS = Key.create((String)"MOD_STAMP_TO_NAMESPACES_INFOS");
    private static final Key<Pair<Long, InfoFromConfigFile>> MOD_STAMP_AND_INFO_FROM_CONFIG_FILE = Key.create((String)"MOD_STAMP_AND_INFO_FROM_CONFIG_FILE");
    private static final String TARGET_PLAYER_ELEMENT = "<flex-config><target-player>";
    private static final String FILE_SPEC_ELEMENT = "<flex-config><file-specs><path-element>";
    private static final String OUTPUT_ELEMENT = "<flex-config><output>";
    public static final String INCLUDE_NAMESPACES = "include-namespaces";
    public static final String NAMESPACES = "namespaces";
    public static final String NAMESPACE = "namespace";
    public static final String MANIFEST = "manifest";
    public static final String URI = "uri";
    public static final String DEFINE = "define";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String FILE_SPECS = "file-specs";
    public static final String OUTPUT = "output";

    private FlexCompilerConfigFileUtil() {
    }

    public static Collection<NamespacesInfo> getNamespacesInfos(VirtualFile configFile) {
        Long cachedTimestamp;
        if (configFile == null || !configFile.isValid() || configFile.isDirectory()) {
            return Collections.emptyList();
        }
        Pair data = (Pair)configFile.getUserData(MOD_STAMP_TO_NAMESPACES_INFOS);
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document cachedDocument = documentManager.getCachedDocument(configFile);
        Long currentTimestamp = cachedDocument != null ? cachedDocument.getModificationStamp() : configFile.getModificationCount();
        Long l = cachedTimestamp = data == null ? null : (Long)data.first;
        if (cachedTimestamp == null || !cachedTimestamp.equals(currentTimestamp)) {
            data = null;
            configFile.putUserData(MOD_STAMP_TO_NAMESPACES_INFOS, (Object)data);
            try {
                NamespacesXmlBuilder builder = new NamespacesXmlBuilder();
                if (cachedDocument != null) {
                    NanoXmlUtil.parse((Reader)new CharSequenceReader(cachedDocument.getCharsSequence()), (IXMLBuilder)builder);
                } else {
                    NanoXmlUtil.parse((InputStream)configFile.getInputStream(), (IXMLBuilder)builder);
                }
                ArrayList<NamespacesInfo> namespacesInfos = new ArrayList<NamespacesInfo>();
                Collection<String> includedInSwcNamespaces = builder.getIncludedNamespaces();
                for (Pair<String, String> namespaceAndManifest : builder.getNamespacesAndManifests()) {
                    namespacesInfos.add(new NamespacesInfo((String)namespaceAndManifest.first, (String)namespaceAndManifest.second, includedInSwcNamespaces.contains(namespaceAndManifest.first)));
                }
                data = Pair.create((Object)currentTimestamp, namespacesInfos);
                configFile.putUserData(MOD_STAMP_TO_NAMESPACES_INFOS, (Object)data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return data == null ? Collections.emptyList() : (Collection)data.second;
    }

    @NotNull
    public static InfoFromConfigFile getInfoFromConfigFile(String configFilePath) {
        Long cachedTimestamp;
        VirtualFile configFile;
        VirtualFile virtualFile = configFile = configFilePath.isEmpty() ? null : LocalFileSystem.getInstance().findFileByPath(configFilePath);
        if (configFile == null) {
            InfoFromConfigFile infoFromConfigFile = InfoFromConfigFile.DEFAULT;
            if (infoFromConfigFile == null) {
                FlexCompilerConfigFileUtil.$$$reportNull$$$0(0);
            }
            return infoFromConfigFile;
        }
        Pair data = (Pair)configFile.getUserData(MOD_STAMP_AND_INFO_FROM_CONFIG_FILE);
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document cachedDocument = documentManager.getCachedDocument(configFile);
        Long currentTimestamp = cachedDocument != null ? cachedDocument.getModificationStamp() : configFile.getModificationCount();
        Long l = cachedTimestamp = data == null ? null : (Long)data.first;
        if (cachedTimestamp == null || !cachedTimestamp.equals(currentTimestamp)) {
            data = null;
            configFile.putUserData(MOD_STAMP_AND_INFO_FROM_CONFIG_FILE, (Object)data);
            List<String> xmlElements = Arrays.asList(FILE_SPEC_ELEMENT, OUTPUT_ELEMENT, TARGET_PLAYER_ELEMENT);
            String mainClassPath = null;
            String outputPath = null;
            String targetPlayer = null;
            try {
                List<String> targetPlayerList;
                List<String> outputList;
                InputStream inputStream = cachedDocument == null ? configFile.getInputStream() : new ByteArrayInputStream(cachedDocument.getText().getBytes());
                Map<String, List<String>> map = FlexUtils.findXMLElements(inputStream, xmlElements);
                List<String> fileSpecList = map.get(FILE_SPEC_ELEMENT);
                if (!fileSpecList.isEmpty()) {
                    mainClassPath = fileSpecList.get(0).trim();
                }
                if (!(outputList = map.get(OUTPUT_ELEMENT)).isEmpty() && !FileUtil.isAbsolute((String)(outputPath = outputList.get(0).trim()))) {
                    try {
                        outputPath = FileUtil.toSystemIndependentName((String)new File(configFile.getParent().getPath() + "/" + outputPath).getCanonicalPath());
                    }
                    catch (IOException e) {
                        outputPath = FileUtil.toSystemIndependentName((String)new File(configFile.getParent().getPath() + "/" + outputPath).getAbsolutePath());
                    }
                }
                if (!(targetPlayerList = map.get(TARGET_PLAYER_ELEMENT)).isEmpty()) {
                    targetPlayer = targetPlayerList.get(0).trim();
                }
            }
            catch (IOException inputStream) {
                // empty catch block
            }
            String outputFileName = outputPath == null ? null : PathUtil.getFileName(outputPath);
            String outputFolderPath = outputPath == null ? null : PathUtil.getParentPath(outputPath);
            data = Pair.create((Object)currentTimestamp, (Object)new InfoFromConfigFile(configFile, mainClassPath, outputFileName, outputFolderPath, targetPlayer));
            configFile.putUserData(MOD_STAMP_AND_INFO_FROM_CONFIG_FILE, (Object)data);
        }
        InfoFromConfigFile infoFromConfigFile = (InfoFromConfigFile)data.second;
        if (infoFromConfigFile == null) {
            FlexCompilerConfigFileUtil.$$$reportNull$$$0(1);
        }
        return infoFromConfigFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/build/FlexCompilerConfigFileUtil", "getInfoFromConfigFile"));
    }

    public static class NamespacesInfo {
        public final String namespace;
        public final String manifest;
        public final boolean includedInSwc;

        private NamespacesInfo(String namespace, String manifest, boolean includedInSwc) {
            this.namespace = namespace;
            this.manifest = manifest;
            this.includedInSwc = includedInSwc;
        }
    }
}

