/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.FlexCompilationManager;
import com.intellij.lang.javascript.flex.build.FlexCompilationTask;
import com.intellij.lang.javascript.flex.build.FlexCompilationUtils;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MxmlcCompcCompilationTask
extends FlexCompilationTask {
    private Process myProcess;

    public MxmlcCompcCompilationTask(@NotNull Module module, @NotNull FlexBuildConfiguration bc, @NotNull Collection<FlexBuildConfiguration> dependencies) {
        if (module == null) {
            MxmlcCompcCompilationTask.$$$reportNull$$$0(0);
        }
        if (bc == null) {
            MxmlcCompcCompilationTask.$$$reportNull$$$0(1);
        }
        if (dependencies == null) {
            MxmlcCompcCompilationTask.$$$reportNull$$$0(2);
        }
        super(module, bc, dependencies);
    }

    @Override
    protected void doStart(FlexCompilationManager compilationManager) throws IOException {
        boolean app = this.myBC.getOutputType() != OutputType.Library;
        Sdk sdk = this.myBC.getSdk();
        assert (sdk != null);
        List<String> compilerCommand = FlexCompilationUtils.getMxmlcCompcCommand(this.myModule.getProject(), sdk, app);
        List<String> command = FlexCompilationUtils.buildCommand(compilerCommand, this.getConfigFiles(), this.myModule, this.myBC);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(new File(FlexUtils.getFlexCompilerWorkDirPath(this.myModule.getProject(), null)));
        compilationManager.addMessage(this, CompilerMessageCategory.INFORMATION, StringUtil.join(command, (String)" "), null, -1, -1);
        this.myProcess = processBuilder.start();
        this.readInputStream(compilationManager);
    }

    @Override
    protected void doCancel() {
        if (this.myProcess != null) {
            this.myProcess.destroy();
        }
    }

    private void readInputStream(FlexCompilationManager compilationManager) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            InputStreamReader reader = FlexCommonUtils.createInputStreamReader((InputStream)this.myProcess.getInputStream());
            try {
                int read;
                char[] buf = new char[2048];
                while ((read = reader.read(buf, 0, buf.length)) >= 0) {
                    String output = new String(buf, 0, read);
                    boolean ok = FlexCompilationUtils.handleCompilerOutput(compilationManager, this, output);
                    if (ok) continue;
                    this.myCompilationFailed = true;
                }
            }
            catch (IOException e) {
                compilationManager.addMessage(this, CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                this.myCompilationFailed = true;
            }
            finally {
                this.cancel();
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "bc";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dependencies";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/flex/build/MxmlcCompcCompilationTask";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

