/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingMode;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingType;
import com.intellij.lang.javascript.flex.debug.FlexDebugProcess;
import com.intellij.lang.javascript.flex.debug.VMState;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class DebuggerCommand {
    private final String myText;
    private final CommandOutputProcessingType myOutputProcessingType;
    private final VMState myEndVMState;
    private final VMState myStartVMState;

    DebuggerCommand(@NotNull @NonNls String _text) {
        if (_text == null) {
            DebuggerCommand.$$$reportNull$$$0(0);
        }
        this(_text, CommandOutputProcessingType.NO_PROCESSING);
    }

    DebuggerCommand(@NotNull @NonNls String _text, CommandOutputProcessingType outputProcessingType) {
        if (_text == null) {
            DebuggerCommand.$$$reportNull$$$0(1);
        }
        this(_text, outputProcessingType, VMState.SUSPENDED, VMState.SUSPENDED);
    }

    DebuggerCommand(@NotNull @NonNls String _text, CommandOutputProcessingType outputProcessingType, VMState startState, VMState endState) {
        if (_text == null) {
            DebuggerCommand.$$$reportNull$$$0(2);
        }
        this.myText = _text;
        this.myOutputProcessingType = outputProcessingType;
        this.myStartVMState = startState;
        this.myEndVMState = endState;
    }

    @NotNull
    @NonNls
    String getText() {
        String string = this.myText;
        if (string == null) {
            DebuggerCommand.$$$reportNull$$$0(3);
        }
        return string;
    }

    public CommandOutputProcessingType getOutputProcessingMode() {
        return this.myOutputProcessingType;
    }

    public VMState getEndVMState() {
        return this.myEndVMState;
    }

    public VMState getStartVMState() {
        return this.myStartVMState;
    }

    CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
        assert (this.myOutputProcessingType != CommandOutputProcessingType.NO_PROCESSING);
        return CommandOutputProcessingMode.DONE;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void post(FlexDebugProcess flexDebugProcess) throws IOException {
        flexDebugProcess.doSendCommandText(this);
    }

    public String read(FlexDebugProcess flexDebugProcess) throws IOException {
        return flexDebugProcess.defaultReadCommand(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/debug/DebuggerCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/debug/DebuggerCommand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

