/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.projectStructure.model.AirSigningOptions;
import com.intellij.lang.javascript.flex.projectStructure.ui.AirPackagingConfigurableBase;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class SigningOptionsForm {
    private static final String MORE_OPTIONS = "More options";
    private static final String LESS_OPTIONS = "Less options";
    private final Mode myMode;
    private JPanel myMainPanel;
    private JLabel myTargetArchitectureLabel;
    private JBRadioButton myArchArmv7RadioButton;
    private JBRadioButton myArchX86RadioButton;
    private JCheckBox myUseTempCertificateCheckBox;
    private JLabel myProvisioningProfileLabel;
    private TextFieldWithBrowseButton myProvisioningProfileTextWithBrowse;
    private JLabel myKeystoreFileLabel;
    private TextFieldWithBrowseButton myKeystoreFileTextWithBrowse;
    private JLabel myIosSdkLabel;
    private TextFieldWithBrowseButton myIosSdkTextWithBrowse;
    private HoverHyperlinkLabel myMoreOptionsHyperlinkLabel;
    private JLabel myKeystoreTypeLabel;
    private JTextField myKeystoreTypeTextField;
    private JLabel myKeyAliasLabel;
    private JTextField myKeyAliasTextField;
    private JLabel myProviderClassNameLabel;
    private JTextField myProviderClassNameTextField;
    private JLabel myTsaUrlLabel;
    private JTextField myTsaUrlTextField;
    private JLabel myAdtOptionsLabel;
    private RawCommandLineEditor myAdtOptionsComponent;

    public SigningOptionsForm(Project project, Mode mode) {
        this.myMode = mode;
        this.$$$setupUI$$$();
        this.myUseTempCertificateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SigningOptionsForm.this.updateControls();
            }
        });
        this.myProvisioningProfileTextWithBrowse.addBrowseFolderListener(null, null, project, FlexUtils.createFileChooserDescriptor("mobileprovision"));
        this.myIosSdkTextWithBrowse.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        FileChooserDescriptor d = mode == Mode.iOS ? FlexUtils.createFileChooserDescriptor("p12") : FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        this.myKeystoreFileTextWithBrowse.addBrowseFolderListener(null, null, project, d);
        this.myAdtOptionsComponent.setDialogCaption("Additional ADT Options");
        this.myMoreOptionsHyperlinkLabel.setText(MORE_OPTIONS);
        this.myMoreOptionsHyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SigningOptionsForm.this.showMoreOptions(!SigningOptionsForm.this.isShowingMoreOptions());
                }
            }
        });
        this.updateMoreOptions();
        switch (mode) {
            case Desktop: {
                this.myTargetArchitectureLabel.setVisible(false);
                this.myArchArmv7RadioButton.setVisible(false);
                this.myArchX86RadioButton.setVisible(false);
            }
            case Android: {
                this.myProvisioningProfileLabel.setVisible(false);
                this.myProvisioningProfileTextWithBrowse.setVisible(false);
                this.myIosSdkLabel.setVisible(false);
                this.myIosSdkTextWithBrowse.setVisible(false);
                this.myAdtOptionsLabel.setVisible(false);
                this.myAdtOptionsComponent.setVisible(false);
                break;
            }
            case iOS: {
                this.myTargetArchitectureLabel.setVisible(false);
                this.myArchArmv7RadioButton.setVisible(false);
                this.myArchX86RadioButton.setVisible(false);
                this.myUseTempCertificateCheckBox.setVisible(false);
                this.showMoreOptions(false);
                this.myMoreOptionsHyperlinkLabel.setVisible(false);
            }
        }
    }

    private void createUIComponents() {
        this.myMoreOptionsHyperlinkLabel = new HoverHyperlinkLabel(MORE_OPTIONS);
    }

    private void showMoreOptions(boolean show) {
        this.myMoreOptionsHyperlinkLabel.setText(show ? LESS_OPTIONS : MORE_OPTIONS);
        this.updateMoreOptions();
    }

    private boolean isShowingMoreOptions() {
        return this.myMoreOptionsHyperlinkLabel.getText().contains(LESS_OPTIONS);
    }

    private void updateMoreOptions() {
        boolean showingMoreOption = this.isShowingMoreOptions();
        this.myKeystoreTypeLabel.setVisible(showingMoreOption);
        this.myKeystoreTypeTextField.setVisible(showingMoreOption);
        this.myKeyAliasLabel.setVisible(showingMoreOption);
        this.myKeyAliasTextField.setVisible(showingMoreOption);
        this.myProviderClassNameLabel.setVisible(showingMoreOption);
        this.myProviderClassNameTextField.setVisible(showingMoreOption);
        this.myTsaUrlLabel.setVisible(showingMoreOption && this.myMode != Mode.Android);
        this.myTsaUrlTextField.setVisible(showingMoreOption && this.myMode != Mode.Android);
    }

    private void updateControls() {
        boolean enabled = !this.myUseTempCertificateCheckBox.isVisible() || !this.myUseTempCertificateCheckBox.isSelected();
        this.myProvisioningProfileLabel.setEnabled(enabled);
        this.myProviderClassNameTextField.setEnabled(enabled);
        this.myKeystoreFileLabel.setEnabled(enabled);
        this.myKeystoreFileTextWithBrowse.setEnabled(enabled);
        this.myIosSdkLabel.setEnabled(enabled);
        this.myIosSdkTextWithBrowse.setEnabled(enabled);
        this.myMoreOptionsHyperlinkLabel.setEnabled(enabled);
        if (this.myMoreOptionsHyperlinkLabel.isEnabled()) {
            this.myMoreOptionsHyperlinkLabel.setForeground(PlatformColors.BLUE);
        }
        this.myKeystoreTypeLabel.setEnabled(enabled);
        this.myKeystoreTypeTextField.setEnabled(enabled);
        this.myKeyAliasLabel.setEnabled(enabled);
        this.myKeyAliasTextField.setEnabled(enabled);
        this.myProviderClassNameLabel.setEnabled(enabled);
        this.myProviderClassNameTextField.setEnabled(enabled);
        this.myTsaUrlLabel.setEnabled(enabled);
        this.myTsaUrlTextField.setEnabled(enabled);
    }

    public void setEnabled(boolean enabled) {
        UIUtil.setEnabled((Component)this.myMainPanel, (boolean)enabled, (boolean)true);
        if (enabled) {
            this.updateControls();
        }
    }

    @NotNull
    private String getArch() {
        String string = this.myArchX86RadioButton.isSelected() ? "x86" : "armv7";
        if (string == null) {
            SigningOptionsForm.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void resetFrom(AirSigningOptions signingOptions) {
        if (signingOptions.getArch().equals("x86")) {
            this.myArchX86RadioButton.setSelected(true);
        } else {
            this.myArchArmv7RadioButton.setSelected(true);
        }
        this.myUseTempCertificateCheckBox.setSelected(signingOptions.isUseTempCertificate());
        this.myProvisioningProfileTextWithBrowse.setText(FileUtil.toSystemDependentName((String)signingOptions.getProvisioningProfilePath()));
        this.myKeystoreFileTextWithBrowse.setText(FileUtil.toSystemDependentName((String)signingOptions.getKeystorePath()));
        this.myIosSdkTextWithBrowse.setText(FileUtil.toSystemDependentName((String)signingOptions.getIOSSdkPath()));
        this.myAdtOptionsComponent.setText(signingOptions.getADTOptions());
        this.myKeystoreTypeTextField.setText(signingOptions.getKeystoreType());
        this.myKeyAliasTextField.setText(signingOptions.getKeyAlias());
        this.myProviderClassNameTextField.setText(signingOptions.getProvider());
        this.myTsaUrlTextField.setText(signingOptions.getTsa());
    }

    public boolean isModified(AirSigningOptions signingOptions) {
        if (this.myTargetArchitectureLabel.isVisible() && !this.getArch().equals(signingOptions.getArch())) {
            return true;
        }
        if (this.myUseTempCertificateCheckBox.isVisible() && this.myUseTempCertificateCheckBox.isSelected() != signingOptions.isUseTempCertificate()) {
            return true;
        }
        String profilePath = FileUtil.toSystemIndependentName((String)this.myProvisioningProfileTextWithBrowse.getText().trim());
        if (this.myProvisioningProfileTextWithBrowse.isVisible() && !profilePath.equals(signingOptions.getProvisioningProfilePath())) {
            return true;
        }
        String keystorePath = FileUtil.toSystemIndependentName((String)this.myKeystoreFileTextWithBrowse.getText().trim());
        if (!keystorePath.equals(signingOptions.getKeystorePath())) {
            return true;
        }
        String iosSdkPath = FileUtil.toSystemIndependentName((String)this.myIosSdkTextWithBrowse.getText().trim());
        if (this.myIosSdkTextWithBrowse.isVisible() && !iosSdkPath.equals(signingOptions.getIOSSdkPath())) {
            return true;
        }
        if (this.myAdtOptionsComponent.isVisible() && !this.myAdtOptionsComponent.getText().equals(signingOptions.getADTOptions())) {
            return false;
        }
        if (!this.myKeystoreTypeTextField.getText().trim().equals(signingOptions.getKeystoreType())) {
            return true;
        }
        if (!this.myKeyAliasTextField.getText().equals(signingOptions.getKeyAlias())) {
            return true;
        }
        if (!this.myProviderClassNameTextField.getText().equals(signingOptions.getProvider())) {
            return true;
        }
        return !this.myTsaUrlTextField.getText().equals(signingOptions.getTsa());
    }

    public void applyTo(AirSigningOptions signingOptions) {
        signingOptions.setArch(this.getArch());
        signingOptions.setUseTempCertificate(this.myUseTempCertificateCheckBox.isSelected());
        signingOptions.setProvisioningProfilePath(FileUtil.toSystemIndependentName((String)this.myProvisioningProfileTextWithBrowse.getText().trim()));
        signingOptions.setKeystorePath(FileUtil.toSystemIndependentName((String)this.myKeystoreFileTextWithBrowse.getText().trim()));
        signingOptions.setIOSSdkPath(FileUtil.toSystemIndependentName((String)this.myIosSdkTextWithBrowse.getText().trim()));
        signingOptions.setADTOptions(this.myAdtOptionsComponent.getText().trim());
        signingOptions.setKeystoreType(this.myKeystoreTypeTextField.getText().trim());
        signingOptions.setKeyAlias(this.myKeyAliasTextField.getText());
        signingOptions.setProvider(this.myProviderClassNameTextField.getText());
        signingOptions.setTsa(this.myTsaUrlTextField.getText());
    }

    public ActionCallback navigateTo(AirPackagingConfigurableBase.Location location) {
        switch (location) {
            case ProvisioningProfile: {
                return IdeFocusManager.findInstance().requestFocus((Component)this.myProvisioningProfileTextWithBrowse.getChildComponent(), true);
            }
            case Keystore: {
                return IdeFocusManager.findInstance().requestFocus((Component)this.myKeystoreFileTextWithBrowse.getChildComponent(), true);
            }
            case IosSdkPath: {
                return IdeFocusManager.findInstance().requestFocus((Component)this.myIosSdkTextWithBrowse.getTextField(), true);
            }
        }
        return ActionCallback.DONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/SigningOptionsForm", "getArch"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JLabel jLabel;
        RawCommandLineEditor rawCommandLineEditor;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel3;
        JLabel jLabel4;
        JTextField jTextField;
        JTextField jTextField2;
        JLabel jLabel5;
        JTextField jTextField3;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel6;
        JTextField jTextField4;
        JLabel jLabel7;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JLabel jLabel8;
        JLabel jLabel9;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        this.myUseTempCertificateCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox.setText("Use temporary self-signed certificate");
        jCheckBox.setMnemonic('S');
        jCheckBox.setDisplayedMnemonicIndex(14);
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myKeystoreFileLabel = jLabel9 = new JLabel();
        jLabel9.setText("Keystore file:");
        jLabel9.setDisplayedMnemonic('F');
        jLabel9.setDisplayedMnemonicIndex(9);
        jPanel.add((Component)jLabel9, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myMoreOptionsHyperlinkLabel;
        hoverHyperlinkLabel.setText(MORE_OPTIONS);
        jPanel.add((Component)hoverHyperlinkLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProvisioningProfileLabel = jLabel8 = new JLabel();
        jLabel8.setText("Provisioning profile:");
        jLabel8.setDisplayedMnemonic('V');
        jLabel8.setDisplayedMnemonicIndex(3);
        jPanel.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProvisioningProfileTextWithBrowse = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton3, new GridConstraints(2, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        this.myProviderClassNameLabel = jLabel7 = new JLabel();
        jLabel7.setText("Provider class:");
        jLabel7.setDisplayedMnemonic('R');
        jLabel7.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jLabel7, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProviderClassNameTextField = jTextField4 = new JTextField();
        jPanel.add((Component)jTextField4, new GridConstraints(7, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(100, -1), null));
        this.myKeystoreTypeLabel = jLabel6 = new JLabel();
        jLabel6.setText("Keystore type:");
        jLabel6.setDisplayedMnemonic('T');
        jLabel6.setDisplayedMnemonicIndex(9);
        jPanel.add((Component)jLabel6, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeystoreFileTextWithBrowse = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(3, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        this.myKeyAliasTextField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(6, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(100, -1), null));
        this.myKeyAliasLabel = jLabel5 = new JLabel();
        jLabel5.setText("Key alias:");
        jLabel5.setDisplayedMnemonic('I');
        jLabel5.setDisplayedMnemonicIndex(6);
        jPanel.add((Component)jLabel5, new GridConstraints(6, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeystoreTypeTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(100, -1), null));
        this.myTsaUrlTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(7, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(100, -1), null));
        this.myTsaUrlLabel = jLabel4 = new JLabel();
        jLabel4.setText("TSA:");
        jPanel.add((Component)jLabel4, new GridConstraints(7, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIosSdkLabel = jLabel3 = new JLabel();
        jLabel3.setText("Apple iOS SDK:");
        jLabel3.setDisplayedMnemonic('O');
        jLabel3.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIosSdkTextWithBrowse = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        this.myAdtOptionsLabel = jLabel2 = new JLabel();
        jLabel2.setText("Additional ADT options:");
        jLabel2.setDisplayedMnemonic('D');
        jLabel2.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jLabel2, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAdtOptionsComponent = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(8, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myTargetArchitectureLabel = jLabel = new JLabel();
        jLabel.setText("Architecture:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myArchArmv7RadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("armv7");
        jBRadioButton2.setMnemonic('M');
        jBRadioButton2.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jBRadioButton2, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myArchX86RadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("x86");
        jBRadioButton.setMnemonic('X');
        jBRadioButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBRadioButton, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel9.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel8.setLabelFor((Component)textFieldWithBrowseButton3);
        jLabel7.setLabelFor(jTextField4);
        jLabel6.setLabelFor(jTextField2);
        jLabel5.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField);
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor((Component)rawCommandLineEditor);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    static enum Mode {
        Desktop,
        Android,
        iOS;

    }
}

