/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.flex.model.bc.LinkageType;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlashPlayerTrustUtil {
    private static final String WINDOWS_VISTA_AND_7_TRUST_DIR_REL_PATH = "\\AppData\\Roaming\\Macromedia\\Flash Player\\#Security\\FlashPlayerTrust";
    private static final String WINDOWS_XP_TRUST_DIR_REL_PATH = "\\Application Data\\Macromedia\\Flash Player\\#Security\\FlashPlayerTrust";
    private static final String MAC_TRUST_DIR_REL_PATH = "/Library/Preferences/Macromedia/Flash Player/#Security/FlashPlayerTrust";
    private static final String UNIX_TRUST_DIR_REL_PATH = "/.macromedia/Flash_Player/#Security/FlashPlayerTrust";
    private static final String INTELLIJ_IDEA_CFG = "intellij_idea.cfg";

    private FlashPlayerTrustUtil() {
    }

    public static void updateTrustedStatus(Module module, FlexBuildConfiguration bc, boolean isDebug, boolean isTrusted) {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            paths.add(new File(PathUtil.getParentPath((String)bc.getActualOutputFilePath())).getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (DependencyEntry entry : bc.getDependencies().getEntries()) {
            FlexBuildConfiguration dependencyBC;
            if (!(entry instanceof BuildConfigurationEntry) || entry.getDependencyType().getLinkageType() != LinkageType.LoadInRuntime || (dependencyBC = ((BuildConfigurationEntry)entry).findBuildConfiguration()) == null) continue;
            try {
                paths.add(new File(PathUtil.getParentPath((String)dependencyBC.getActualOutputFilePath())).getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        FlashPlayerTrustUtil.updateTrustedStatus(module.getProject(), isTrusted, isDebug, paths.toArray(new String[paths.size()]));
    }

    public static void updateTrustedStatus(Project project, boolean trustedStatus, boolean isDebug, String ... paths) {
        File ideaCfgFile = FlashPlayerTrustUtil.getIdeaUserTrustConfigFile(project, isDebug, trustedStatus);
        if (ideaCfgFile == null) {
            return;
        }
        try {
            FlashPlayerTrustUtil.fixIdeaCfgFileContentIfNeeded(ideaCfgFile, paths, trustedStatus);
        }
        catch (IOException e) {
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
            manager.notifyByBalloon(isDebug ? ToolWindowId.DEBUG : ToolWindowId.RUN, MessageType.WARNING, FlexBundle.message("failed.to.update.idea.trust.cfg.file", INTELLIJ_IDEA_CFG, e.getMessage()));
        }
    }

    private static void fixIdeaCfgFileContentIfNeeded(@NotNull File ideaCfgFile, @NotNull String[] trustedPaths, boolean runTrusted) throws IOException {
        if (ideaCfgFile == null) {
            FlashPlayerTrustUtil.$$$reportNull$$$0(0);
        }
        if (trustedPaths == null) {
            FlashPlayerTrustUtil.$$$reportNull$$$0(1);
        }
        String[] trustedPathsFiltered = FlashPlayerTrustUtil.removeNestedPaths(trustedPaths);
        StringBuilder buf = new StringBuilder();
        List lines = StringUtil.split((String)FileUtil.loadFile((File)ideaCfgFile, (String)"UTF-8"), (String)"\n");
        for (String line : lines) {
            boolean appendLine = true;
            for (String path : trustedPathsFiltered) {
                appendLine &= !line.equals(path) && !line.startsWith(path + File.separatorChar) && !path.startsWith(line + File.separatorChar);
            }
            if (!appendLine) continue;
            buf.append(line).append('\n');
        }
        if (runTrusted) {
            for (String path : trustedPathsFiltered) {
                buf.append(path).append('\n');
            }
        }
        FileUtil.writeToFile((File)ideaCfgFile, (byte[])buf.toString().getBytes("UTF-8"));
    }

    private static String[] removeNestedPaths(String[] paths) {
        if (paths.length < 2) {
            return paths;
        }
        ArrayList<String> result = new ArrayList<String>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            boolean include = true;
            for (int j = 0; j < paths.length; ++j) {
                String otherPath = paths[j];
                if (i < j && path.equals(otherPath)) {
                    include = false;
                    break;
                }
                if (i == j || !path.startsWith(otherPath + File.separatorChar)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            result.add(path);
        }
        return result.toArray(new String[result.size()]);
    }

    @Nullable
    private static File getIdeaUserTrustConfigFile(Project project, boolean isDebug, boolean runTrusted) {
        File flashPlayerTrustDir = FlashPlayerTrustUtil.getFlashPlayerTrustDir(project, isDebug, runTrusted);
        if (flashPlayerTrustDir == null) {
            return null;
        }
        File ideaTrustedCfgFile = new File(flashPlayerTrustDir, INTELLIJ_IDEA_CFG);
        if (ideaTrustedCfgFile.isFile() && ideaTrustedCfgFile.length() > 102400L) {
            FileUtil.delete((File)ideaTrustedCfgFile);
        }
        if (!ideaTrustedCfgFile.exists() && runTrusted) {
            try {
                boolean ok = ideaTrustedCfgFile.createNewFile();
                if (!ok) {
                    FlashPlayerTrustUtil.showWarningBalloonIfNeeded(project, isDebug, runTrusted, FlexBundle.message("error.creating.idea.trust.cfg.file", INTELLIJ_IDEA_CFG, flashPlayerTrustDir.getPath()));
                }
            }
            catch (IOException e) {
                FlashPlayerTrustUtil.showWarningBalloonIfNeeded(project, isDebug, runTrusted, FlexBundle.message("error.creating.idea.trust.cfg.file", INTELLIJ_IDEA_CFG, e.getMessage()));
                return null;
            }
        }
        return ideaTrustedCfgFile;
    }

    @Nullable
    private static File getFlashPlayerTrustDir(Project project, boolean isDebug, boolean runTrusted) {
        String flashPlayerTrustDirRelPath = SystemInfo.isWindows ? (SystemInfo.isWinVistaOrNewer ? WINDOWS_VISTA_AND_7_TRUST_DIR_REL_PATH : WINDOWS_XP_TRUST_DIR_REL_PATH) : (SystemInfo.isMac ? MAC_TRUST_DIR_REL_PATH : UNIX_TRUST_DIR_REL_PATH);
        File flashPlayerTrustDir = new File(SystemProperties.getUserHome() + flashPlayerTrustDirRelPath);
        if (!flashPlayerTrustDir.isDirectory()) {
            if (flashPlayerTrustDir.isFile()) {
                FlashPlayerTrustUtil.showWarningBalloonIfNeeded(project, isDebug, runTrusted, FlexBundle.message("flash.player.trust.folder.does.not.exist", new Object[0]));
                return null;
            }
            if (!flashPlayerTrustDir.mkdirs()) {
                FlashPlayerTrustUtil.showWarningBalloonIfNeeded(project, isDebug, runTrusted, FlexBundle.message("error.creating.flash.player.trust.folder", flashPlayerTrustDir));
                return null;
            }
        }
        return flashPlayerTrustDir;
    }

    private static void showWarningBalloonIfNeeded(Project project, boolean isDebug, boolean runTrusted, String message) {
        if (runTrusted) {
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
            manager.notifyByBalloon(isDebug ? ToolWindowId.DEBUG : ToolWindowId.RUN, MessageType.WARNING, message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "ideaCfgFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "trustedPaths";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/flex/run/FlashPlayerTrustUtil";
        objectArray[2] = "fixIdeaCfgFileContentIfNeeded";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

