/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.sdk;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkAdditionalData;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkDataConfigurable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.FlexIcons;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FlexmojosSdkType
extends SdkType {
    static final String COMPILER_POM_PATTERN_1 = ".+/com/adobe/flex/compiler/.+/compiler-.+\\.pom";
    static final String COMPILER_POM_PATTERN_2 = ".+/org/apache/flex/compiler/.+/compiler-.+\\.pom";

    public FlexmojosSdkType() {
        super("Flexmojos SDK Type");
    }

    public static FlexmojosSdkType getInstance() {
        return (FlexmojosSdkType)SdkType.findInstance(FlexmojosSdkType.class);
    }

    public String suggestHomePath() {
        return null;
    }

    public boolean isValidSdkHome(String _path) {
        String path = FileUtil.toSystemIndependentName((String)_path);
        return path.matches(COMPILER_POM_PATTERN_1) || path.matches(COMPILER_POM_PATTERN_2);
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return false;
            }
        };
        descriptor.setTitle("SDK of this type can only be created automatically during Maven project import.");
        FileChooserDescriptor fileChooserDescriptor = descriptor;
        if (fileChooserDescriptor == null) {
            FlexmojosSdkType.$$$reportNull$$$0(0);
        }
        return fileChooserDescriptor;
    }

    public String suggestSdkName(String currentSdkName, String sdkHome) {
        return "Flexmojos SDK " + this.getVersionString(sdkHome);
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            FlexmojosSdkType.$$$reportNull$$$0(1);
        }
        if (sdkModificator == null) {
            FlexmojosSdkType.$$$reportNull$$$0(2);
        }
        return new FlexmojosSdkDataConfigurable();
    }

    public SdkAdditionalData loadAdditionalData(Element element) {
        FlexmojosSdkAdditionalData additionalData = new FlexmojosSdkAdditionalData();
        additionalData.load(element);
        return additionalData;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element element) {
        if (additionalData == null) {
            FlexmojosSdkType.$$$reportNull$$$0(3);
        }
        if (element == null) {
            FlexmojosSdkType.$$$reportNull$$$0(4);
        }
        ((FlexmojosSdkAdditionalData)additionalData).save(element);
    }

    @NotNull
    public String getPresentableName() {
        if ("Flexmojos SDK" == null) {
            FlexmojosSdkType.$$$reportNull$$$0(5);
        }
        return "Flexmojos SDK";
    }

    @NotNull
    public String getHomeFieldLabel() {
        if ("Flex Compiler POM:" == null) {
            FlexmojosSdkType.$$$reportNull$$$0(6);
        }
        return "Flex Compiler POM:";
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            FlexmojosSdkType.$$$reportNull$$$0(7);
        }
        return false;
    }

    public Icon getIcon() {
        return FlexIcons.Flex.Sdk.MavenFlex;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.project.structure.sdk.flexmojos" == null) {
            FlexmojosSdkType.$$$reportNull$$$0(8);
        }
        return "reference.project.structure.sdk.flexmojos";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = this.getIcon();
        if (icon == null) {
            FlexmojosSdkType.$$$reportNull$$$0(9);
        }
        return icon;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        VirtualFile sdkRoot;
        if (sdk == null) {
            FlexmojosSdkType.$$$reportNull$$$0(10);
        }
        if ((sdkRoot = sdk.getHomeDirectory()) == null || !sdkRoot.isValid() || sdkRoot.isDirectory()) {
            return;
        }
        SdkModificator modificator = sdk.getSdkModificator();
        modificator.setVersionString(this.getVersionString(sdkRoot.getPath()));
        FlexmojosSdkAdditionalData data = (FlexmojosSdkAdditionalData)sdk.getSdkAdditionalData();
        if (data == null) {
            data = new FlexmojosSdkAdditionalData();
            modificator.setSdkAdditionalData((SdkAdditionalData)data);
        }
        data.setup(sdkRoot);
        modificator.commitChanges();
    }

    public String getVersionString(String sdkHome) {
        int index1 = sdkHome.lastIndexOf("compiler-");
        return index1 > 0 && sdkHome.endsWith(".pom") ? sdkHome.substring(index1 + "compiler-".length(), sdkHome.length() - ".pom".length()) : FlexBundle.message("flex.sdk.version.unknown", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/sdk/FlexmojosSdkType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/sdk/FlexmojosSdkType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeFieldLabel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconForAddAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

