/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.xml.XmlFile;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSQualifiedElementRenameProcessor
extends JSDefaultRenameProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        VirtualFile vFile;
        if (element == null) {
            JSQualifiedElementRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof JSQualifiedNamedElement && DialectDetector.isActionScript((PsiElement)element) && (element.getParent() instanceof JSPackageStatement || element instanceof JSClass) || (element instanceof JSFile && DialectDetector.isActionScript((PsiElement)element) || element instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)element))) && (vFile = ((PsiFile)element).getVirtualFile()) != null && ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getSourceRootForFile(vFile) != null;
    }

    public PsiElement substituteElementToRename(PsiElement element, Editor editor) {
        XmlBackedJSClass jsClass;
        if (element instanceof JSFileImpl) {
            JSNamedElement mainDeclaredElement = ActionScriptResolveUtil.findMainDeclaredElement((PsiFileImpl)((JSFileImpl)element));
            if (mainDeclaredElement != null) {
                return mainDeclaredElement;
            }
        } else if (element instanceof XmlFile && (jsClass = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)element))) != null) {
            return jsClass;
        }
        return super.substituteElementToRename(element, editor);
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        PsiFile containingFile;
        JSFunction constructor;
        if (element instanceof JSClass && (constructor = ((JSClass)element).getConstructor()) != null) {
            allRenames.put((PsiElement)constructor, newName);
        }
        if (element instanceof JSQualifiedNamedElement && (!((containingFile = element.getContainingFile()) instanceof JSFileImpl) || ActionScriptResolveUtil.findMainDeclaredElement((PsiFileImpl)((JSFileImpl)containingFile)) == element) && JSInheritedLanguagesHelper.shouldRenameFileWithClass((PsiElement)element)) {
            allRenames.put((PsiElement)containingFile, newName + "." + containingFile.getVirtualFile().getExtension());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JSQualifiedElementRenameProcessor", "canProcessElement"));
    }
}

