/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.uml.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.uml.actions.JSCreateFieldDialog;
import com.intellij.lang.javascript.uml.actions.NewJSMemberActionBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;

public class FlexCreateFieldFromDiagramAction
extends NewJSMemberActionBase {
    public FlexCreateFieldFromDiagramAction() {
        super(JSBundle.message((String)"new.field.action.text", (Object[])new Object[0]), JSBundle.message((String)"new.field.action.description", (Object[])new Object[0]), PlatformIcons.FIELD_ICON);
    }

    @Override
    public boolean isEnabledOn(Object o) {
        return super.isEnabledOn(o) && !((JSClass)o).isInterface();
    }

    public Runnable prepare(Object element, DiagramBuilder builder) {
        JSClass clazz = (JSClass)element;
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)clazz, null, (String)this.getTemplatePresentation().getText())) {
            return null;
        }
        JSCreateFieldDialog d = new JSCreateFieldDialog(clazz);
        if (!d.showAndGet()) {
            return null;
        }
        return () -> {
            if (d.getFieldType().contains(".")) {
                ImportUtils.doImport((PsiElement)clazz, (String)d.getFieldType(), (boolean)false);
            }
            StringBuilder var = new StringBuilder(JSVisibilityUtil.getVisibilityKeyword((JSAttributeList.AccessType)JSAttributeList.AccessType.valueOf((String)d.getVisibility())));
            var.append(" ");
            if (d.isStatic()) {
                var.append("static ");
            }
            var.append(d.isConstant() ? "const " : "var ");
            var.append(d.getFieldName()).append(":").append(d.getFieldType());
            if (StringUtil.isNotEmpty((String)d.getInitializer())) {
                var.append("=").append(d.getInitializer());
            }
            var.append(JSCodeStyleSettings.getSemicolon((PsiElement)clazz.getContainingFile()));
            JSVarStatement varStatement = (JSVarStatement)JSChangeUtil.createStatementFromText((Project)clazz.getProject(), (String)var.toString(), (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getPsi();
            JSRefactoringUtil.addMemberToTargetClass((JSClass)clazz, (PsiElement)varStatement);
            new ECMAScriptImportOptimizer().processFile(clazz.getContainingFile()).run();
        };
    }

    public String getActionName() {
        return JSBundle.message((String)"new.field.action.description", (Object[])new Object[0]);
    }
}

