/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.uml.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.uml.actions.JSCreateMethodDialog;
import com.intellij.lang.javascript.uml.actions.NewJSMemberActionBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public abstract class JSCreateMethodActionBase
extends NewJSMemberActionBase {
    protected static final JSAttributeList.AccessType PUBLIC = JSAttributeList.AccessType.PUBLIC;

    protected JSCreateMethodActionBase(String name, String description, Icon icon) {
        super(name, description, icon);
    }

    protected abstract boolean isForceConstructor();

    public Runnable prepare(Object element, DiagramBuilder builder) {
        JSClass clazz = (JSClass)element;
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)clazz, null, (String)this.getTemplatePresentation().getText())) {
            return null;
        }
        JSFunction fakeMethod = JSCreateMethodDialog.createFakeMethod(clazz, this.createFakeMethodText(clazz), false);
        JSCreateMethodDialog dialog = new JSCreateMethodDialog(clazz, fakeMethod, this.isForceConstructor());
        if (!dialog.showAndGet()) {
            return null;
        }
        return () -> {
            JSFunction method = dialog.createMethod();
            JSCreateMethodActionBase.importType(clazz, dialog.getReturnTypeText());
            for (JSParameterInfo param : dialog.getParameters()) {
                JSCreateMethodActionBase.importType(clazz, param.getTypeText());
            }
            PsiElement added = JSRefactoringUtil.addMemberToTargetClass((JSClass)clazz, (PsiElement)method);
            ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
            formatters.add(FormatFixer.create((PsiElement)added, (FormatFixer.Mode)FormatFixer.Mode.Reformat));
            formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat((PsiFile)clazz.getContainingFile()));
            FormatFixer.fixAll((List)FormatFixer.merge(formatters));
        };
    }

    protected String createFakeMethodText(JSClass clazz) {
        String visibility = clazz.isInterface() ? "" : JSVisibilityUtil.getVisibilityKeyword((JSAttributeList.AccessType)PUBLIC);
        return visibility + " function ()";
    }

    private static void importType(JSClass clazz, String typeText) {
        if (typeText.contains(".")) {
            ImportUtils.doImport((PsiElement)clazz, (String)typeText, (boolean)false);
        }
    }
}

