/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IErrorCounterReparseableElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.KotlinParser;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;

class LambdaExpressionElementType
extends IErrorCounterReparseableElementType {
    public LambdaExpressionElementType() {
        super("LAMBDA_EXPRESSION", (Language)KotlinLanguage.INSTANCE);
    }

    public ASTNode parseContents(ASTNode chameleon) {
        Project project = chameleon.getPsi().getProject();
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, null, (Language)KotlinLanguage.INSTANCE, chameleon.getChars());
        return KotlinParser.parseLambdaExpression(builder).getFirstChildNode();
    }

    public ASTNode createNode(CharSequence text2) {
        return new KtLambdaExpression(text2);
    }

    public boolean isParsable(@Nullable ASTNode parent2, CharSequence buffer, Language fileLanguage, Project project) {
        return super.isParsable(parent2, buffer, fileLanguage, project) && !LambdaExpressionElementType.wasArrowMovedOrDeleted(parent2, buffer);
    }

    private static boolean wasArrowMovedOrDeleted(@Nullable ASTNode parent2, CharSequence buffer) {
        IElementType oldType;
        if (parent2 == null) {
            return false;
        }
        PsiElement parentPsi = parent2.getPsi();
        KtLambdaExpression[] lambdaExpressions = (KtLambdaExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)parentPsi, KtLambdaExpression.class);
        if (lambdaExpressions == null || lambdaExpressions.length != 1) {
            return false;
        }
        KtLambdaExpression lambdaExpression2 = lambdaExpressions[0];
        KtFunctionLiteral literal = lambdaExpression2.getFunctionLiteral();
        PsiElement arrow = literal.getArrow();
        if (arrow == null) {
            return false;
        }
        int arrowOffset = arrow.getStartOffsetInParent() + literal.getStartOffsetInParent();
        KotlinLexer oldLexer = new KotlinLexer();
        oldLexer.start(lambdaExpression2.getText());
        KotlinLexer newLexer = new KotlinLexer();
        newLexer.start(buffer);
        while ((oldType = oldLexer.getTokenType()) != null) {
            IElementType newType = newLexer.getTokenType();
            if (newType == null) {
                return true;
            }
            if (newType != oldType) {
                if (newType == KtTokens.WHITE_SPACE) {
                    newLexer.advance();
                    continue;
                }
                if (oldType == KtTokens.WHITE_SPACE) {
                    oldLexer.advance();
                    continue;
                }
                return true;
            }
            if (oldType == KtTokens.ARROW && oldLexer.getCurrentPosition().getOffset() == arrowOffset) break;
            oldLexer.advance();
            newLexer.advance();
        }
        return false;
    }

    public int getErrorsCount(CharSequence seq, Language fileLanguage, Project project) {
        IElementType type2;
        KotlinLexer lexer = new KotlinLexer();
        lexer.start(seq);
        if (lexer.getTokenType() != KtTokens.LBRACE) {
            return Integer.MIN_VALUE;
        }
        lexer.advance();
        int balance = 1;
        while ((type2 = lexer.getTokenType()) != null) {
            if (balance == 0) {
                return Integer.MIN_VALUE;
            }
            if (type2 == KtTokens.LBRACE) {
                ++balance;
            } else if (type2 == KtTokens.RBRACE) {
                --balance;
            }
            lexer.advance();
        }
        return balance;
    }
}

