/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.NonReportingOverrideStrategy;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeImpl;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.ClassTypeConstructorImpl;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.utils.Printer;

public class EnumEntrySyntheticClassDescriptor
extends ClassDescriptorBase {
    private final TypeConstructor typeConstructor;
    private final ClassConstructorDescriptor primaryConstructor;
    private final MemberScope scope;
    private final NotNullLazyValue<Set<Name>> enumMemberNames;
    private final Annotations annotations;

    @NotNull
    public static EnumEntrySyntheticClassDescriptor create(@NotNull StorageManager storageManager, @NotNull ClassDescriptor enumClass, @NotNull Name name2, @NotNull NotNullLazyValue<Set<Name>> enumMemberNames2, @NotNull Annotations annotations2, @NotNull SourceElement source) {
        SimpleType enumType = enumClass.getDefaultType();
        return new EnumEntrySyntheticClassDescriptor(storageManager, enumClass, enumType, name2, enumMemberNames2, annotations2, source);
    }

    private EnumEntrySyntheticClassDescriptor(@NotNull StorageManager storageManager, @NotNull ClassDescriptor containingClass, @NotNull KotlinType supertype, @NotNull Name name2, @NotNull NotNullLazyValue<Set<Name>> enumMemberNames2, @NotNull Annotations annotations2, @NotNull SourceElement source) {
        super(storageManager, containingClass, name2, source, false);
        assert (containingClass.getKind() == ClassKind.ENUM_CLASS);
        this.annotations = annotations2;
        this.typeConstructor = new ClassTypeConstructorImpl(this, true, Collections.emptyList(), Collections.singleton(supertype));
        this.scope = new EnumEntryScope(storageManager);
        this.enumMemberNames = enumMemberNames2;
        ClassConstructorDescriptorImpl primaryConstructor2 = DescriptorFactory.createPrimaryConstructorForObject(this, source);
        primaryConstructor2.setReturnType(this.getDefaultType());
        this.primaryConstructor = primaryConstructor2;
    }

    @Override
    @NotNull
    public MemberScope getUnsubstitutedMemberScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public MemberScope getStaticScope() {
        return MemberScope.Empty.INSTANCE;
    }

    @Override
    @NotNull
    public Collection<ClassConstructorDescriptor> getConstructors() {
        return Collections.singleton(this.primaryConstructor);
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    @Override
    @Nullable
    public ClassDescriptor getCompanionObjectDescriptor() {
        return null;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return ClassKind.ENUM_ENTRY;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return Modality.FINAL;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return Visibilities.PUBLIC;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public boolean isCompanionObject() {
        return false;
    }

    @Override
    public boolean isExpect() {
        return false;
    }

    @Override
    public boolean isActual() {
        return false;
    }

    @Override
    @Nullable
    public ClassConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return "enum entry " + this.getName();
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getDeclaredTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> getSealedSubclasses() {
        return Collections.emptyList();
    }

    private class EnumEntryScope
    extends MemberScopeImpl {
        private final MemoizedFunctionToNotNull<Name, Collection<SimpleFunctionDescriptor>> functions;
        private final MemoizedFunctionToNotNull<Name, Collection<PropertyDescriptor>> properties;
        private final NotNullLazyValue<Collection<DeclarationDescriptor>> allDescriptors;

        public EnumEntryScope(StorageManager storageManager) {
            this.functions = storageManager.createMemoizedFunction(new Function1<Name, Collection<SimpleFunctionDescriptor>>(){

                public Collection<SimpleFunctionDescriptor> invoke(Name name2) {
                    return EnumEntryScope.this.computeFunctions(name2);
                }
            });
            this.properties = storageManager.createMemoizedFunction(new Function1<Name, Collection<PropertyDescriptor>>(){

                public Collection<PropertyDescriptor> invoke(Name name2) {
                    return EnumEntryScope.this.computeProperties(name2);
                }
            });
            this.allDescriptors = storageManager.createLazyValue(new Function0<Collection<DeclarationDescriptor>>(){

                public Collection<DeclarationDescriptor> invoke() {
                    return EnumEntryScope.this.computeAllDeclarations();
                }
            });
        }

        @NotNull
        public Collection getContributedVariables(@NotNull Name name2, @NotNull LookupLocation location2) {
            return (Collection)this.properties.invoke(name2);
        }

        @NotNull
        private Collection<PropertyDescriptor> computeProperties(@NotNull Name name2) {
            return this.resolveFakeOverrides(name2, this.getSupertypeScope().getContributedVariables(name2, NoLookupLocation.FOR_NON_TRACKED_SCOPE));
        }

        @NotNull
        public Collection getContributedFunctions(@NotNull Name name2, @NotNull LookupLocation location2) {
            return (Collection)this.functions.invoke(name2);
        }

        @NotNull
        private Collection<SimpleFunctionDescriptor> computeFunctions(@NotNull Name name2) {
            return this.resolveFakeOverrides(name2, this.getSupertypeScope().getContributedFunctions(name2, NoLookupLocation.FOR_NON_TRACKED_SCOPE));
        }

        @NotNull
        private MemberScope getSupertypeScope() {
            Collection<KotlinType> supertype = EnumEntrySyntheticClassDescriptor.this.getTypeConstructor().getSupertypes();
            assert (supertype.size() == 1) : "Enum entry and its companion object both should have exactly one supertype: " + supertype;
            return supertype.iterator().next().getMemberScope();
        }

        @NotNull
        private <D extends CallableMemberDescriptor> Collection<D> resolveFakeOverrides(@NotNull Name name2, @NotNull Collection<D> fromSupertypes) {
            final LinkedHashSet result2 = new LinkedHashSet();
            OverridingUtil.generateOverridesInFunctionGroup(name2, fromSupertypes, Collections.emptySet(), EnumEntrySyntheticClassDescriptor.this, new NonReportingOverrideStrategy(){

                @Override
                public void addFakeOverride(@NotNull CallableMemberDescriptor fakeOverride) {
                    OverridingUtil.resolveUnknownVisibilityForMember(fakeOverride, null);
                    result2.add(fakeOverride);
                }

                @Override
                protected void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                }
            });
            return result2;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter2) {
            return (Collection)this.allDescriptors.invoke();
        }

        @NotNull
        private Collection<DeclarationDescriptor> computeAllDeclarations() {
            HashSet<DeclarationDescriptor> result2 = new HashSet<DeclarationDescriptor>();
            for (Name name2 : (Set)EnumEntrySyntheticClassDescriptor.this.enumMemberNames.invoke()) {
                result2.addAll(this.getContributedFunctions(name2, NoLookupLocation.FOR_NON_TRACKED_SCOPE));
                result2.addAll(this.getContributedVariables(name2, NoLookupLocation.FOR_NON_TRACKED_SCOPE));
            }
            return result2;
        }

        @Override
        @NotNull
        public Set<Name> getFunctionNames() {
            return (Set)EnumEntrySyntheticClassDescriptor.this.enumMemberNames.invoke();
        }

        @Override
        @NotNull
        public Set<Name> getClassifierNames() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<Name> getVariableNames() {
            return (Set)EnumEntrySyntheticClassDescriptor.this.enumMemberNames.invoke();
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            p.println("enum entry scope for " + EnumEntrySyntheticClassDescriptor.this);
        }
    }
}

