/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.PackageOracle;
import org.jetbrains.kotlin.analyzer.PackageOracleFactory;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;
import org.jetbrains.kotlin.idea.caches.resolve.IdePackageOracleFactory$WhenMappings;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.PackageOraclesKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory;", "Lorg/jetbrains/kotlin/analyzer/PackageOracleFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createOracle", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "JavaPackagesOracle", "JvmSourceOracle", "KotlinSourceFilesOracle", "idea-core"})
public final class IdePackageOracleFactory
implements PackageOracleFactory {
    @NotNull
    private final Project project;

    @Override
    @NotNull
    public PackageOracle createOracle(@NotNull ModuleInfo moduleInfo) {
        PackageOracle packageOracle;
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
        if (!(moduleInfo instanceof IdeaModuleInfo)) {
            return PackageOracle.Optimistic.INSTANCE;
        }
        TargetPlatform targetPlatform = moduleInfo.getPlatform();
        if (Intrinsics.areEqual((Object)targetPlatform, (Object)JvmPlatform.INSTANCE)) {
            switch (IdePackageOracleFactory$WhenMappings.$EnumSwitchMapping$0[((IdeaModuleInfo)moduleInfo).getModuleOrigin().ordinal()]) {
                case 1: {
                    packageOracle = new JavaPackagesOracle((IdeaModuleInfo)moduleInfo, this.project);
                    break;
                }
                case 2: {
                    packageOracle = new JvmSourceOracle((ModuleSourceInfo)moduleInfo, this.project);
                    break;
                }
                case 3: {
                    packageOracle = PackageOracle.Optimistic.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        } else {
            switch (IdePackageOracleFactory$WhenMappings.$EnumSwitchMapping$1[((IdeaModuleInfo)moduleInfo).getModuleOrigin().ordinal()]) {
                case 1: {
                    packageOracle = new KotlinSourceFilesOracle((ModuleSourceInfo)moduleInfo);
                    break;
                }
                default: {
                    packageOracle = PackageOracle.Optimistic.INSTANCE;
                }
            }
        }
        return packageOracle;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public IdePackageOracleFactory(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$JavaPackagesOracle;", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "moduleInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/idea/caches/resolve/IdeaModuleInfo;Lcom/intellij/openapi/project/Project;)V", "facade", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "packageExists", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "idea-core"})
    private static final class JavaPackagesOracle
    implements PackageOracle {
        private final GlobalSearchScope scope;
        private final KotlinJavaPsiFacade facade;

        @Override
        public boolean packageExists(@NotNull FqName fqName2) {
            Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
            return this.facade.findPackage(fqName2.asString(), this.scope) != null;
        }

        public JavaPackagesOracle(@NotNull IdeaModuleInfo moduleInfo, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.scope = moduleInfo.contentScope();
            Project $receiver$iv = project;
            Object object = ServiceManager.getService((Project)$receiver$iv, KotlinJavaPsiFacade.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
            this.facade = (KotlinJavaPsiFacade)object;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$KotlinSourceFilesOracle;", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "moduleInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleSourceInfo;", "(Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleSourceInfo;)V", "cacheService", "Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService;", "packageExists", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "idea-core"})
    private static final class KotlinSourceFilesOracle
    implements PackageOracle {
        private final PerModulePackageCacheService cacheService;
        private final ModuleSourceInfo moduleInfo;

        @Override
        public boolean packageExists(@NotNull FqName fqName2) {
            Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
            return this.cacheService.packageExists(fqName2, this.moduleInfo);
        }

        public KotlinSourceFilesOracle(@NotNull ModuleSourceInfo moduleInfo) {
            Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
            this.moduleInfo = moduleInfo;
            Project project = this.moduleInfo.getModule().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"moduleInfo.module.project");
            Project $receiver$iv = project;
            Object object = ServiceManager.getService((Project)$receiver$iv, PerModulePackageCacheService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
            this.cacheService = (PerModulePackageCacheService)object;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$JvmSourceOracle;", "Lorg/jetbrains/kotlin/analyzer/PackageOracle;", "moduleInfo", "Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleSourceInfo;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/idea/caches/resolve/ModuleSourceInfo;Lcom/intellij/openapi/project/Project;)V", "javaPackagesOracle", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$JavaPackagesOracle;", "kotlinSourceOracle", "Lorg/jetbrains/kotlin/idea/caches/resolve/IdePackageOracleFactory$KotlinSourceFilesOracle;", "packageExists", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "idea-core"})
    private static final class JvmSourceOracle
    implements PackageOracle {
        private final JavaPackagesOracle javaPackagesOracle;
        private final KotlinSourceFilesOracle kotlinSourceOracle;

        @Override
        public boolean packageExists(@NotNull FqName fqName2) {
            Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
            return this.javaPackagesOracle.packageExists(fqName2) || this.kotlinSourceOracle.packageExists(fqName2) || FqNamesUtilKt.isSubpackageOf(fqName2, PackageOraclesKt.access$getANDROID_SYNTHETIC_PACKAGE_PREFIX$p());
        }

        public JvmSourceOracle(@NotNull ModuleSourceInfo moduleInfo, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.javaPackagesOracle = new JavaPackagesOracle(moduleInfo, project);
            this.kotlinSourceOracle = new KotlinSourceFilesOracle(moduleInfo);
        }
    }
}

