/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.intentions.ChooseValueExpression;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SpecifyTypeExplicitlyIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "idea"})
public final class SpecifyTypeExplicitlyIntention
extends SelfTargetingRangeIntention<KtCallableDeclaration>
implements LowPriorityAction {
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtCallableDeclaration element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (element3.getContainingFile() instanceof KtCodeFragment) {
            return null;
        }
        if (element3 instanceof KtFunctionLiteral) {
            return null;
        }
        if (element3 instanceof KtConstructor) {
            return null;
        }
        if (element3.getTypeReference() != null) {
            return null;
        }
        if (KotlinTypeKt.isError(Companion.getTypeForDeclaration(element3))) {
            return null;
        }
        if (element3 instanceof KtNamedFunction && ((KtNamedFunction)element3).hasBlockBody()) {
            return null;
        }
        this.setText(element3 instanceof KtFunction ? "Specify return type explicitly" : "Specify type explicitly");
        KtCallableDeclaration ktCallableDeclaration = element3;
        if (!(ktCallableDeclaration instanceof KtDeclarationWithInitializer)) {
            ktCallableDeclaration = null;
        }
        KtDeclarationWithInitializer ktDeclarationWithInitializer = (KtDeclarationWithInitializer)((Object)ktCallableDeclaration);
        KtExpression initializer2 = ktDeclarationWithInitializer != null ? ktDeclarationWithInitializer.getInitializer() : null;
        return initializer2 != null ? new TextRange(PsiUtilsKt.getStartOffset(element3), PsiUtilsKt.getStartOffset((PsiElement)initializer2) - 1) : new TextRange(PsiUtilsKt.getStartOffset(element3), PsiUtilsKt.getEndOffset(element3));
    }

    @Override
    public void applyTo(@NotNull KtCallableDeclaration element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KotlinType type2 = Companion.getTypeForDeclaration(element3);
        Companion.addTypeAnnotation(editor, element3, type2);
    }

    public SpecifyTypeExplicitlyIntention() {
        super(KtCallableDeclaration.class, "Specify type explicitly", null, 4, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J \u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rJ \u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SpecifyTypeExplicitlyIntention$Companion;", "", "()V", "setterType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getSetterType", "(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;)Lorg/jetbrains/kotlin/types/KotlinType;", "addTypeAnnotation", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "exprType", "addTypeAnnotationWithTemplate", "createTypeExpressionForTemplate", "Lcom/intellij/codeInsight/template/Expression;", "contextElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "createTypeReferencePostprocessor", "Lcom/intellij/codeInsight/template/TemplateEditingAdapter;", "dangerousFlexibleTypeOrNull", "publicAPIOnly", "", "reportPlatformArguments", "getTypeForDeclaration", "TypeChooseValueExpression", "idea"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final KotlinType getSetterType(@NotNull PropertyDescriptor $receiver) {
            Object object;
            Object object2 = $receiver.getSetter();
            if (object2 != null && (object2 = object2.getValueParameters()) != null && (object2 = (ValueParameterDescriptor)CollectionsKt.firstOrNull((List)object2)) != null && (object2 = object2.getType()) != null) {
                void var3_3;
                Object object3;
                Object it;
                Object object4 = it = (object3 = object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"it");
                object = KotlinTypeKt.isError((KotlinType)object4) ? null : var3_3;
            } else {
                object = null;
            }
            return object;
        }

        @Nullable
        public final KotlinType dangerousFlexibleTypeOrNull(@NotNull KtCallableDeclaration declaration2, boolean publicAPIOnly, boolean reportPlatformArguments) {
            DeclarationDescriptor declarationDescriptor;
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            KtCallableDeclaration ktCallableDeclaration = declaration2;
            if (ktCallableDeclaration instanceof KtFunction) {
                if (((KtFunction)declaration2).isLocal() || ((KtFunction)declaration2).hasDeclaredReturnType()) {
                    return null;
                }
            } else if (ktCallableDeclaration instanceof KtProperty) {
                if (((KtProperty)declaration2).isLocal() || ((KtProperty)declaration2).getTypeReference() != null) {
                    return null;
                }
            } else {
                return null;
            }
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(declaration2);
            if (ktClassOrObject != null) {
                if (ktClassOrObject.isLocal()) {
                    return null;
                }
            }
            if (!((declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(declaration2, null, 1, null)) instanceof CallableDescriptor)) {
                declarationDescriptor = null;
            }
            CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
            if (callableDescriptor == null) {
                return null;
            }
            CallableDescriptor callable2 = callableDescriptor;
            if (publicAPIOnly && !callable2.getVisibility().isPublicAPI()) {
                return null;
            }
            KotlinType kotlinType = callable2.getReturnType();
            if (kotlinType == null) {
                return null;
            }
            KotlinType type2 = kotlinType;
            if (reportPlatformArguments) {
                KotlinType kotlinType2 = type2;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
                if (!UtilsKt.isFlexibleRecursive(kotlinType2)) {
                    return null;
                }
            } else {
                KotlinType kotlinType3 = type2;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"type");
                if (!FlexibleTypesKt.isFlexible(kotlinType3)) {
                    return null;
                }
            }
            return type2;
        }

        @NotNull
        public final KotlinType getTypeForDeclaration(@NotNull KtCallableDeclaration declaration2) {
            KotlinType type2;
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default(declaration2, null, 1, null);
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (!(declarationDescriptor instanceof CallableDescriptor)) {
                declarationDescriptor = null;
            }
            CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
            KotlinType kotlinType = type2 = callableDescriptor != null ? callableDescriptor.getReturnType() : null;
            if (type2 != null && KotlinTypeKt.isError(type2) && descriptor2 instanceof PropertyDescriptor) {
                KotlinType kotlinType2 = this.getSetterType((PropertyDescriptor)descriptor2);
                if (kotlinType2 == null) {
                    SimpleType simpleType2 = ErrorUtils.createErrorType("null type");
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"ErrorUtils.createErrorType(\"null type\")");
                    kotlinType2 = simpleType2;
                }
                return kotlinType2;
            }
            KotlinType kotlinType3 = type2;
            if (kotlinType3 == null) {
                SimpleType simpleType3 = ErrorUtils.createErrorType("null type");
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"ErrorUtils.createErrorType(\"null type\")");
                kotlinType3 = simpleType3;
            }
            return kotlinType3;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Expression createTypeExpressionForTemplate(@NotNull KotlinType exprType, @NotNull KtElement contextElement) {
            void $receiver$iv;
            List list2;
            Collection collection;
            DeclarationDescriptor owner;
            Intrinsics.checkParameterIsNotNull((Object)exprType, (String)"exprType");
            Intrinsics.checkParameterIsNotNull((Object)contextElement, (String)"contextElement");
            ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade(contextElement);
            BindingContext bindingContext2 = resolutionFacade.analyze(contextElement, BodyResolveMode.PARTIAL);
            LexicalScope scope2 = ScopeUtils.getResolutionScope((PsiElement)contextElement, bindingContext2, resolutionFacade);
            boolean checkTypeParameters = true;
            ClassifierDescriptor descriptor2 = exprType.getConstructor().getDeclarationDescriptor();
            if (descriptor2 != null && descriptor2 instanceof TypeParameterDescriptor && (owner = ((TypeParameterDescriptor)descriptor2).getContainingDeclaration()) instanceof FunctionDescriptor && ((FunctionDescriptor)owner).getTypeParameters().contains(descriptor2)) {
                checkTypeParameters = false;
            }
            List $receiver = collection = SequencesKt.toList((Sequence)TypeUtils.getResolvableApproximations$default(exprType, scope2, checkTypeParameters, false, 4, null));
            if (FlexibleTypesKt.isNullabilityFlexible(exprType)) {
                void $receiver$iv$iv;
                Iterable $receiver$iv2;
                Iterable iterable = $receiver$iv2 = (Iterable)$receiver;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    KotlinType it = (KotlinType)element$iv$iv;
                    Iterable list$iv$iv = CollectionsKt.listOf((Object[])new KotlinType[]{org.jetbrains.kotlin.types.TypeUtils.makeNotNullable(it), org.jetbrains.kotlin.types.TypeUtils.makeNullable(it)});
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = $receiver;
            }
            collection = list2;
            if ($receiver$iv.isEmpty()) {
                return null;
            }
            List types = (List)$receiver$iv;
            Object object = CollectionsKt.first((List)types);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"types.first()");
            return new TypeChooseValueExpression(types, (KotlinType)object);
        }

        public final void addTypeAnnotation(@Nullable Editor editor, @NotNull KtCallableDeclaration declaration2, @NotNull KotlinType exprType) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)exprType, (String)"exprType");
            if (editor != null) {
                this.addTypeAnnotationWithTemplate(editor, declaration2, exprType);
            } else {
                PsiModificationUtilsKt.setType$default(declaration2, exprType, false, 2, null);
            }
        }

        @NotNull
        public final TemplateEditingAdapter createTypeReferencePostprocessor(@NotNull KtCallableDeclaration declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            return new TemplateEditingAdapter(declaration2){
                final /* synthetic */ KtCallableDeclaration $declaration;

                public void templateFinished(@Nullable Template template2, boolean brokenOff) {
                    KtTypeReference typeRef = this.$declaration.getTypeReference();
                    if (typeRef != null && typeRef.isValid()) {
                        ApplicationUtilsKt.runWriteAction((Function0)new Function0<KtElement>(typeRef){
                            final /* synthetic */ KtTypeReference $typeRef;

                            @NotNull
                            public final KtElement invoke() {
                                return ShortenReferences.process$default(ShortenReferences.DEFAULT, this.$typeRef, null, 2, null);
                            }
                            {
                                this.$typeRef = ktTypeReference;
                                super(0);
                            }
                        });
                    }
                }
                {
                    this.$declaration = $captured_local_variable$0;
                }
            };
        }

        private final void addTypeAnnotationWithTemplate(Editor editor, KtCallableDeclaration declaration2, KotlinType exprType) {
            boolean bl;
            boolean bl2 = bl = !KotlinTypeKt.isError(exprType);
            if (_Assertions.ENABLED && !bl) {
                String string = "Unexpected error type, should have been checked before: " + PsiUtilsKt.getElementTextWithContext(declaration2) + ", type = " + exprType;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Project project = declaration2.getProject();
            Expression expression2 = this.createTypeExpressionForTemplate(exprType, declaration2);
            if (expression2 == null) {
                return;
            }
            Expression expression3 = expression2;
            String string = KotlinBuiltIns.FQ_NAMES.any.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinBuiltIns.FQ_NAMES.any.asString()");
            PsiModificationUtilsKt.setType$default(declaration2, string, false, 2, null);
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            KtTypeReference ktTypeReference = declaration2.getTypeReference();
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            KtTypeReference newTypeRef = ktTypeReference;
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)newTypeRef);
            builder.replaceElement((PsiElement)newTypeRef, expression3);
            CaretModel caretModel = editor.getCaretModel();
            KtTypeReference ktTypeReference2 = newTypeRef;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference2, (String)"newTypeRef");
            ASTNode aSTNode = ktTypeReference2.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"newTypeRef.node");
            caretModel.moveToOffset(aSTNode.getStartOffset());
            TemplateManager.getInstance((Project)project).startTemplate(editor, builder.buildInlineTemplate(), (TemplateEditingListener)this.createTypeReferencePostprocessor(declaration2));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SpecifyTypeExplicitlyIntention$Companion$TypeChooseValueExpression;", "Lorg/jetbrains/kotlin/idea/intentions/ChooseValueExpression;", "Lorg/jetbrains/kotlin/types/KotlinType;", "items", "", "defaultItem", "(Ljava/util/List;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getLookupString", "", "element", "getResult", "idea"})
        private static final class TypeChooseValueExpression
        extends ChooseValueExpression<KotlinType> {
            @Override
            @NotNull
            protected String getLookupString(@NotNull KotlinType element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                return IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(element3);
            }

            @Override
            @NotNull
            protected String getResult(@NotNull KotlinType element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                return IdeDescriptorRenderers.SOURCE_CODE.renderType(element3);
            }

            public TypeChooseValueExpression(@NotNull List<? extends KotlinType> items, @NotNull KotlinType defaultItem) {
                Intrinsics.checkParameterIsNotNull(items, (String)"items");
                Intrinsics.checkParameterIsNotNull((Object)defaultItem, (String)"defaultItem");
                super(items, defaultItem, null, 4, null);
            }
        }
    }
}

